/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.cpaParam;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkCPAstatoil;
import neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.cpaParam.CPAFunction;
import neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.cpaParam.CPAFunctionCp;
import neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.cpaParam.CPAFunctionDens;
import neqsim.util.database.NeqSimExperimentDatabase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestCPA_TEG {
    static Logger logger = LogManager.getLogger(TestCPA_TEG.class);

    public static void main(String[] args) {
        double dens;
        double[] standardDeviation1;
        double[] sample1;
        double temp;
        SystemSrkCPAstatoil testSystem;
        CPAFunction function;
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimExperimentDatabase database = new NeqSimExperimentDatabase();
        double[] guess = new double[]{0.28454, -0.0044236};
        ResultSet dataSet = database.getResultSet("SELECT * FROM PureComponentVapourPressures WHERE ComponentName='TEG' AND Temperature>273.15 AND Temperature<690.0 ORDER BY Temperature");
        try {
            while (!dataSet.next()) {
                function = new CPAFunction();
                testSystem = new SystemSrkCPAstatoil(Double.parseDouble(dataSet.getString("Temperature")), Double.parseDouble(dataSet.getString("VapourPressure")));
                testSystem.addComponent(dataSet.getString("ComponentName"), 1.0);
                testSystem.createDatabase(true);
                testSystem.setMixingRule(2);
                temp = testSystem.getTemperature();
                double val = testSystem.getPressure();
                sample1 = new double[]{temp};
                standardDeviation1 = new double[]{0.1};
                double stddev = val / 50.0;
                double logVal = Math.log(val);
                SampleValue sample = new SampleValue(val, stddev, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                function.setInitialGuess(guess);
                sample.setReference(dataSet.getString("Reference"));
                sampleList.add(sample);
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        dataSet = database.getResultSet("SELECT * FROM PureComponentDensity WHERE ComponentName='MEG' AND Temperature>173.15 ORDER BY Temperature");
        try {
            while (dataSet.next()) {
                function = new CPAFunctionDens(1);
                testSystem = new SystemSrkCPAstatoil(Double.parseDouble(dataSet.getString("Temperature")), 1.1);
                temp = testSystem.getTemperature();
                testSystem.addComponent(dataSet.getString("ComponentName"), 100.0);
                testSystem.createDatabase(true);
                testSystem.setPressure(Double.parseDouble(dataSet.getString("Pressure")));
                testSystem.setTemperature(temp);
                testSystem.setMixingRule(1);
                dens = Double.parseDouble(dataSet.getString("Density"));
                sample1 = new double[]{temp};
                standardDeviation1 = new double[]{0.1};
                SampleValue sample = new SampleValue(dens, dens / 100.0, sample1, standardDeviation1);
                function.setInitialGuess(guess);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sample.setReference(dataSet.getString("Reference"));
                sampleList.add(sample);
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        dataSet = database.getResultSet("SELECT * FROM PureComponentCpHeatCapacity WHERE ComponentName='TEG' AND Temperature>263.15 ORDER BY Temperature");
        try {
            while (!dataSet.next()) {
                function = new CPAFunctionCp(1);
                testSystem = new SystemSrkCPAstatoil(Double.parseDouble(dataSet.getString("Temperature")), 1.1);
                temp = testSystem.getTemperature();
                testSystem.addComponent(dataSet.getString("ComponentName"), 100.0);
                testSystem.createDatabase(true);
                testSystem.setPressure(Double.parseDouble(dataSet.getString("Pressure")));
                testSystem.setTemperature(temp);
                testSystem.setMixingRule(1);
                dens = Double.parseDouble(dataSet.getString("HeatCapacityCp"));
                sample1 = new double[]{temp};
                standardDeviation1 = new double[]{0.1};
                SampleValue sample = new SampleValue(dens, dens / 100.0, sample1, standardDeviation1);
                function.setInitialGuess(guess);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sample.setReference(dataSet.getString("Reference"));
                sampleList.add(sample);
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        LevenbergMarquardt optim = new LevenbergMarquardt();
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayResult();
        optim.displayCurveFit();
        optim.writeToTextFile("c:/test.txt");
    }
}

