/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.acentricFactorFitting;

import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkSchwartzentruberEos;
import neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.acentricFactorFitting.AcentricFunctionScwartzentruber;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestFitToAntoineVapPres {
    static Logger logger = LogManager.getLogger(TestFitToAntoineVapPres.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        try {
            for (int i = 0; i < 30; ++i) {
                AcentricFunctionScwartzentruber function = new AcentricFunctionScwartzentruber();
                double[] guess = new double[]{0.1032, 0.00365, -2.064};
                function.setInitialGuess(guess);
                SystemSrkSchwartzentruberEos testSystem = new SystemSrkSchwartzentruberEos(273.15 + (double)(i * 5), 1.101);
                testSystem.addComponent("AceticAcid", 100.0);
                testSystem.createDatabase(true);
                testSystem.setMixingRule(0);
                SystemSrkSchwartzentruberEos testSystemAntoine = new SystemSrkSchwartzentruberEos(273.15 + (double)(i * 5), 1.101);
                testSystemAntoine.addComponent("AceticAcid", 100.0);
                testSystemAntoine.setMixingRule(0);
                ThermodynamicOperations opsAntione = new ThermodynamicOperations(testSystemAntoine);
                double[] sample1 = new double[]{(double)(i * 5) + 273.15};
                double[] standardDeviation1 = new double[]{0.1, 0.1, 0.1};
                double val = Math.log(testSystemAntoine.getPhase(0).getComponent(0).getAntoineVaporPressure(273.15 + (double)(i * 5)));
                SampleValue sample = new SampleValue(val, val / 100.0, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception ex) {
            logger.info("database error" + ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.displayCurveFit();
    }
}

