/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.ionicInteractionCoefficientFitting;

import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardtFunction;
import neqsim.thermo.ThermodynamicConstantsInterface;
import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.mixingRule.HVmixingRuleInterface;
import neqsim.thermo.phase.PhaseEosInterface;
import neqsim.thermo.phase.PhaseModifiedFurstElectrolyteEos;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IonicInteractionParameterFittingFunction_Sleipner
extends LevenbergMarquardtFunction
implements ThermodynamicConstantsInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(IonicInteractionParameterFittingFunction_Sleipner.class);

    @Override
    public double calcValue(double[] dependentValues) {
        try {
            this.thermoOps.bubblePointPressureFlash(false);
        }
        catch (Exception ex) {
            logger.error(ex.toString());
        }
        return this.system.getPressure();
    }

    @Override
    public double calcTrueValue(double val) {
        return val;
    }

    @Override
    public void setFittingParams(int i, double value) {
        this.params[i] = value;
        int MDEAplusNumb = 0;
        int MDEANumb = 0;
        int AcidNumb = 0;
        int AcidnegNumb = 0;
        int j = 0;
        do {
            MDEAplusNumb = j++;
        } while (!this.system.getPhases()[1].getComponents()[j - 1].getComponentName().equals("MDEA+"));
        j = 0;
        do {
            MDEANumb = j++;
        } while (!this.system.getPhases()[1].getComponents()[j - 1].getComponentName().equals("MDEA"));
        j = 0;
        do {
            AcidNumb = j++;
        } while (!this.system.getPhases()[1].getComponents()[j - 1].getComponentName().equals("AceticAcid"));
        j = 0;
        do {
            AcidnegNumb = j++;
        } while (!this.system.getPhases()[1].getComponents()[j - 1].getComponentName().equals("Ac-"));
        if (i == 1) {
            ((PhaseModifiedFurstElectrolyteEos)this.system.getPhases()[0]).getElectrolyteMixingRule().setWijParameter(AcidnegNumb, MDEAplusNumb, value);
            ((PhaseModifiedFurstElectrolyteEos)this.system.getPhases()[1]).getElectrolyteMixingRule().setWijParameter(AcidnegNumb, MDEAplusNumb, value);
        }
        if (i == 0) {
            ((PhaseModifiedFurstElectrolyteEos)this.system.getPhases()[0]).getElectrolyteMixingRule().setWijParameter(MDEAplusNumb, AcidNumb, value);
            ((PhaseModifiedFurstElectrolyteEos)this.system.getPhases()[1]).getElectrolyteMixingRule().setWijParameter(MDEAplusNumb, AcidNumb, value);
        }
        if (i == 2) {
            double a1 = ((ComponentEosInterface)this.system.getPhases()[1].getComponent(AcidNumb)).geta();
            double a2 = ((ComponentEosInterface)this.system.getPhases()[1].getComponent(MDEANumb)).geta();
            double b1 = ((ComponentEosInterface)this.system.getPhases()[1].getComponent(AcidNumb)).getb();
            double b2 = ((ComponentEosInterface)this.system.getPhases()[1].getComponent(MDEANumb)).getb();
            double g11 = -a1 / b1 * Math.log(2.0);
            double g22 = -a2 / b2 * Math.log(2.0);
            double g12 = -2.0 * Math.sqrt(b1 * b2) / (b1 + b2) * Math.sqrt(g11 * g22) * (1.0 - value);
            double para0 = (g12 - g22) / 8.3144621;
            double para1 = (g12 - g11) / 8.3144621;
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[0]).getMixingRule()).setHValphaParameter(AcidNumb, MDEANumb, 0.0);
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[1]).getMixingRule()).setHValphaParameter(AcidNumb, MDEANumb, 0.0);
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[0]).getMixingRule()).setHVDijParameter(AcidNumb, MDEANumb, para0);
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[1]).getMixingRule()).setHVDijParameter(AcidNumb, MDEANumb, para0);
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[0]).getMixingRule()).setHVDijParameter(MDEANumb, AcidNumb, para1);
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[1]).getMixingRule()).setHVDijParameter(MDEANumb, AcidNumb, para1);
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[0]).getMixingRule()).setHVDijTParameter(AcidNumb, MDEANumb, 0.0);
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[1]).getMixingRule()).setHVDijTParameter(AcidNumb, MDEANumb, 0.0);
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[0]).getMixingRule()).setHVDijTParameter(MDEANumb, AcidNumb, 0.0);
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[1]).getMixingRule()).setHVDijTParameter(MDEANumb, AcidNumb, 0.0);
        }
    }
}

