/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.HuronVidalParameterFitting;

import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkSchwartzentruberEos;
import neqsim.thermo.system.SystemUNIFACpsrk;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.HuronVidalParameterFitting.BinaryHVparameterFitToActivityCoefficientFunction;

public class TestBinaryHVfitToActivityUNIFAC
implements Cloneable {
    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        int numb = 0;
        for (int i = 0; i < 20; ++i) {
            ++numb;
            BinaryHVparameterFitToActivityCoefficientFunction function = new BinaryHVparameterFitToActivityCoefficientFunction();
            SystemSrkSchwartzentruberEos testSystem = new SystemSrkSchwartzentruberEos(273.0 + (double)(i * 5), 1.01);
            testSystem.addComponent("Piperazine", 1.0);
            testSystem.addComponent("AceticAcid", 1000.0);
            testSystem.createDatabase(true);
            testSystem.setMixingRule(4);
            testSystem.init(0);
            SystemUNIFACpsrk testSystem2 = new SystemUNIFACpsrk(273.0 + (double)(i * 5), 1.01);
            testSystem2.addComponent("Piperazine", 1.0);
            testSystem2.addComponent("AceticAcid", 1000.0);
            testSystem2.createDatabase(true);
            testSystem2.setMixingRule(2);
            testSystem2.init(0);
            testSystem2.init(1);
            double activ = testSystem2.getPhase(1).getActivityCoefficient(0);
            double[] parameterGuess = new double[]{-460.679072303, 120.64471708, -3.89, 1.9};
            function.setInitialGuess(parameterGuess);
            double[] sample1 = new double[]{(double)numb / 1000.0, testSystem.getTemperature()};
            double[] standardDeviation1 = new double[]{1.0};
            SampleValue sample = new SampleValue(activ, activ / 1000.0, sample1, standardDeviation1);
            sample.setFunction(function);
            sample.setThermodynamicSystem(testSystem);
            sampleList.add(sample);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayCurveFit();
        optim.writeToTextFile("c:/testFit.txt");
    }
}

