/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.Procede.WaterMDEA;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.ResultSet;
import neqsim.thermo.system.SystemSrkSchwartzentruberEos;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Water_MDEA {
    static Logger logger = LogManager.getLogger(Water_MDEA.class);

    public static void main(String[] args) {
        double pressure = 1.0;
        double temperature = 298.16;
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM WaterMDEA");
        block11: while (true) {
            try {
                while (dataSet.next()) {
                    double ID = Double.parseDouble(dataSet.getString("ID"));
                    pressure = Double.parseDouble(dataSet.getString("Pressure"));
                    temperature = Double.parseDouble(dataSet.getString("Temperature"));
                    double x1 = Double.parseDouble(dataSet.getString("x1"));
                    double x2 = Double.parseDouble(dataSet.getString("x2"));
                    SystemSrkSchwartzentruberEos testSystem = new SystemSrkSchwartzentruberEos(298.0, pressure);
                    testSystem.addComponent("water", x1);
                    testSystem.addComponent("MDEA", x2);
                    testSystem.createDatabase(true);
                    testSystem.setMixingRule(4);
                    testSystem.init(0);
                    ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
                    try {
                        testOps.bubblePointPressureFlash(false);
                    }
                    catch (Exception ex) {
                        logger.error(ex.toString());
                    }
                    double hm = testSystem.getPhase(1).getEnthalpy();
                    logger.info(hm);
                    try {
                        PrintStream p = new PrintStream(new FileOutputStream("C:/java/NeqSimSource/water_MDEA.txt", true));
                        try {
                            p.println(ID + " " + pressure + " " + testSystem.getPressure());
                            continue block11;
                        }
                        finally {
                            p.close();
                            continue block11;
                        }
                    }
                    catch (FileNotFoundException ex) {
                        logger.error("Could not find file", (Throwable)ex);
                    }
                }
                break;
            }
            catch (Exception ex) {
                logger.error("database error" + ex);
                break;
            }
        }
        logger.info("Finished");
    }
}

