/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.Procede.CO2WaterMDEA;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import neqsim.thermo.system.SystemFurstElectrolyteEos;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CO2_MDEA_speciation {
    static Logger logger = LogManager.getLogger(CO2_MDEA_speciation.class);

    public static void main(String[] args) {
        PrintStream p;
        boolean i = false;
        int CO2Numb = 0;
        int WaterNumb = 0;
        int MDEANumb = 0;
        int HCO3Numb = 0;
        int MDEAHpNumb = 0;
        int CO3Numb = 0;
        int OHNumb = 0;
        double MDEAwt = 42.313781;
        double loading = 0.43194;
        double temperature = 338.16;
        double pressure = 0.01;
        double n3 = MDEAwt / 119.16;
        double n2 = (100.0 - MDEAwt) / 18.015;
        double n1 = n3 * loading;
        double total = n1 + n2 + n3;
        double x1 = n1 / total;
        double x2 = n2 / total;
        double x3 = n3 / total;
        double mass = x1 * 44.01 + x2 * 18.015 + x3 * 119.1632;
        SystemFurstElectrolyteEos testSystem = new SystemFurstElectrolyteEos(temperature, pressure);
        testSystem.addComponent("CO2", x1);
        testSystem.addComponent("MDEA", x3);
        testSystem.addComponent("water", x2);
        testSystem.chemicalReactionInit();
        testSystem.createDatabase(true);
        testSystem.setMixingRule(4);
        testSystem.init(0);
        int j = 0;
        do {
            CO2Numb = j++;
        } while (!testSystem.getPhases()[1].getComponents()[j - 1].getComponentName().equals("CO2"));
        j = 0;
        do {
            MDEANumb = j++;
        } while (!testSystem.getPhases()[1].getComponents()[j - 1].getComponentName().equals("MDEA"));
        j = 0;
        do {
            WaterNumb = j++;
        } while (!testSystem.getPhases()[1].getComponents()[j - 1].getComponentName().equals("water"));
        j = 0;
        do {
            HCO3Numb = j++;
        } while (!testSystem.getPhases()[1].getComponents()[j - 1].getComponentName().equals("HCO3-"));
        j = 0;
        do {
            CO3Numb = j++;
        } while (!testSystem.getPhases()[1].getComponents()[j - 1].getComponentName().equals("CO3--"));
        j = 0;
        do {
            OHNumb = j++;
        } while (!testSystem.getPhases()[1].getComponents()[j - 1].getComponentName().equals("OH-"));
        j = 0;
        do {
            MDEAHpNumb = j++;
        } while (!testSystem.getPhases()[1].getComponents()[j - 1].getComponentName().equals("MDEA+"));
        logger.info("CO2 number " + CO2Numb);
        ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
        try {
            testOps.bubblePointPressureFlash(false);
        }
        catch (Exception ex) {
            logger.error(ex.toString());
        }
        logger.info("Pressure " + testSystem.getPressure());
        double nCO2 = testSystem.getPhase(1).getComponent(CO2Numb).getx();
        double nMDEA = testSystem.getPhase(1).getComponent(MDEANumb).getx();
        double nHCO3 = testSystem.getPhase(1).getComponent(HCO3Numb).getx();
        double nCO3 = testSystem.getPhase(1).getComponent(CO3Numb).getx();
        double nMDEAp = testSystem.getPhase(1).getComponent(MDEAHpNumb).getx();
        double nOH = testSystem.getPhase(1).getComponent(OHNumb).getx();
        double aMDEA = testSystem.getPhase(1).getActivityCoefficient(MDEANumb, WaterNumb);
        double awater = testSystem.getPhase(1).getActivityCoefficient(WaterNumb);
        double aCO2 = testSystem.getPhase(1).getActivityCoefficient(CO2Numb, WaterNumb);
        double aMDEAp = testSystem.getPhase(1).getActivityCoefficient(MDEAHpNumb, WaterNumb);
        double aHCO3 = testSystem.getPhase(1).getActivityCoefficient(HCO3Numb, WaterNumb);
        double aOH = testSystem.getPhase(1).getActivityCoefficient(OHNumb, WaterNumb);
        double aCO3 = testSystem.getPhase(1).getActivityCoefficient(CO3Numb, WaterNumb);
        try {
            p = new PrintStream(new FileOutputStream("C:/java/NeqSimSource/Patrick.txt", true));
            try {
                p.println(loading + " " + testSystem.getPressure() + " " + testSystem.getPressure() * testSystem.getPhase(0).getComponent(CO2Numb).getx() + " " + nCO2 + " " + nMDEA + " " + nHCO3 + " " + nMDEAp + " " + nCO3 + " " + nOH);
            }
            finally {
                p.close();
            }
        }
        catch (FileNotFoundException ex) {
            logger.error("Could not find file");
            logger.error("Could not read from Patrick.txt" + ex.getMessage());
        }
        try {
            p = new PrintStream(new FileOutputStream("C:/java/NeqSimSource/activity.txt", true));
            try {
                p.println(loading + " " + awater + " " + aCO2 + " " + aMDEA + " " + aHCO3 + " " + aMDEAp + " " + aCO3 + " " + aOH);
            }
            finally {
                p.close();
            }
        }
        catch (FileNotFoundException ex) {
            logger.error("Could not find file");
            logger.error("Could not read from Patrick.txt" + ex.getMessage());
        }
        loading = loading < 0.1 ? (loading *= 10.0) : (loading += 0.1);
        logger.info("Finished");
    }
}

