/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import neqsim.thermo.phase.PhaseGEUnifac;
import neqsim.thermo.phase.PhasePureComponentSolid;
import neqsim.thermo.phase.PhaseSrkEos;
import neqsim.thermo.system.SystemEos;

public class SystemUNIFAC
extends SystemEos {
    private static final long serialVersionUID = 1000L;

    public SystemUNIFAC() {
        this.modelName = "UNIFAC-GE-model";
        this.attractiveTermNumber = 0;
        this.phaseArray[0] = new PhaseSrkEos();
        for (int i = 1; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseGEUnifac();
        }
    }

    public SystemUNIFAC(double T, double P) {
        super(T, P);
        this.attractiveTermNumber = 0;
        this.modelName = "UNIFAC-GE-model";
        this.phaseArray[0] = new PhaseSrkEos();
        this.phaseArray[0].setTemperature(T);
        this.phaseArray[0].setPressure(P);
        for (int i = 1; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseGEUnifac();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
    }

    public SystemUNIFAC(double T, double P, boolean solidCheck) {
        this(T, P);
        this.attractiveTermNumber = 0;
        this.setNumberOfPhases(4);
        this.modelName = "UNIFAC-GE-model";
        this.solidPhaseCheck = solidCheck;
        this.phaseArray[0] = new PhaseSrkEos();
        this.phaseArray[0].setTemperature(T);
        this.phaseArray[0].setPressure(P);
        for (int i = 1; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseGEUnifac();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
        if (this.solidPhaseCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhasePureComponentSolid();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
    }

    @Override
    public SystemUNIFAC clone() {
        SystemUNIFAC clonedSystem = null;
        try {
            clonedSystem = (SystemUNIFAC)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedSystem;
    }
}

