/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import neqsim.thermo.phase.PhaseHydrate;
import neqsim.thermo.phase.PhasePCSAFTRahmat;
import neqsim.thermo.phase.PhasePureComponentSolid;
import neqsim.thermo.system.SystemSrkEos;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SystemPCSAFT
extends SystemSrkEos {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(SystemPCSAFT.class);

    public SystemPCSAFT() {
        this.modelName = "PCSAFT-EOS";
        this.attractiveTermNumber = 0;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhasePCSAFTRahmat();
            this.phaseArray[i].setTemperature(298.15);
            this.phaseArray[i].setPressure(1.0);
        }
        this.useVolumeCorrection(false);
        this.commonInitialization();
    }

    public SystemPCSAFT(double T, double P) {
        super(T, P);
        this.modelName = "PCSAFT-EOS";
        this.attractiveTermNumber = 0;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhasePCSAFTRahmat();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
        this.useVolumeCorrection(false);
        this.commonInitialization();
    }

    public SystemPCSAFT(double T, double P, boolean solidCheck) {
        this(T, P);
        this.modelName = "PCSAFT-EOS";
        this.attractiveTermNumber = 0;
        this.setNumberOfPhases(5);
        this.solidPhaseCheck = solidCheck;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhasePCSAFTRahmat();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
        this.commonInitialization();
        if (this.solidPhaseCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhasePureComponentSolid();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
        if (this.hydrateCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhaseHydrate();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
        this.useVolumeCorrection(false);
    }

    @Override
    public SystemPCSAFT clone() {
        SystemPCSAFT clonedSystem = null;
        try {
            clonedSystem = (SystemPCSAFT)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedSystem;
    }

    @Override
    public void addTBPfraction(String componentName2, double numberOfMoles, double molarMass, double density2) {
        super.addTBPfraction(componentName2, numberOfMoles, molarMass, density2);
        String componentName = this.getPhase(0).getComponent(this.getPhase(0).getNumberOfComponents() - 1).getComponentName();
        for (int i = 0; i < this.numberOfPhases; ++i) {
            double mSaft = 0.0249 * molarMass * 1000.0 + 0.9711;
            double epskSaftm = 6.5446 * molarMass * 1000.0 + 177.92;
            double msigm = 1.6947 * molarMass * 1000.0 + 23.27;
            this.getPhase(this.phaseIndex[i]).getComponent(componentName).setmSAFTi(mSaft);
            this.getPhase(this.phaseIndex[i]).getComponent(componentName).setEpsikSAFT(epskSaftm / mSaft);
            this.getPhase(this.phaseIndex[i]).getComponent(componentName).setSigmaSAFTi(Math.pow(msigm / mSaft, 0.3333333333333333) / 1.0E10);
            logger.info("Saft parameters: m " + mSaft + " epsk " + epskSaftm / mSaft + " sigma " + Math.pow(msigm / mSaft, 0.3333333333333333));
        }
    }

    public void commonInitialization() {
        this.setImplementedCompositionDeriativesofFugacity(false);
        this.setImplementedPressureDeriativesofFugacity(false);
        this.setImplementedTemperatureDeriativesofFugacity(false);
    }
}

