/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import neqsim.thermo.phase.PhaseCSPsrkEos;
import neqsim.thermo.phase.PhaseHydrate;
import neqsim.thermo.phase.PhasePureComponentSolid;
import neqsim.thermo.system.SystemSrkEos;

public class SystemCSPsrkEos
extends SystemSrkEos {
    private static final long serialVersionUID = 1000L;

    public SystemCSPsrkEos() {
        this.modelName = "CSPsrk-EOS";
        this.attractiveTermNumber = 0;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseCSPsrkEos();
            this.phaseArray[i].setTemperature(298.15);
            this.phaseArray[i].setPressure(1.0);
        }
    }

    public SystemCSPsrkEos(double T, double P) {
        super(T, P);
        this.modelName = "CSPsrk-EOS";
        this.attractiveTermNumber = 0;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseCSPsrkEos();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
    }

    public SystemCSPsrkEos(double T, double P, boolean solidCheck) {
        this(T, P);
        this.modelName = "CSPsrk-EOS";
        this.attractiveTermNumber = 0;
        this.setNumberOfPhases(5);
        this.solidPhaseCheck = solidCheck;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseCSPsrkEos();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
        if (this.solidPhaseCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhasePureComponentSolid();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
        if (this.hydrateCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhaseHydrate();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
    }

    @Override
    public SystemCSPsrkEos clone() {
        SystemCSPsrkEos clonedSystem = null;
        try {
            clonedSystem = (SystemCSPsrkEos)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedSystem;
    }
}

