/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.component.ComponentCPAInterface;
import neqsim.thermo.component.ComponentSrkCPA;
import neqsim.thermo.mixingRule.CPAMixing;
import neqsim.thermo.mixingRule.CPAMixingInterface;
import neqsim.thermo.phase.PhaseCPAInterface;
import neqsim.thermo.phase.PhaseSrkEos;
import neqsim.util.exception.IsNaNException;
import neqsim.util.exception.TooManyIterationsException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ojalgo.matrix.Primitive64Matrix;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.SparseStore;

public class PhaseSrkCPAojAlgo
extends PhaseSrkEos
implements PhaseCPAInterface {
    private static final long serialVersionUID = 1000L;
    public CPAMixing cpaSelect = new CPAMixing();
    public CPAMixingInterface cpamix;
    double gcpavv = 0.0;
    double gcpavvv = 0.0;
    double gcpa = 0.0;
    double hcpatot = 1.0;
    double FCPA = 0.0;
    double dFCPAdTdV;
    double dFCPAdTdT = 0.0;
    double dFCPAdT = 0.0;
    double dFCPAdV = 0.0;
    double dFCPAdVdV = 0.0;
    double dFCPAdVdVdV = 0.0;
    private double gcpav = 0.0;
    int cpaon = 1;
    int oldTotalNumberOfAccociationSites = 0;
    private int totalNumberOfAccociationSites = 0;
    int[][][] selfAccociationScheme = null;
    int[][][][] crossAccociationScheme = null;
    int[] moleculeNumber = null;
    int[] assSiteNumber = null;
    private double[][] gvector = null;
    private double[][] delta = null;
    private double[][] deltaNog = null;
    private double[][] deltadT = null;
    private double[][] deltadTdT = null;
    private double[][][] Klkni = null;
    private SparseStore<Double> KlkTVMatrix2 = null;
    private SparseStore<Double> KlkTTMatrix2 = null;
    private SparseStore<Double> KlkTMatrix2 = null;
    private SparseStore<Double> udotTimesmMatrix2 = null;
    private SparseStore<Double> mVector2 = null;
    private SparseStore<Double> udotMatrix2 = null;
    private SparseStore<Double> uMatrix2 = null;
    private SparseStore<Double> QMatksiksiksi2 = null;
    private SparseStore<Double> KlkVVVMatrix2 = null;
    private SparseStore<Double> KlkVVMatrix2 = null;
    private SparseStore<Double> udotTimesmiMatrix2 = null;
    private SparseStore<Double> ksiMatrix2 = null;
    private SparseStore<Double> KlkMatrix2 = null;
    private SparseStore<Double> hessianMatrix2 = null;
    private SparseStore<Double> KlkVMatrix2 = null;
    SparseStore<Double> corr2Matrix2 = null;
    SparseStore<Double> corr3Matrix2 = null;
    SparseStore<Double> corr4Matrix2 = null;
    MatrixStore<Double> hessianInvers2 = null;
    final Primitive64Matrix.Factory mtrxFactory = Primitive64Matrix.FACTORY;
    static Logger logger = LogManager.getLogger(PhaseSrkCPAojAlgo.class);

    @Override
    public PhaseSrkCPAojAlgo clone() {
        PhaseSrkCPAojAlgo clonedPhase = null;
        try {
            clonedPhase = (PhaseSrkCPAojAlgo)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedPhase;
    }

    @Override
    public void setMixingRule(int type) {
        super.setMixingRule(type);
        this.cpamix = this.cpaSelect.getMixingRule(1, this);
    }

    @Override
    public void init(double totalNumberOfMoles, int numberOfComponents, int type, int phase, double beta) {
        if (type == 0) {
            this.setTotalNumberOfAccociationSites(0);
            this.selfAccociationScheme = new int[numberOfComponents][0][0];
            this.crossAccociationScheme = new int[numberOfComponents][numberOfComponents][0][0];
            for (int i = 0; i < numberOfComponents; ++i) {
                if (this.getComponent(i).getNumberOfmoles() < 1.0E-50) {
                    this.getComponent(i).setNumberOfAssociationSites(0);
                    continue;
                }
                this.getComponent(i).setNumberOfAssociationSites(this.getComponent(i).getOrginalNumberOfAssociationSites());
                this.setTotalNumberOfAccociationSites(this.getTotalNumberOfAccociationSites() + this.getComponent(i).getNumberOfAssociationSites());
                this.selfAccociationScheme[i] = this.cpaSelect.setAssociationScheme(i, this);
                for (int j = 0; j < numberOfComponents; ++j) {
                    this.crossAccociationScheme[i][j] = this.cpaSelect.setCrossAssociationScheme(i, j, this);
                }
            }
            this.mVector2 = SparseStore.PRIMITIVE64.make((long)this.getTotalNumberOfAccociationSites(), 1L);
            this.KlkMatrix2 = SparseStore.PRIMITIVE64.make((long)this.getTotalNumberOfAccociationSites(), (long)this.getTotalNumberOfAccociationSites());
            this.KlkVMatrix2 = SparseStore.PRIMITIVE64.make((long)this.getTotalNumberOfAccociationSites(), (long)this.getTotalNumberOfAccociationSites());
            this.KlkVVMatrix2 = SparseStore.PRIMITIVE64.make((long)this.getTotalNumberOfAccociationSites(), (long)this.getTotalNumberOfAccociationSites());
            this.KlkVVVMatrix2 = SparseStore.PRIMITIVE64.make((long)this.getTotalNumberOfAccociationSites(), (long)this.getTotalNumberOfAccociationSites());
            this.hessianMatrix2 = SparseStore.PRIMITIVE64.make((long)this.getTotalNumberOfAccociationSites(), (long)this.getTotalNumberOfAccociationSites());
            this.KlkTMatrix2 = SparseStore.PRIMITIVE64.make((long)this.getTotalNumberOfAccociationSites(), (long)this.getTotalNumberOfAccociationSites());
            this.KlkTTMatrix2 = SparseStore.PRIMITIVE64.make((long)this.getTotalNumberOfAccociationSites(), (long)this.getTotalNumberOfAccociationSites());
            this.KlkTVMatrix2 = SparseStore.PRIMITIVE64.make((long)this.getTotalNumberOfAccociationSites(), (long)this.getTotalNumberOfAccociationSites());
            this.corr2Matrix2 = SparseStore.PRIMITIVE64.make((long)this.getTotalNumberOfAccociationSites(), 1L);
            this.corr3Matrix2 = SparseStore.PRIMITIVE64.make((long)this.getTotalNumberOfAccociationSites(), 1L);
            this.corr4Matrix2 = SparseStore.PRIMITIVE64.make((long)this.getTotalNumberOfAccociationSites(), 1L);
            this.Klkni = new double[numberOfComponents][this.getTotalNumberOfAccociationSites()][this.getTotalNumberOfAccociationSites()];
            this.ksiMatrix2 = SparseStore.PRIMITIVE64.make((long)this.getTotalNumberOfAccociationSites(), 1L);
            this.uMatrix2 = SparseStore.PRIMITIVE64.make((long)this.getTotalNumberOfAccociationSites(), 1L);
            this.udotMatrix2 = SparseStore.PRIMITIVE64.make((long)this.getTotalNumberOfAccociationSites(), 1L);
            this.moleculeNumber = new int[this.getTotalNumberOfAccociationSites()];
            this.assSiteNumber = new int[this.getTotalNumberOfAccociationSites()];
            this.gvector = new double[this.getTotalNumberOfAccociationSites()][1];
            this.udotTimesmMatrix2 = SparseStore.PRIMITIVE64.make((long)this.getTotalNumberOfAccociationSites(), 1L);
            this.delta = new double[this.getTotalNumberOfAccociationSites()][this.getTotalNumberOfAccociationSites()];
            this.deltaNog = new double[this.getTotalNumberOfAccociationSites()][this.getTotalNumberOfAccociationSites()];
            this.deltadT = new double[this.getTotalNumberOfAccociationSites()][this.getTotalNumberOfAccociationSites()];
            this.deltadTdT = new double[this.getTotalNumberOfAccociationSites()][this.getTotalNumberOfAccociationSites()];
            this.QMatksiksiksi2 = SparseStore.PRIMITIVE64.make((long)this.getTotalNumberOfAccociationSites(), 1L);
            this.udotTimesmiMatrix2 = SparseStore.PRIMITIVE64.make((long)this.getNumberOfComponents(), (long)this.getTotalNumberOfAccociationSites());
            this.oldTotalNumberOfAccociationSites = this.getTotalNumberOfAccociationSites();
            int temp = 0;
            for (int i = 0; i < numberOfComponents; ++i) {
                for (int j = 0; j < this.getComponent(i).getNumberOfAssociationSites(); ++j) {
                    this.moleculeNumber[temp + j] = i;
                    this.assSiteNumber[temp + j] = j;
                }
                temp += this.getComponent(i).getNumberOfAssociationSites();
            }
        }
        if (this.cpamix == null) {
            this.cpamix = this.cpaSelect.getMixingRule(1, this);
        }
        super.init(totalNumberOfMoles, numberOfComponents, type, phase, beta);
        if (type > 0 && this.isConstantPhaseVolume()) {
            this.calcDelta();
            this.solveX();
            super.init(totalNumberOfMoles, numberOfComponents, 1, phase, beta);
            this.gcpa = this.calc_g();
            this.setGcpav(this.calc_lngV());
            this.gcpavv = this.calc_lngVV();
            this.gcpavvv = this.calc_lngVVV();
        }
        if (type > 0) {
            this.hcpatot = this.calc_hCPA();
        }
        if (type > 1) {
            this.initCPAMatrix(type);
        }
    }

    public void calcDelta() {
        for (int i = 0; i < this.getTotalNumberOfAccociationSites(); ++i) {
            for (int j = i; j < this.getTotalNumberOfAccociationSites(); ++j) {
                this.deltaNog[i][j] = this.cpamix.calcDeltaNog(this.assSiteNumber[i], this.assSiteNumber[j], this.moleculeNumber[i], this.moleculeNumber[j], this, this.getTemperature(), this.getPressure(), this.numberOfComponents);
                this.deltaNog[j][i] = this.deltaNog[i][j];
            }
        }
    }

    public void initCPAMatrix(int type) {
        int p;
        int j;
        int i;
        if (this.getTotalNumberOfAccociationSites() == 0) {
            this.FCPA = 0.0;
            this.dFCPAdTdV = 0.0;
            this.dFCPAdTdT = 0.0;
            this.dFCPAdT = 0.0;
            this.dFCPAdV = 0.0;
            this.dFCPAdVdV = 0.0;
            this.dFCPAdVdVdV = 0.0;
            return;
        }
        int temp = 0;
        for (i = 0; i < this.numberOfComponents; ++i) {
            for (j = 0; j < this.getComponent(i).getNumberOfAssociationSites(); ++j) {
                this.uMatrix2.set((long)(temp + j), 0L, Math.log((Double)this.ksiMatrix2.get((long)(temp + j), 0L)) - (Double)this.ksiMatrix2.get((long)(temp + j), 0L) + 1.0);
                this.gvector[temp + j][0] = (Double)this.mVector2.get((long)(temp + j), 0L) * (Double)this.udotMatrix2.get((long)(temp + j), 0L);
            }
            temp += this.getComponent(i).getNumberOfAssociationSites();
        }
        for (i = 0; i < this.getNumberOfComponents(); ++i) {
            for (j = 0; j < this.getTotalNumberOfAccociationSites(); ++j) {
                if (this.moleculeNumber[j] == i) {
                    this.udotTimesmiMatrix2.set((long)i, (long)j, this.udotMatrix2.get((long)j, 0L));
                    continue;
                }
                this.udotTimesmiMatrix2.set((long)i, (long)j, 0.0);
            }
        }
        for (i = 0; i < this.getTotalNumberOfAccociationSites(); ++i) {
            for (j = i; j < this.getTotalNumberOfAccociationSites(); ++j) {
                this.delta[i][j] = this.deltaNog[i][j] * this.getGcpa();
                this.delta[j][i] = this.delta[i][j];
                if (type <= 1) continue;
                this.deltadT[i][j] = this.cpamix.calcDeltadT(this.assSiteNumber[i], this.assSiteNumber[j], this.moleculeNumber[i], this.moleculeNumber[j], this, this.getTemperature(), this.getPressure(), this.numberOfComponents);
                this.deltadT[j][i] = this.deltadT[i][j];
                this.deltadTdT[i][j] = this.cpamix.calcDeltadTdT(this.assSiteNumber[i], this.assSiteNumber[j], this.moleculeNumber[i], this.moleculeNumber[j], this, this.getTemperature(), this.getPressure(), this.numberOfComponents);
                this.deltadTdT[j][i] = this.deltadTdT[i][j];
            }
        }
        double gdv1 = this.getGcpav() - 1.0 / this.getTotalVolume();
        double gdv2 = gdv1 * gdv1;
        double gdv3 = gdv2 * gdv1;
        double totVol = this.getTotalVolume();
        for (int i2 = 0; i2 < this.getTotalNumberOfAccociationSites(); ++i2) {
            for (int j2 = i2; j2 < this.getTotalNumberOfAccociationSites(); ++j2) {
                this.KlkVMatrix2.set((long)i2, (long)j2, (Double)this.KlkMatrix2.get((long)i2, (long)j2) * gdv1);
                this.KlkVMatrix2.set((long)j2, (long)i2, this.KlkVMatrix2.get((long)i2, (long)j2));
                this.KlkVVMatrix2.set((long)i2, (long)j2, (Double)this.KlkMatrix2.get((long)i2, (long)j2) * gdv2 + (Double)this.KlkMatrix2.get((long)i2, (long)j2) * (this.gcpavv + 1.0 / this.getTotalVolume() / this.getTotalVolume()));
                this.KlkVVMatrix2.set((long)j2, (long)i2, this.KlkVVMatrix2.get((long)i2, (long)j2));
                this.KlkVVVMatrix2.set((long)i2, (long)j2, (Double)this.KlkMatrix2.get((long)i2, (long)j2) * gdv3 + 3.0 * (Double)this.KlkMatrix2.get((long)i2, (long)j2) * (this.getGcpav() - 1.0 / this.getTotalVolume()) * (this.gcpavv + 1.0 / (totVol * totVol)) + (Double)this.KlkMatrix2.get((long)i2, (long)j2) * (this.gcpavvv - 2.0 / (totVol * totVol * totVol)));
                this.KlkVVVMatrix2.set((long)j2, (long)i2, this.KlkVVVMatrix2.get((long)i2, (long)j2));
                if (type <= 1) continue;
                double tempVar = this.deltadT[i2][j2] / this.delta[i2][j2];
                double tempVardT = this.deltadTdT[i2][j2] / this.delta[i2][j2] - this.deltadT[i2][j2] * this.deltadT[i2][j2] / (this.delta[i2][j2] * this.delta[i2][j2]);
                if (!Double.isNaN(tempVar)) {
                    this.KlkTMatrix2.set((long)i2, (long)j2, (Double)this.KlkMatrix2.get((long)i2, (long)j2) * tempVar);
                    this.KlkTMatrix2.set((long)j2, (long)i2, this.KlkTMatrix2.get((long)i2, (long)j2));
                    this.KlkTVMatrix2.set((long)i2, (long)j2, (Double)this.KlkMatrix2.get((long)i2, (long)j2) * tempVar * (this.gcpav - 1.0 / this.getTotalVolume()));
                    this.KlkTVMatrix2.set((long)j2, (long)i2, this.KlkTVMatrix2.get((long)i2, (long)j2));
                    this.KlkTTMatrix2.set((long)i2, (long)j2, (Double)this.KlkMatrix2.get((long)i2, (long)j2) * (tempVar * tempVar + tempVardT));
                    this.KlkTTMatrix2.set((long)j2, (long)i2, this.KlkTTMatrix2.get((long)i2, (long)j2));
                }
                if (type <= 2) continue;
                for (int p2 = 0; p2 < this.numberOfComponents; ++p2) {
                    double t1 = 0.0;
                    double t2 = 0.0;
                    if (this.moleculeNumber[i2] == p2) {
                        t1 = 1.0 / (Double)this.mVector2.get((long)i2, 0L);
                    }
                    if (this.moleculeNumber[j2] == p2) {
                        t2 = 1.0 / (Double)this.mVector2.get((long)j2, 0L);
                    }
                    this.Klkni[p2][i2][j2] = (Double)this.KlkMatrix2.get((long)i2, (long)j2) * (t1 + t2 + ((ComponentSrkCPA)this.getComponent(p2)).calc_lngi(this));
                    this.Klkni[p2][j2][i2] = this.Klkni[p2][i2][j2];
                }
            }
            this.QMatksiksiksi2.set((long)i2, 0L, 2.0 * (Double)this.mVector2.get((long)i2, 0L) / ((Double)this.ksiMatrix2.get((long)i2, 0L) * (Double)this.ksiMatrix2.get((long)i2, 0L) * (Double)this.ksiMatrix2.get((long)i2, 0L)));
        }
        MatrixStore ksiMatrixTranspose2 = this.ksiMatrix2.transpose();
        MatrixStore KlkVMatrixksi = this.KlkVMatrix2.multiply(this.ksiMatrix2);
        MatrixStore XV = this.hessianInvers2.multiply(KlkVMatrixksi);
        MatrixStore XVtranspose = XV.transpose();
        MatrixStore QCPA = this.mVector2.transpose().multiply(this.uMatrix2.subtract(this.ksiMatrix2.multiply(this.udotMatrix2).multiply(0.5)));
        this.FCPA = (Double)QCPA.get(0L, 0L);
        MatrixStore tempMatrix = ksiMatrixTranspose2.multiply(KlkVMatrixksi).multiply(-0.5);
        this.dFCPAdV = (Double)tempMatrix.get(0L, 0L);
        MatrixStore KlkVVMatrixTImesKsi = this.KlkVVMatrix2.multiply(this.ksiMatrix2);
        MatrixStore tempMatrixVV = ksiMatrixTranspose2.multiply(KlkVVMatrixTImesKsi).multiply(-0.5).subtract(KlkVMatrixksi.transpose().multiply(XV));
        this.dFCPAdVdV = (Double)tempMatrixVV.get(0L, 0L);
        MatrixStore QVVV = ksiMatrixTranspose2.multiply(this.KlkVVVMatrix2.multiply(this.ksiMatrix2)).multiply(-0.5);
        MatrixStore QVVksi = KlkVVMatrixTImesKsi.multiply(-1.0);
        MatrixStore QksiVksi = this.KlkVMatrix2.multiply(-1.0);
        MatrixStore mat1 = QVVksi.transpose().multiply(XV).multiply(3.0);
        MatrixStore mat2 = XVtranspose.multiply(QksiVksi.multiply(XV)).multiply(3.0);
        MatrixStore mat4 = XVtranspose.multiply(this.QMatksiksiksi2.multiply(XVtranspose)).multiply(XV);
        MatrixStore dFCPAdVdVdVMatrix = QVVV.add(mat1).add(mat2).add(mat2).add(mat4);
        this.dFCPAdVdVdV = (Double)dFCPAdVdVdVMatrix.get(0L, 0L);
        temp = 0;
        if (type == 1) {
            return;
        }
        for (int p3 = 0; p3 < this.numberOfComponents; ++p3) {
            for (int kk = 0; kk < this.getComponent(p3).getNumberOfAssociationSites(); ++kk) {
                ((ComponentCPAInterface)this.getComponent(p3)).setXsitedV(kk, (Double)XV.get((long)(temp + kk), 0L));
            }
            temp += this.getComponent(p3).getNumberOfAssociationSites();
        }
        MatrixStore KlkTMatrixTImesKsi = this.KlkTMatrix2.multiply(this.ksiMatrix2);
        MatrixStore tempMatrix2 = ksiMatrixTranspose2.multiply(KlkTMatrixTImesKsi).multiply(-0.5);
        this.dFCPAdT = (Double)tempMatrix2.get(0L, 0L);
        MatrixStore XT = this.hessianInvers2.multiply(KlkTMatrixTImesKsi);
        MatrixStore tempMatrixTT = ksiMatrixTranspose2.multiply(this.KlkTTMatrix2.multiply(this.ksiMatrix2)).multiply(-0.5).subtract(KlkTMatrixTImesKsi.transpose().multiply(XT));
        this.dFCPAdTdT = (Double)tempMatrixTT.get(0L, 0L);
        MatrixStore tempMatrixTV = ksiMatrixTranspose2.multiply(this.KlkTVMatrix2.multiply(this.ksiMatrix2)).multiply(-0.5).subtract(KlkTMatrixTImesKsi.transpose().multiply(XV));
        this.dFCPAdTdV = (Double)tempMatrixTV.get(0L, 0L);
        temp = 0;
        for (p = 0; p < this.numberOfComponents; ++p) {
            for (int kk = 0; kk < this.getComponent(p).getNumberOfAssociationSites(); ++kk) {
                ((ComponentCPAInterface)this.getComponent(p)).setXsitedT(kk, (Double)XT.get((long)(temp + kk), 0L));
            }
            temp += this.getComponent(p).getNumberOfAssociationSites();
        }
        if (type == 2) {
            return;
        }
        for (p = 0; p < this.numberOfComponents; ++p) {
            for (int compp = 0; compp < this.numberOfComponents; ++compp) {
                for (int kk = 0; kk < this.getComponent(compp).getNumberOfAssociationSites(); ++kk) {
                }
            }
        }
    }

    @Override
    public void addcomponent(String componentName, double moles, double molesInPhase, int compNumber) {
        super.addcomponent(componentName, moles, molesInPhase, compNumber);
        this.componentArray[compNumber] = new ComponentSrkCPA(componentName, moles, molesInPhase, compNumber);
    }

    @Override
    public double getF() {
        return super.getF() + (double)this.cpaon * this.FCPA();
    }

    @Override
    public double dFdT() {
        return super.dFdT() + (double)this.cpaon * this.dFCPAdT();
    }

    @Override
    public double dFdTdV() {
        return super.dFdTdV() + (double)this.cpaon * this.dFCPAdTdV();
    }

    @Override
    public double dFdV() {
        double dv2 = this.dFCPAdV();
        return super.dFdV() + (double)this.cpaon * dv2;
    }

    @Override
    public double dFdVdV() {
        return super.dFdVdV() + (double)this.cpaon * this.dFCPAdVdV();
    }

    @Override
    public double dFdVdVdV() {
        return super.dFdVdVdV() + (double)this.cpaon * this.dFCPAdVdVdV();
    }

    @Override
    public double dFdTdT() {
        return super.dFdTdT() + (double)this.cpaon * this.dFCPAdTdT();
    }

    public double FCPA() {
        return this.FCPA;
    }

    public double dFCPAdV() {
        return this.dFCPAdV;
    }

    public double dFCPAdVdV() {
        return this.dFCPAdVdV;
    }

    public double dFCPAdVdVdV() {
        return this.dFCPAdVdVdV;
    }

    public double dFCPAdT() {
        return this.dFCPAdT;
    }

    public double dFCPAdTdT() {
        return this.dFCPAdTdT;
    }

    public double dFCPAdTdV() {
        return this.dFCPAdTdV;
    }

    public double calc_hCPA() {
        double htot = 0.0;
        double tot = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            htot = 0.0;
            for (int j = 0; j < this.getComponent(i).getNumberOfAssociationSites(); ++j) {
                htot += 1.0 - ((ComponentSrkCPA)this.getComponent(i)).getXsite()[j];
            }
            tot += this.getComponent(i).getNumberOfMolesInPhase() * htot;
        }
        return tot;
    }

    public double calc_g() {
        double temp = 1.0 - this.getb() / 4.0 / this.getMolarVolume();
        double g = (2.0 - this.getb() / 4.0 / this.getMolarVolume()) / (2.0 * temp * temp * temp);
        return g;
    }

    public double calc_lngV() {
        double gv2 = 0.0;
        gv2 = 1.0 / (2.0 - this.getB() / (4.0 * this.getTotalVolume())) * this.getB() / (4.0 * this.getTotalVolume() * this.getTotalVolume()) - 3.0 / (1.0 - this.getB() / (4.0 * this.getTotalVolume())) * this.getB() / (4.0 * this.getTotalVolume() * this.getTotalVolume());
        return gv2;
    }

    public double calc_lngVV() {
        double gvv = 2.0 * (640.0 * Math.pow(this.getTotalVolume(), 3.0) - 216.0 * this.getB() * this.getTotalVolume() * this.getTotalVolume() + 24.0 * Math.pow(this.getB(), 2.0) * this.getTotalVolume() - Math.pow(this.getB(), 3.0)) * this.getB() / (this.getTotalVolume() * this.getTotalVolume()) / Math.pow(8.0 * this.getTotalVolume() - this.getB(), 2.0) / Math.pow(4.0 * this.getTotalVolume() - this.getB(), 2.0);
        return gvv;
    }

    public double calc_lngVVV() {
        double gvvv = 4.0 * (Math.pow(this.getB(), 5.0) + 17664.0 * Math.pow(this.getTotalVolume(), 4.0) * this.getB() - 4192.0 * Math.pow(this.getTotalVolume(), 3.0) * Math.pow(this.getB(), 2.0) + 528.0 * Math.pow(this.getB(), 3.0) * this.getTotalVolume() * this.getTotalVolume() - 36.0 * this.getTotalVolume() * Math.pow(this.getB(), 4.0) - 30720.0 * Math.pow(this.getTotalVolume(), 5.0)) * this.getB() / Math.pow(this.getTotalVolume(), 3.0) / Math.pow(-8.0 * this.getTotalVolume() + this.getB(), 3.0) / Math.pow(-4.0 * this.getTotalVolume() + this.getB(), 3.0);
        return gvvv;
    }

    public void calcXsitedV() {
        if (this.getTotalNumberOfAccociationSites() > 0) {
            this.initCPAMatrix(1);
        }
    }

    public boolean solveX() {
        if (this.getTotalNumberOfAccociationSites() == 0) {
            return true;
        }
        boolean solvedX = this.solveX2(5);
        if (solvedX) {
            // empty if block
        }
        int temp = 0;
        int iter = 0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            for (int j = 0; j < this.getComponent(i).getNumberOfAssociationSites(); ++j) {
                this.mVector2.set((long)(temp + j), 0L, this.getComponent(i).getNumberOfMolesInPhase());
            }
            temp += this.getComponent(i).getNumberOfAssociationSites();
        }
        double Klk = 0.0;
        double totvolume = this.getTotalVolume();
        for (int i = 0; i < this.getTotalNumberOfAccociationSites(); ++i) {
            for (int j = i; j < this.getTotalNumberOfAccociationSites(); ++j) {
                Klk = (Double)this.mVector2.get((long)i, 0L) * (Double)this.mVector2.get((long)j, 0L) / totvolume * this.delta[i][j];
                this.KlkMatrix2.set((long)i, (long)j, Klk);
                this.KlkMatrix2.set((long)j, (long)i, Klk);
            }
        }
        boolean solved = true;
        do {
            int j;
            int i;
            solved = true;
            ++iter;
            temp = 0;
            for (i = 0; i < this.numberOfComponents; ++i) {
                for (j = 0; j < this.getComponent(i).getNumberOfAssociationSites(); ++j) {
                    this.ksiMatrix2.set((long)(temp + j), 0L, ((ComponentSrkCPA)this.getComponent(i)).getXsite()[j]);
                    this.udotMatrix2.set((long)(temp + j), 0L, 1.0 / (Double)this.ksiMatrix2.get((long)(temp + j), 0L) - 1.0);
                    this.udotTimesmMatrix2.set((long)(temp + j), 0L, (Double)this.mVector2.get((long)(temp + j), 0L) * (Double)this.udotMatrix2.get((long)(temp + j), 0L));
                }
                temp += this.getComponent(i).getNumberOfAssociationSites();
            }
            for (i = 0; i < this.getTotalNumberOfAccociationSites(); ++i) {
                for (j = i; j < this.getTotalNumberOfAccociationSites(); ++j) {
                    boolean krondelt = false;
                    if (i == j) {
                        krondelt = true;
                    }
                    this.hessianMatrix2.set((long)i, (long)j, -((Double)this.mVector2.get((long)i, 0L)).doubleValue() / ((Double)this.ksiMatrix2.get((long)i, 0L) * (Double)this.ksiMatrix2.get((long)i, 0L)) * (double)krondelt - (Double)this.KlkMatrix2.get((long)i, (long)j));
                    this.hessianMatrix2.set((long)j, (long)i, this.hessianMatrix2.get((long)i, (long)j));
                }
            }
            temp = 0;
            for (i = 0; i < this.numberOfComponents; ++i) {
                for (j = 0; j < this.getComponent(i).getNumberOfAssociationSites(); ++j) {
                    double newX = (Double)this.ksiMatrix2.get((long)(temp + j), 0L) - (Double)this.corr4Matrix2.get((long)(temp + j), 0L);
                    if (newX < 0.0) {
                        newX = 1.0E-10;
                        solved = false;
                    }
                    ((ComponentCPAInterface)this.getComponent(i)).setXsite(j, newX);
                }
                temp += this.getComponent(i).getNumberOfAssociationSites();
            }
        } while ((this.corr4Matrix2.norm() > 1.0E-12 || !solved) && iter < 100);
        return true;
    }

    public boolean solveX2(int maxIter) {
        double err = 0.0;
        int iter = 0;
        double old = 0.0;
        double neeval = 0.0;
        do {
            ++iter;
            err = 0.0;
            for (int i = 0; i < this.getTotalNumberOfAccociationSites(); ++i) {
                old = ((ComponentSrkCPA)this.getComponent(this.moleculeNumber[i])).getXsite()[this.assSiteNumber[i]];
                neeval = 0.0;
                for (int j = 0; j < this.getTotalNumberOfAccociationSites(); ++j) {
                    neeval += this.getComponent(this.moleculeNumber[j]).getNumberOfMolesInPhase() * this.delta[i][j] * ((ComponentSrkCPA)this.getComponent(this.moleculeNumber[j])).getXsite()[this.assSiteNumber[j]];
                }
                neeval = 1.0 / (1.0 + 1.0 / this.getTotalVolume() * neeval);
                ((ComponentCPAInterface)this.getComponent(this.moleculeNumber[i])).setXsite(this.assSiteNumber[i], neeval);
                err += Math.abs((old - neeval) / neeval);
            }
        } while (Math.abs(err) > 1.0E-10 && iter < maxIter);
        return false;
    }

    @Override
    public double getHcpatot() {
        return this.hcpatot;
    }

    public void setHcpatot(double hcpatot) {
        this.hcpatot = hcpatot;
    }

    @Override
    public double getGcpa() {
        return this.gcpa;
    }

    public double calcRootVolFinder(int phase) {
        double BonV;
        double solvedBonVHigh = 0.0;
        double solvedBonVlow = 1.0;
        double oldh = 1.0;
        double BonVold = BonV = 0.9999999999;
        double Btemp = 0.0;
        double h = 1.0;
        Btemp = this.getB();
        this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
        for (int i = 0; i < 2000; ++i) {
            BonVold = BonV;
            BonV = 1.0 - ((double)i + 1.0E-6) * 1.0 / 2000.0;
            this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
            this.Z = this.pressure * this.getMolarVolume() / (8.3144621 * this.temperature);
            this.gcpa = this.calc_g();
            this.setGcpav(this.calc_lngV());
            this.gcpavv = this.calc_lngVV();
            this.gcpavvv = this.calc_lngVVV();
            while (!this.solveX()) {
            }
            h = BonV - Btemp / this.numberOfMolesInPhase * this.dFdV() - this.pressure * Btemp / (this.numberOfMolesInPhase * 8.3144621 * this.temperature);
            if (Math.signum(h) * Math.signum(oldh) < 0.0 && i > 2) {
                if (solvedBonVlow < 0.001) {
                    solvedBonVlow = (BonV + BonVold) / 2.0;
                    if (phase == 1) {
                        break;
                    }
                } else {
                    solvedBonVHigh = (BonV + BonVold) / 2.0;
                    if (phase == 0) break;
                }
            }
            solvedBonVHigh = (BonV + BonVold) / 2.0;
            oldh = h;
        }
        if (solvedBonVlow < 0.001) {
            solvedBonVlow = solvedBonVHigh;
        }
        if (phase == 1) {
            return solvedBonVlow;
        }
        return solvedBonVHigh;
    }

    @Override
    public double molarVolume(double pressure, double temperature, double A, double B, int phasetype) throws IsNaNException, TooManyIterationsException {
        double BonVold;
        double BonV;
        double d = BonV = phasetype == 0 ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621);
        if (BonV < 0.0) {
            BonV = 1.0E-8;
        }
        if (BonV >= 1.0) {
            BonV = 0.9999;
        }
        double h = 0.0;
        double dh = 0.0;
        double dhh = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        double Btemp = this.getB();
        if (Btemp < 0.0) {
            logger.info("b negative in volume calc");
        }
        this.calcDelta();
        this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
        int iterations = 0;
        do {
            ++iterations;
            this.gcpa = this.calc_g();
            if (this.gcpa < 0.0) {
                this.setMolarVolume(1.0 / Btemp / this.numberOfMolesInPhase);
                this.gcpa = this.calc_g();
            }
            this.setGcpav(this.calc_lngV());
            this.gcpavv = this.calc_lngVV();
            this.gcpavvv = this.calc_lngVVV();
            if (this.getTotalNumberOfAccociationSites() > 0) {
                this.solveX();
            }
            this.initCPAMatrix(1);
            double BonV2 = BonV * BonV;
            BonVold = BonV;
            h = BonV - Btemp / this.numberOfMolesInPhase * this.dFdV() - pressure * Btemp / (this.numberOfMolesInPhase * 8.3144621 * temperature);
            dh = 1.0 + Btemp / BonV2 * (Btemp / this.numberOfMolesInPhase * this.dFdVdV());
            dhh = -2.0 * Btemp / (BonV2 * BonV) * (Btemp / this.numberOfMolesInPhase * this.dFdVdV()) - Btemp * Btemp / (BonV2 * BonV2) * (Btemp / this.numberOfMolesInPhase * this.dFdVdVdV());
            d1 = -h / dh;
            d2 = -dh / dhh;
            if (Math.abs(d1 / d2) <= 1.0) {
                BonV += d1 * (1.0 + 0.5 * d1 / d2);
            } else if (d1 / d2 < -1.0) {
                BonV += 0.5 * d1;
            } else if (d1 > d2) {
                BonV += d2;
                double hnew = h + d2 * dh;
                if (Math.abs(hnew) > Math.abs(h)) {
                    BonV = phasetype == 1 ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621);
                }
            } else {
                BonV += 0.5 * d1;
            }
            if (Math.abs((BonV - BonVold) / BonVold) > 0.1) {
                BonV = BonVold + 0.1 * (BonV - BonVold);
            }
            if (BonV > 0.9999) {
                if (iterations < 3) {
                    BonV = (BonVold + BonV) / 2.0;
                }
            } else if (BonV < 0.0 && iterations < 3) {
                BonV = Math.abs(BonVold + BonV) / 2.0;
            }
            this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
            this.Z = pressure * this.getMolarVolume() / (8.3144621 * temperature);
        } while ((Math.abs((BonV - BonVold) / BonV) > 1.0E-10 || Math.abs(h) > 1.0E-12) && iterations < 100);
        if (Math.abs(h) > 1.0E-12) {
            // empty if block
        }
        if (Double.isNaN(this.getMolarVolume())) {
            throw new IsNaNException(this, "molarVolume", "Molar volume");
        }
        return this.getMolarVolume();
    }

    public double molarVolumeChangePhase(double pressure, double temperature, double A, double B, int phasetype) throws IsNaNException, TooManyIterationsException {
        double BonV = this.calcRootVolFinder(phasetype);
        if (BonV < 0.0) {
            BonV = 1.0E-8;
        }
        if (BonV >= 1.0) {
            BonV = 0.9999;
        }
        double BonVold = BonV;
        double Btemp = 0.0;
        double h = 0.0;
        double dh = 0.0;
        double dhh = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        Btemp = this.getB();
        if (Btemp < 0.0) {
            logger.info("b negative in volume calc");
        }
        this.calcDelta();
        this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
        int iterations = 0;
        do {
            ++iterations;
            this.gcpa = this.calc_g();
            if (this.gcpa < 0.0) {
                this.setMolarVolume(1.0 / Btemp / this.numberOfMolesInPhase);
                this.gcpa = this.calc_g();
            }
            this.setGcpav(this.calc_lngV());
            this.gcpavv = this.calc_lngVV();
            this.gcpavvv = this.calc_lngVVV();
            this.solveX();
            this.initCPAMatrix(1);
            double BonV2 = BonV * BonV;
            BonVold = BonV;
            h = BonV - Btemp / this.numberOfMolesInPhase * this.dFdV() - pressure * Btemp / (this.numberOfMolesInPhase * 8.3144621 * temperature);
            dh = 1.0 + Btemp / BonV2 * (Btemp / this.numberOfMolesInPhase * this.dFdVdV());
            dhh = -2.0 * Btemp / (BonV2 * BonV) * (Btemp / this.numberOfMolesInPhase * this.dFdVdV()) - Btemp * Btemp / (BonV2 * BonV2) * (Btemp / this.numberOfMolesInPhase * this.dFdVdVdV());
            d1 = -h / dh;
            d2 = -dh / dhh;
            if (Math.abs(d1 / d2) <= 1.0) {
                BonV += d1 * (1.0 + 0.5 * d1 / d2);
            } else if (d1 / d2 < -1.0) {
                BonV += 0.5 * d1;
            } else if (d1 > d2) {
                BonV += d2;
                double hnew = h + d2 * dh;
                if (Math.abs(hnew) > Math.abs(h)) {
                    BonV = phasetype == 1 ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621);
                }
            } else {
                BonV += 0.5 * d1;
            }
            if (Math.abs((BonV - BonVold) / BonVold) > 0.1) {
                BonV = BonVold + 0.1 * (BonV - BonVold);
            }
            if (BonV > 1.1) {
                if (iterations < 3) {
                    BonV = (BonVold + BonV) / 2.0;
                } else {
                    double d = BonV = phasetype == 1 ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621);
                }
            }
            if (BonV < 0.0) {
                BonV = iterations < 3 ? Math.abs(BonVold + BonV) / 2.0 : (phasetype == 1 ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621));
            }
            this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
            this.Z = pressure * this.getMolarVolume() / (8.3144621 * temperature);
        } while (Math.abs((BonV - BonVold) / BonV) > 1.0E-10 && iterations < 100);
        if (Double.isNaN(this.getMolarVolume())) {
            throw new IsNaNException(this, "molarVolumeChangePhase", "Molar volume");
        }
        return this.getMolarVolume();
    }

    @Override
    public double molarVolume2(double pressure, double temperature, double A, double B, int phase) throws IsNaNException, TooManyIterationsException {
        this.Z = phase == 0 ? 1.0 : 1.0E-5;
        this.setMolarVolume(this.Z * 8.3144621 * temperature / pressure);
        int iterations = 0;
        double err = 0.0;
        double dErrdV = 0.0;
        double deltaV = 0.0;
        do {
            A = this.calcA(this, temperature, pressure, this.numberOfComponents);
            B = this.calcB(this, temperature, pressure, this.numberOfComponents);
            double dFdV = this.dFdV();
            double dFdVdV = this.dFdVdV();
            err = -8.3144621 * temperature * dFdV + 8.3144621 * temperature / this.getMolarVolume() - pressure;
            dErrdV = -8.3144621 * temperature * dFdVdV - 8.3144621 * temperature * this.numberOfMolesInPhase / Math.pow(this.getVolume(), 2.0);
            deltaV = -err / dErrdV;
            this.setMolarVolume(this.getMolarVolume() + deltaV / this.numberOfMolesInPhase);
            this.Z = pressure * this.getMolarVolume() / (8.3144621 * temperature);
            if (!(this.Z < 0.0)) continue;
            this.Z = 1.0E-6;
            this.setMolarVolume(this.Z * 8.3144621 * temperature / pressure);
        } while (Math.abs(err) > 1.0E-8 || iterations < 100);
        return this.getMolarVolume();
    }

    @Override
    public double getGcpav() {
        return this.gcpav;
    }

    public void setGcpav(double gcpav) {
        this.gcpav = gcpav;
    }

    @Override
    public CPAMixingInterface getCpamix() {
        return this.cpamix;
    }

    @Override
    public double calcPressure() {
        this.gcpa = this.calc_g();
        this.setGcpav(this.calc_lngV());
        this.gcpavv = this.calc_lngVV();
        this.gcpavvv = this.calc_lngVVV();
        this.solveX();
        this.hcpatot = this.calc_hCPA();
        this.initCPAMatrix(1);
        return super.calcPressure();
    }

    @Override
    public int getCrossAssosiationScheme(int comp1, int comp2, int site1, int site2) {
        if (comp1 == comp2) {
            return this.selfAccociationScheme[comp1][site1][site2];
        }
        return this.crossAccociationScheme[comp1][comp2][site1][site2];
    }

    public double[][] croeneckerProduct(double[][] a, double[][] b) {
        int aLength = a.length;
        int aCols = a[0].length;
        int bLength = b.length;
        int bCols = b[0].length;
        double[][] result = new double[aLength * bLength][aCols * bCols];
        for (int z = 0; z < aLength; ++z) {
            for (int i = 0; i < aCols; ++i) {
                for (int j = 0; j < bLength; ++j) {
                    for (int k = 0; k < bCols; ++k) {
                        result[j + z * bLength][k + i * bCols] = a[z][i] * b[j][k];
                    }
                }
            }
        }
        return result;
    }

    @Override
    public int getTotalNumberOfAccociationSites() {
        return this.totalNumberOfAccociationSites;
    }

    @Override
    public void setTotalNumberOfAccociationSites(int totalNumberOfAccociationSites) {
        this.totalNumberOfAccociationSites = totalNumberOfAccociationSites;
    }
}

