/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import java.sql.ResultSet;
import neqsim.thermo.component.ComponentGEUnifac;
import neqsim.thermo.component.ComponentGEUnifacUMRPRU;
import neqsim.thermo.component.ComponentGEUniquac;
import neqsim.thermo.phase.PhaseGEUnifac;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PhaseGEUnifacUMRPRU
extends PhaseGEUnifac {
    private static final long serialVersionUID = 1000L;
    double[] Qmix = null;
    double[][] QmixdN = null;
    String[] gropuNames = null;
    double VCommontemp = 0.0;
    double FCommontemp = 0.0;
    static Logger logger = LogManager.getLogger(PhaseGEUnifacUMRPRU.class);

    public PhaseGEUnifacUMRPRU() {
        this.componentArray = new ComponentGEUnifacUMRPRU[100];
    }

    public PhaseGEUnifacUMRPRU(PhaseInterface phase, double[][] alpha, double[][] Dij, String[][] mixRule, double[][] intparam) {
        super(phase, alpha, Dij, mixRule, intparam);
        this.componentArray = new ComponentGEUnifac[alpha[0].length];
        for (int i = 0; i < alpha[0].length; ++i) {
            this.componentArray[i] = new ComponentGEUnifacUMRPRU(phase.getComponents()[i].getName(), phase.getComponents()[i].getNumberOfmoles(), phase.getComponents()[i].getNumberOfMolesInPhase(), phase.getComponents()[i].getComponentNumber());
            this.componentArray[i].setAttractiveTerm(phase.getComponents()[i].getAttractiveTermNumber());
        }
        this.setMixingRule(2);
    }

    public void calcCommontemp(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype) {
        this.FCommontemp = 0.0;
        this.VCommontemp = 0.0;
        ComponentGEUnifac[] compArray = (ComponentGEUnifac[])phase.getcomponentArray();
        for (int j = 0; j < numberOfComponents; ++j) {
            this.FCommontemp += compArray[j].getQ() * compArray[j].getx();
            this.VCommontemp += compArray[j].getx() * compArray[j].getR();
        }
    }

    public double getVCommontemp() {
        return this.VCommontemp;
    }

    public double getFCommontemp() {
        return this.FCommontemp;
    }

    @Override
    public void addcomponent(String componentName, double moles, double molesInPhase, int compNumber) {
        super.addcomponent(molesInPhase);
        this.componentArray[compNumber] = new ComponentGEUnifacUMRPRU(componentName, moles, molesInPhase, compNumber);
    }

    @Override
    public void setMixingRule(int type) {
        super.setMixingRule(type);
        if (!this.checkedGroups) {
            this.checkGroups();
        }
        this.calcbij();
        this.calccij();
    }

    @Override
    public void init(double totalNumberOfMoles, int numberOfComponents, int type, int phase, double beta) {
        super.init(totalNumberOfMoles, numberOfComponents, type, phase, beta);
    }

    @Override
    public double getExessGibbsEnergy(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype) {
        double GE = 0.0;
        this.calcCommontemp(phase, numberOfComponents, temperature, pressure, phasetype);
        this.initQmix();
        if (this.getInitType() > 2) {
            this.initQmixdN();
        }
        for (int i = 0; i < numberOfComponents; ++i) {
            GE += phase.getComponents()[i].getx() * Math.log(((ComponentGEUniquac)this.componentArray[i]).getGamma(phase, numberOfComponents, temperature, pressure, phasetype));
        }
        return 8.3144621 * phase.getTemperature() * GE * phase.getNumberOfMolesInPhase();
    }

    public void initQmix() {
        int numberOfGroups = ((ComponentGEUnifac)this.componentArray[0]).getUnifacGroups().length;
        this.Qmix = new double[numberOfGroups];
        this.gropuNames = new String[numberOfGroups];
        for (int i = 0; i < numberOfGroups; ++i) {
            this.gropuNames[i] = ((ComponentGEUnifac)this.componentArray[0]).getUnifacGroup(i).getGroupName();
            this.Qmix[i] = ((ComponentGEUnifac)this.componentArray[0]).getUnifacGroup(i).calcQMix(this);
        }
    }

    public void initQmixdN() {
        int numberOfGroups = ((ComponentGEUnifac)this.componentArray[0]).getUnifacGroups().length;
        this.QmixdN = new double[numberOfGroups][this.componentArray.length];
        this.gropuNames = new String[numberOfGroups];
        for (int i = 0; i < numberOfGroups; ++i) {
            this.gropuNames[i] = ((ComponentGEUnifac)this.componentArray[0]).getUnifacGroup(i).getGroupName();
            this.QmixdN[i] = ((ComponentGEUnifac)this.componentArray[0]).getUnifacGroup(i).calcQMixdN(this);
        }
    }

    public double getQmix(String name) {
        for (int i = 0; i < this.gropuNames.length; ++i) {
            if (!name.equals(this.gropuNames[i])) continue;
            return this.Qmix[i];
        }
        return 0.0;
    }

    public double[] getQmixdN(String name) {
        for (int i = 0; i < this.gropuNames.length; ++i) {
            if (!name.equals(this.gropuNames[i])) continue;
            return this.QmixdN[i];
        }
        return this.QmixdN[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void calcaij() {
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = null;
        this.aij = new double[((ComponentGEUnifac)this.getComponent(0)).getNumberOfUNIFACgroups()][((ComponentGEUnifac)this.getComponent(0)).getNumberOfUNIFACgroups()];
        for (int i = 0; i < ((ComponentGEUnifac)this.getComponent(0)).getNumberOfUNIFACgroups(); ++i) {
            try {
                dataSet = this.getPhase().getComponent(0).getAttractiveTermNumber() == 13 ? database.getResultSet("SELECT * FROM unifacinterparama_umrmc WHERE MainGroup=" + ((ComponentGEUnifac)this.getComponent(0)).getUnifacGroup(i).getMainGroup()) : database.getResultSet("SELECT * FROM unifacinterparama_umr WHERE MainGroup=" + ((ComponentGEUnifac)this.getComponent(0)).getUnifacGroup(i).getMainGroup());
                dataSet.next();
                for (int j = 0; j < ((ComponentGEUnifac)this.getComponent(0)).getNumberOfUNIFACgroups(); ++j) {
                    this.aij[i][j] = Double.parseDouble(dataSet.getString("n" + ((ComponentGEUnifac)this.getComponent(0)).getUnifacGroup(j).getMainGroup()));
                }
                continue;
            }
            catch (Exception ex) {
                logger.error(ex.toString(), (Throwable)ex);
                continue;
            }
            finally {
                try {
                    if (dataSet != null) {
                        dataSet.close();
                    }
                }
                catch (Exception ex) {
                    logger.error("err closing dataSet...", (Throwable)ex);
                }
            }
        }
        try {
            if (database.getStatement() != null) {
                database.getStatement().close();
            }
            if (database.getConnection() != null) {
                database.getConnection().close();
            }
        }
        catch (Exception ex) {
            logger.error("error closing database.....", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calcbij() {
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = null;
        this.bij = new double[((ComponentGEUnifac)this.getComponent(0)).getNumberOfUNIFACgroups()][((ComponentGEUnifac)this.getComponent(0)).getNumberOfUNIFACgroups()];
        for (int i = 0; i < ((ComponentGEUnifac)this.getComponent(0)).getNumberOfUNIFACgroups(); ++i) {
            try {
                dataSet = this.getPhase().getComponent(0).getAttractiveTermNumber() == 13 ? database.getResultSet("SELECT * FROM unifacinterparamb_umrmc WHERE MainGroup=" + ((ComponentGEUnifac)this.getComponent(0)).getUnifacGroup(i).getMainGroup()) : database.getResultSet("SELECT * FROM unifacinterparamb_umr WHERE MainGroup=" + ((ComponentGEUnifac)this.getComponent(0)).getUnifacGroup(i).getMainGroup());
                dataSet.next();
                for (int j = 0; j < ((ComponentGEUnifac)this.getComponent(0)).getNumberOfUNIFACgroups(); ++j) {
                    this.bij[i][j] = Double.parseDouble(dataSet.getString("n" + ((ComponentGEUnifac)this.getComponent(0)).getUnifacGroup(j).getMainGroup()));
                }
                continue;
            }
            catch (Exception ex) {
                logger.error(ex.toString(), (Throwable)ex);
                continue;
            }
            finally {
                try {
                    if (dataSet != null) {
                        dataSet.close();
                    }
                }
                catch (Exception ex) {
                    logger.error("err closing dataSet...", (Throwable)ex);
                }
            }
        }
        try {
            if (database.getStatement() != null) {
                database.getStatement().close();
            }
            if (database.getConnection() != null) {
                database.getConnection().close();
            }
        }
        catch (Exception ex) {
            logger.error("error closing database.....", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calccij() {
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = null;
        this.cij = new double[((ComponentGEUnifac)this.getComponent(0)).getNumberOfUNIFACgroups()][((ComponentGEUnifac)this.getComponent(0)).getNumberOfUNIFACgroups()];
        for (int i = 0; i < ((ComponentGEUnifac)this.getComponent(0)).getNumberOfUNIFACgroups(); ++i) {
            try {
                dataSet = this.getPhase().getComponent(0).getAttractiveTermNumber() == 13 ? database.getResultSet("SELECT * FROM unifacinterparamc_umrmc WHERE MainGroup=" + ((ComponentGEUnifac)this.getComponent(0)).getUnifacGroup(i).getMainGroup()) : database.getResultSet("SELECT * FROM unifacinterparamc_umr WHERE MainGroup=" + ((ComponentGEUnifac)this.getComponent(0)).getUnifacGroup(i).getMainGroup());
                dataSet.next();
                for (int j = 0; j < ((ComponentGEUnifac)this.getComponent(0)).getNumberOfUNIFACgroups(); ++j) {
                    this.cij[i][j] = Double.parseDouble(dataSet.getString("n" + ((ComponentGEUnifac)this.getComponent(0)).getUnifacGroup(j).getMainGroup()));
                }
                continue;
            }
            catch (Exception ex) {
                logger.error(ex.toString(), (Throwable)ex);
                continue;
            }
            finally {
                try {
                    if (dataSet != null) {
                        dataSet.close();
                    }
                }
                catch (Exception ex) {
                    logger.error("err closing dataSet...", (Throwable)ex);
                }
            }
        }
        try {
            if (database.getStatement() != null) {
                database.getStatement().close();
            }
            if (database.getConnection() != null) {
                database.getConnection().close();
            }
        }
        catch (Exception ex) {
            logger.error("error closing database.....", (Throwable)ex);
        }
    }
}

