/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import java.sql.ResultSet;
import neqsim.thermo.component.ComponentGEUnifac;
import neqsim.thermo.component.ComponentGEUnifacPSRK;
import neqsim.thermo.component.ComponentGEUniquac;
import neqsim.thermo.phase.PhaseGEUnifac;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PhaseGEUnifacPSRK
extends PhaseGEUnifac {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(PhaseGEUnifacPSRK.class);

    public PhaseGEUnifacPSRK() {
        this.componentArray = new ComponentGEUnifacPSRK[100];
    }

    public PhaseGEUnifacPSRK(PhaseInterface phase, double[][] alpha, double[][] Dij, String[][] mixRule, double[][] intparam) {
        super(phase, alpha, Dij, mixRule, intparam);
        this.componentArray = new ComponentGEUnifac[alpha[0].length];
        for (int i = 0; i < alpha[0].length; ++i) {
            this.componentArray[i] = new ComponentGEUnifacPSRK(phase.getComponents()[i].getName(), phase.getComponents()[i].getNumberOfmoles(), phase.getComponents()[i].getNumberOfMolesInPhase(), phase.getComponents()[i].getComponentNumber());
        }
        this.setMixingRule(2);
    }

    @Override
    public void addcomponent(String componentName, double moles, double molesInPhase, int compNumber) {
        super.addcomponent(molesInPhase);
        this.componentArray[compNumber] = new ComponentGEUnifacPSRK(componentName, moles, molesInPhase, compNumber);
    }

    @Override
    public void setMixingRule(int type) {
        super.setMixingRule(type);
        if (!this.checkedGroups) {
            this.checkGroups();
        }
        this.calcbij();
        this.calccij();
    }

    @Override
    public void init(double totalNumberOfMoles, int numberOfComponents, int type, int phase, double beta) {
        super.init(totalNumberOfMoles, numberOfComponents, type, phase, beta);
    }

    @Override
    public double getExessGibbsEnergy(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype) {
        double GE = 0.0;
        for (int i = 0; i < numberOfComponents; ++i) {
            GE += phase.getComponents()[i].getx() * Math.log(((ComponentGEUniquac)this.componentArray[i]).getGamma(phase, numberOfComponents, temperature, pressure, phasetype));
        }
        return 8.3144621 * phase.getTemperature() * GE * phase.getNumberOfMolesInPhase();
    }

    public void calcbij() {
        this.bij = new double[((ComponentGEUnifac)this.getComponent(0)).getNumberOfUNIFACgroups()][((ComponentGEUnifac)this.getComponent(0)).getNumberOfUNIFACgroups()];
        for (int i = 0; i < ((ComponentGEUnifac)this.getComponent(0)).getNumberOfUNIFACgroups(); ++i) {
            for (int j = 0; j < ((ComponentGEUnifac)this.getComponent(0)).getNumberOfUNIFACgroups(); ++j) {
                try {
                    NeqSimDataBase database = new NeqSimDataBase();
                    ResultSet dataSet = null;
                    try {
                        dataSet = database.getResultSet("SELECT * FROM unifacinterparamb WHERE MainGroup=" + ((ComponentGEUnifac)this.getComponent(0)).getUnifacGroup(i).getMainGroup());
                        dataSet.next();
                        dataSet.getClob("MainGroup");
                    }
                    catch (Exception ex) {
                        dataSet.close();
                        dataSet = database.getResultSet("SELECT * FROM unifacinterparamb WHERE MainGroup=" + ((ComponentGEUnifac)this.getComponent(0)).getUnifacGroup(i).getMainGroup());
                        dataSet.next();
                    }
                    this.bij[i][j] = Double.parseDouble(dataSet.getString("n" + ((ComponentGEUnifac)this.getComponent(0)).getUnifacGroup(j).getMainGroup()));
                    dataSet.close();
                    database.getConnection().close();
                    continue;
                }
                catch (Exception ex) {
                    logger.error(ex.toString(), (Throwable)ex);
                }
            }
        }
        logger.info("finished finding interaction coefficient...B");
    }

    public void calccij() {
        this.cij = new double[((ComponentGEUnifac)this.getComponent(0)).getNumberOfUNIFACgroups()][((ComponentGEUnifac)this.getComponent(0)).getNumberOfUNIFACgroups()];
        for (int i = 0; i < ((ComponentGEUnifac)this.getComponent(0)).getNumberOfUNIFACgroups(); ++i) {
            for (int j = 0; j < ((ComponentGEUnifac)this.getComponent(0)).getNumberOfUNIFACgroups(); ++j) {
                try {
                    NeqSimDataBase database = new NeqSimDataBase();
                    ResultSet dataSet = null;
                    try {
                        dataSet = database.getResultSet("SELECT * FROM unifacinterparamc WHERE MainGroup=" + ((ComponentGEUnifac)this.getComponent(0)).getUnifacGroup(i).getMainGroup());
                        dataSet.next();
                        dataSet.getClob("MainGroup");
                    }
                    catch (Exception ex) {
                        dataSet.close();
                        dataSet = database.getResultSet("SELECT * FROM unifacinterparamc WHERE MainGroup=" + ((ComponentGEUnifac)this.getComponent(0)).getUnifacGroup(i).getMainGroup());
                        dataSet.next();
                    }
                    this.cij[i][j] = Double.parseDouble(dataSet.getString("n" + ((ComponentGEUnifac)this.getComponent(0)).getUnifacGroup(j).getMainGroup()));
                    dataSet.close();
                    database.getConnection().close();
                    continue;
                }
                catch (Exception ex) {
                    logger.error(ex.toString(), (Throwable)ex);
                }
            }
        }
        logger.info("finished finding interaction coefficient...C");
    }
}

