/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import java.sql.ResultSet;
import neqsim.thermo.component.ComponentDesmukhMather;
import neqsim.thermo.component.ComponentGEInterface;
import neqsim.thermo.phase.PhaseGE;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PhaseDesmukhMather
extends PhaseGE {
    private static final long serialVersionUID = 1000L;
    double GE = 0.0;
    double[][] aij;
    double[][] bij;
    static Logger logger = LogManager.getLogger(PhaseDesmukhMather.class);

    @Override
    public void addcomponent(String componentName, double moles, double molesInPhase, int compNumber) {
        super.addcomponent(molesInPhase);
        this.componentArray[compNumber] = new ComponentDesmukhMather(componentName, moles, molesInPhase, compNumber);
    }

    @Override
    public void init(double totalNumberOfMoles, int numberOfComponents, int initType, int phase, double beta) {
        super.init(totalNumberOfMoles, numberOfComponents, initType, phase, beta);
        if (initType != 0) {
            this.phaseTypeName = phase == 0 ? "liquid" : "gas";
        }
        this.setMolarVolume(9.8E-4 * this.getMolarMass() * 100000.0);
        this.Z = this.pressure * this.getMolarVolume() / (8.3144621 * this.temperature);
    }

    @Override
    public void setMixingRule(int type) {
        super.setMixingRule(type);
        this.aij = new double[this.numberOfComponents][this.numberOfComponents];
        this.bij = new double[this.numberOfComponents][this.numberOfComponents];
        NeqSimDataBase database = new NeqSimDataBase();
        for (int k = 0; k < this.getNumberOfComponents(); ++k) {
            String component_name = this.getComponents()[k].getComponentName();
            for (int l = k; l < this.getNumberOfComponents(); ++l) {
                try {
                    if (k == l) {
                        if (!this.getComponents()[l].getComponentName().equals("MDEA") || !this.getComponents()[k].getComponentName().equals("MDEA")) continue;
                        this.aij[k][l] = -0.0828487;
                        this.aij[l][k] = this.aij[k][l];
                        continue;
                    }
                    ResultSet dataSet = database.getResultSet("SELECT * FROM inter WHERE (comp1='" + component_name + "' AND comp2='" + this.getComponents()[l].getComponentName() + "') OR (comp1='" + this.getComponents()[l].getComponentName() + "' AND comp2='" + component_name + "')");
                    dataSet.next();
                    if (dataSet.getString("comp1").trim().equals(this.getComponents()[l].getComponentName())) {
                        // empty if block
                    }
                    this.aij[k][l] = Double.parseDouble(dataSet.getString("aijDesMath"));
                    this.bij[k][l] = Double.parseDouble(dataSet.getString("bijDesMath"));
                    this.aij[l][k] = this.aij[k][l];
                    this.bij[l][k] = this.bij[k][l];
                    dataSet.close();
                    continue;
                }
                catch (Exception ex) {
                    logger.info("comp names " + component_name);
                    logger.error(ex.toString());
                }
            }
        }
    }

    public void setAij(double[][] alpha) {
        for (int i = 0; i < alpha.length; ++i) {
            System.arraycopy(this.aij[i], 0, this.aij[i], 0, alpha[0].length);
        }
    }

    public void setBij(double[][] Dij) {
        for (int i = 0; i < Dij.length; ++i) {
            System.arraycopy(this.bij[i], 0, this.bij[i], 0, Dij[0].length);
        }
    }

    public double getBetaDesMatij(int i, int j) {
        return this.aij[i][j] + this.bij[i][j] * this.temperature;
    }

    public double getAij(int i, int j) {
        return this.aij[i][j];
    }

    public double getBij(int i, int j) {
        return this.bij[i][j];
    }

    @Override
    public double getExessGibbsEnergy(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype) {
        this.GE = 0.0;
        for (int i = 0; i < numberOfComponents; ++i) {
            this.GE += phase.getComponents()[i].getx() * Math.log(((ComponentDesmukhMather)this.componentArray[i]).getGamma(phase, numberOfComponents, temperature, pressure, phasetype));
        }
        return 8.3144621 * temperature * this.numberOfMolesInPhase * this.GE;
    }

    @Override
    public double getGibbsEnergy() {
        return 8.3144621 * this.temperature * this.numberOfMolesInPhase * (this.GE + Math.log(this.pressure));
    }

    @Override
    public double getExessGibbsEnergy() {
        return this.GE;
    }

    @Override
    public double getActivityCoefficient(int k, int p) {
        return ((ComponentGEInterface)this.getComponent(k)).getGamma();
    }

    @Override
    public double getActivityCoefficient(int k) {
        return ((ComponentGEInterface)this.getComponent(k)).getGamma();
    }

    public double getIonicStrength() {
        double ionStrength = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            ionStrength += this.getComponent(i).getMolality(this) * Math.pow(this.getComponent(i).getIonicCharge(), 2.0);
        }
        return 0.5 * ionStrength;
    }

    public double getSolventWeight() {
        double moles = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            if (!this.getComponent(i).getReferenceStateType().equals("solvent")) continue;
            moles += this.getComponent(i).getNumberOfMolesInPhase() * this.getComponent(i).getMolarMass();
        }
        return moles;
    }

    public double getSolventDensity() {
        return 1020.0;
    }

    public double getSolventMolarMass() {
        double molesMass = 0.0;
        double moles = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            if (!this.getComponent(i).getReferenceStateType().equals("solvent")) continue;
            molesMass += this.getComponent(i).getNumberOfMolesInPhase() * this.getComponent(i).getMolarMass();
            moles = this.getComponent(i).getNumberOfMolesInPhase();
        }
        return molesMass / moles;
    }
}

