/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component.attractiveEosTerm;

import neqsim.MathLib.nonLinearSolver.newtonRhapson;
import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermBaseClass;

public class AttractiveTermSrk
extends AttractiveTermBaseClass {
    private static final long serialVersionUID = 1000L;

    public AttractiveTermSrk() {
    }

    public AttractiveTermSrk(ComponentEosInterface component) {
        super(component);
        this.m = 0.48 + 1.574 * component.getAcentricFactor() - 0.176 * component.getAcentricFactor() * component.getAcentricFactor();
    }

    @Override
    public AttractiveTermSrk clone() {
        AttractiveTermSrk attractiveTerm = null;
        try {
            attractiveTerm = (AttractiveTermSrk)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return attractiveTerm;
    }

    @Override
    public void setm(double val) {
        this.m = val;
        newtonRhapson solve = new newtonRhapson();
        solve.setOrder(2);
        double[] acentricConstants = new double[]{-0.176, 1.574, 0.48 - this.m};
        solve.setConstants(acentricConstants);
        this.getComponent().setAcentricFactor(solve.solve(0.2));
    }

    @Override
    public void init() {
        this.m = 0.48 + 1.574 * this.getComponent().getAcentricFactor() - 0.176 * this.getComponent().getAcentricFactor() * this.getComponent().getAcentricFactor();
    }

    @Override
    public double alpha(double temperature) {
        double temp = 1.0 + this.m * (1.0 - Math.sqrt(temperature / this.getComponent().getTC()));
        return temp * temp;
    }

    @Override
    public double aT(double temperature) {
        return this.getComponent().geta() * this.alpha(temperature);
    }

    @Override
    public double diffalphaT(double temperature) {
        double temp = Math.sqrt(temperature / this.getComponent().getTC());
        return -(1.0 + this.m * (1.0 - temp)) * this.m / temp / this.getComponent().getTC();
    }

    @Override
    public double diffdiffalphaT(double temperature) {
        double tr = temperature / this.getComponent().getTC();
        return this.m * this.m / temperature / this.getComponent().getTC() / 2.0 + (1.0 + this.m * (1.0 - Math.sqrt(tr))) * this.m / Math.sqrt(tr * tr * tr) / (this.getComponent().getTC() * this.getComponent().getTC()) / 2.0;
    }

    @Override
    public double diffaT(double temperature) {
        return this.getComponent().geta() * this.diffalphaT(temperature);
    }

    @Override
    public double diffdiffaT(double temperature) {
        return this.getComponent().geta() * this.diffdiffalphaT(temperature);
    }
}

