/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import neqsim.thermo.component.ComponentEos;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermTwu;

public class ComponentTST
extends ComponentEos {
    private static final long serialVersionUID = 1000L;

    public ComponentTST(String component_name, double moles, double molesInPhase, int compnumber) {
        super(component_name, moles, molesInPhase, compnumber);
        this.a = 29.551881229953583 * this.criticalTemperature * this.criticalTemperature / this.criticalPressure;
        this.b = 0.7203733108061 * this.criticalTemperature / this.criticalPressure;
        this.delta1 = 1.0 + Math.sqrt(2.0);
        this.delta2 = 1.0 - Math.sqrt(2.0);
        this.setAttractiveParameter(new AttractiveTermTwu(this));
    }

    public ComponentTST(int number, double TC, double PC, double M, double a, double moles) {
        super(number, TC, PC, M, a, moles);
    }

    @Override
    public ComponentTST clone() {
        ComponentTST clonedComponent = null;
        try {
            clonedComponent = (ComponentTST)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedComponent;
    }

    @Override
    public void init(double temperature, double pressure, double totalNumberOfMoles, double beta, int type) {
        super.init(temperature, pressure, totalNumberOfMoles, beta, type);
    }

    @Override
    public double calca() {
        return 29.551881229953583 * this.criticalTemperature * this.criticalTemperature / this.criticalPressure;
    }

    @Override
    public double calcb() {
        return 0.7203733108061 * this.criticalTemperature / this.criticalPressure;
    }

    @Override
    public double getVolumeCorrection() {
        if (this.getRacketZ() < 1.0E-10) {
            return 0.0;
        }
        return 0.40768 * (0.29441 - this.getRacketZ()) * 8.3144621 * this.criticalTemperature / this.criticalPressure;
    }

    public double getQpure(double temperature) {
        return this.getaT() / (this.getb() * 8.3144621 * temperature);
    }

    public double getdQpuredT(double temperature) {
        return this.dqPuredT;
    }

    public double getdQpuredTdT(double temperature) {
        return this.dqPuredTdT;
    }
}

