/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import neqsim.thermo.component.ComponentCPAInterface;
import neqsim.thermo.component.ComponentPR;
import neqsim.thermo.phase.PhaseCPAInterface;
import neqsim.thermo.phase.PhaseInterface;

abstract class ComponentPrCPA
extends ComponentPR
implements ComponentCPAInterface {
    private static final long serialVersionUID = 1000L;
    int cpaon = 1;
    double[] xsite = new double[this.numberOfAssociationSites];

    public ComponentPrCPA(String component_name, double moles, double molesInPhase, int compnumber) {
        super(component_name, moles, molesInPhase, compnumber);
        if ((this.numberOfAssociationSites != 0 || Math.abs(this.aCPA) > 1.0E-6) && this.cpaon == 1) {
            for (int j = 0; j < this.getNumberOfAssociationSites(); ++j) {
                this.setXsite(j, 0.0);
            }
            this.a = this.aCPA;
            this.b = this.bCPA;
            this.setAttractiveTerm(1);
        }
    }

    public ComponentPrCPA(int number, double TC, double PC, double M, double a, double moles) {
        super(number, TC, PC, M, a, moles);
        for (int j = 0; j < this.getNumberOfAssociationSites(); ++j) {
            this.setXsite(j, 1.0);
        }
        if ((this.numberOfAssociationSites != 0 || Math.abs(this.aCPA) > 1.0E-6) && this.cpaon == 1) {
            a = this.aCPA;
            this.b = this.bCPA;
        }
        this.setAttractiveTerm(1);
    }

    @Override
    public double getVolumeCorrection() {
        if (this.aCPA > 1.0E-10 && this.cpaon == 1) {
            return 0.0;
        }
        return super.getVolumeCorrection();
    }

    @Override
    public ComponentPrCPA clone() {
        ComponentPrCPA clonedComponent = null;
        try {
            clonedComponent = (ComponentPrCPA)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedComponent;
    }

    @Override
    public void init(double temperature, double pressure, double totalNumberOfMoles, double beta, int type) {
        super.init(temperature, pressure, totalNumberOfMoles, beta, type);
    }

    @Override
    public double calca() {
        if ((this.numberOfAssociationSites != 0 || Math.abs(this.aCPA) > 1.0E-6) && this.cpaon == 1) {
            return this.aCPA;
        }
        return this.a;
    }

    @Override
    public double calcb() {
        if ((this.numberOfAssociationSites != 0 || Math.abs(this.aCPA) > 1.0E-6) && this.cpaon == 1) {
            return this.bCPA;
        }
        return this.b;
    }

    @Override
    public void setAttractiveTerm(int i) {
        super.setAttractiveTerm(i);
        if ((this.getNumberOfAssociationSites() > 0 || Math.abs(this.aCPA) > 1.0E-6) && this.cpaon == 1) {
            this.getAttractiveTerm().setm(this.mCPA);
        }
    }

    @Override
    public double dFdN(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        double Fsup = super.dFdN(phase, numberOfComponents, temperature, pressure);
        double Fcpa = 0.0;
        Fcpa = this.dFCPAdN(phase, numberOfComponents, temperature, pressure);
        return Fsup + (double)this.cpaon * Fcpa;
    }

    @Override
    public double dFdNdT(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return super.dFdNdT(phase, numberOfComponents, temperature, pressure);
    }

    @Override
    public double dFdNdV(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return super.dFdNdV(phase, numberOfComponents, temperature, pressure);
    }

    @Override
    public double dFdNdN(int j, PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return super.dFdNdN(j, phase, numberOfComponents, temperature, pressure);
    }

    public double dFCPAdN(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        double xi = 0.0;
        for (int i = 0; i < this.numberOfAssociationSites; ++i) {
            xi += Math.log(this.xsite[i]);
        }
        return xi - ((PhaseCPAInterface)phase).getHcpatot() / 2.0 * this.calc_lngi(phase);
    }

    public double calc_lngi(PhaseInterface phase) {
        return 0.475 / (1.0 - 0.475 * phase.getB() / phase.getTotalVolume()) * this.getBi() / phase.getTotalVolume();
    }

    public double calc_lngi2(PhaseInterface phase) {
        return 2.0 * this.getBi() * (10.0 * phase.getTotalVolume() - phase.getB()) / ((8.0 * phase.getTotalVolume() - phase.getB()) * (4.0 * phase.getTotalVolume() - phase.getB()));
    }

    @Override
    public double[] getXsite() {
        return this.xsite;
    }

    public void setXsite(double[] xsite) {
        this.xsite = xsite;
    }

    @Override
    public void setXsite(int i, double xsite) {
        this.xsite[i] = xsite;
    }
}

