/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.characterization;

import java.io.Serializable;
import java.util.ArrayList;
import neqsim.thermo.characterization.CharacteriseInterface;
import neqsim.thermo.system.SystemInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlusCharacterize
implements Serializable,
CharacteriseInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(PlusCharacterize.class);
    double[] TBPfractions = null;
    boolean firsttime = true;
    double MPlus = 300.0;
    double zPlus = 0.3;
    double densPlus = 0.98;
    private double densLastTBP = 0.78;
    int[] carbonNumberVector = null;
    protected boolean pseudocomponents = true;
    int firstPlusFractionNumber = 1;
    int lastPlusFractionNumber = 80;
    int numberOfPseudocomponents = 5;
    int length = 0;
    double[] coefs = new double[]{4.4660105006, -1.1266303727, 0.8, 0.0408709562};
    double[] SRKcoefs = new double[]{4.4660105006, -1.1266303727, 8.1927423578, -3.4668277785};
    double[] PRcoefs = new double[]{4.4660105006, -1.1266303727, 8.1927423578, -3.4668277785};
    double[] plusCoefs = new double[]{7.774204804E-4, -0.02390179};
    SystemInterface system = null;

    public PlusCharacterize() {
    }

    public PlusCharacterize(SystemInterface system) {
        this.system = system;
    }

    @Override
    public boolean hasPlusFraction() {
        for (int i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
            if (!this.system.getPhase(0).getComponent(i).isIsPlusFraction()) continue;
            return true;
        }
        return false;
    }

    public void setHeavyTBPtoPlus() {
        int i;
        int plusCompNumber = 0;
        int compNumber = 0;
        for (i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
            try {
                if (!this.system.getPhase(0).getComponent(i).isIsTBPfraction()) continue;
                Integer firstPlusNumber = 0;
                firstPlusNumber = this.system.getPhase(0).getComponent(i).getComponentName().substring(3, 4).equals("_") ? Integer.valueOf(this.system.getPhase(0).getComponent(i).getComponentName().substring(1, 3)) : Integer.valueOf(this.system.getPhase(0).getComponent(i).getComponentName().substring(1, 2));
                if (plusCompNumber >= firstPlusNumber) continue;
                plusCompNumber = firstPlusNumber;
                compNumber = i;
                continue;
            }
            catch (Exception ex) {
                ex.toString();
            }
        }
        for (i = 0; i < this.system.getNumberOfPhases(); ++i) {
            this.system.getPhase(i).getComponent(compNumber).setIsTBPfraction(false);
            this.system.getPhase(i).getComponent(compNumber).setIsPlusFraction(true);
            this.MPlus = this.system.getPhase(i).getComponent(compNumber).getMolarMass();
            this.zPlus = this.system.getPhase(i).getComponent(compNumber).getz();
            this.densPlus = this.system.getPhase(i).getComponent(compNumber).getNormalLiquidDensity();
        }
        this.coefs[2] = this.system.getPhase(0).getComponent(compNumber - 1).getNormalLiquidDensity() + 0.03;
        this.densLastTBP = this.system.getPhase(0).getComponent(compNumber - 1).getNormalLiquidDensity();
    }

    @Override
    public void solve() {
        for (int i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
            try {
                if (!this.system.getPhase(0).getComponent(i).isIsPlusFraction()) continue;
                Integer firstPlusNumber = 0;
                firstPlusNumber = this.system.getPhase(0).getComponent(i).getComponentName().substring(3, 4).equals("_") ? Integer.valueOf(this.system.getPhase(0).getComponent(i).getComponentName().substring(1, 3)) : Integer.valueOf(this.system.getPhase(0).getComponent(i).getComponentName().substring(1, 2));
                if (this.firstPlusFractionNumber >= firstPlusNumber) continue;
                this.firstPlusFractionNumber = firstPlusNumber;
                continue;
            }
            catch (Exception ex) {
                ex.toString();
            }
        }
        logger.info("first plus fraction number " + this.firstPlusFractionNumber);
    }

    @Override
    public double[] getCoefs() {
        return this.coefs;
    }

    @Override
    public double getCoef(int i) {
        return this.coefs[i];
    }

    @Override
    public void setCoefs(double[] coefs) {
        System.arraycopy(coefs, 0, this.coefs, 0, coefs.length);
        if (this.firsttime) {
            if (coefs.length == 3) {
                double Dtot = 0.0;
                for (int i = this.getFirstPlusFractionNumber(); i < this.getLastPlusFractionNumber(); ++i) {
                    Dtot += (this.getDensPlus() - this.getCoef(2)) / Math.log(i);
                }
                double lengthPlus = this.getLastPlusFractionNumber() - this.getFirstPlusFractionNumber();
                logger.info("length plus " + lengthPlus);
                logger.info("D " + (Dtot /= lengthPlus));
                this.coefs[3] = Dtot;
            }
            this.firsttime = false;
        }
        double mSum = 0.0;
        double densSum = 0.0;
        int iter = 0;
        do {
            ++iter;
            mSum = 0.0;
            densSum = 0.0;
            for (int i = this.getFirstPlusFractionNumber(); i < this.getLastPlusFractionNumber(); ++i) {
                double ztemp = Math.exp(this.getCoef(0) + this.getCoef(1) * (double)i);
                double M = PVTsimMolarMass[i - 6] / 1000.0;
                double dens = this.getCoef(2) + this.getCoef(3) * Math.log(i);
                mSum += ztemp * M;
                densSum += ztemp * M / dens;
            }
            densSum = mSum / densSum;
            this.coefs[3] = this.coefs[3] + 1.0 * (this.densPlus - densSum) / densSum * this.coefs[3];
        } while (Math.abs(this.densPlus - densSum) > 1.0E-6 && iter < 1000);
    }

    @Override
    public void setCoefs(double coef, int i) {
        this.coefs[i] = coef;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public void generatePlusFractions(int start, int end, double zplus, double Mplus) {
    }

    @Override
    public void addHeavyEnd() {
    }

    @Override
    public void generateTBPFractions() {
    }

    @Override
    public void addCharacterizedPlusFraction() {
        int i;
        if (!this.pseudocomponents) {
            this.numberOfPseudocomponents = this.getLastPlusFractionNumber() - this.getFirstPlusFractionNumber() + 1;
        }
        double[] zPlus = new double[this.numberOfPseudocomponents];
        double[] MPlus = new double[this.numberOfPseudocomponents];
        double weightFrac = 0.0;
        double weightTot = 0.0;
        for (int i2 = this.getFirstPlusFractionNumber(); i2 < this.getLastPlusFractionNumber(); ++i2) {
            weightTot += Math.exp(this.getCoef(0) + this.getCoef(1) * (double)i2) * PVTsimMolarMass[i2 - 6] / 1000.0;
        }
        double meanWeightFrac = weightTot / ((double)this.numberOfPseudocomponents + 1.0E-6);
        zPlus = new double[this.numberOfPseudocomponents];
        MPlus = new double[this.numberOfPseudocomponents];
        int k = 0;
        int firstPS = this.firstPlusFractionNumber;
        double Maverage = 0.0;
        double denstemp1 = 0.0;
        double denstemp2 = 0.0;
        double totalNumberOfMoles = this.system.getNumberOfMoles();
        for (i = this.getFirstPlusFractionNumber(); i < this.getLastPlusFractionNumber(); ++i) {
            int n = k;
            zPlus[n] = zPlus[n] + Math.exp(this.getCoef(0) + this.getCoef(1) * (double)i);
            int n2 = k;
            MPlus[n2] = MPlus[n2] + PVTsimMolarMass[i - 6] / 1000.0;
            denstemp1 += Math.exp(this.getCoef(0) + this.getCoef(1) * (double)i) * PVTsimMolarMass[i - 6] / 1000.0;
            denstemp2 += Math.exp(this.getCoef(0) + this.getCoef(1) * (double)i) * PVTsimMolarMass[i - 6] / 1000.0 / (this.getCoef(2) + this.getCoef(3) * Math.log(i));
            Maverage += Math.exp(this.getCoef(0) + this.getCoef(1) * (double)i) * PVTsimMolarMass[i - 6] / 1000.0;
            if (!((weightFrac += Math.exp(this.getCoef(0) + this.getCoef(1) * (double)i) * PVTsimMolarMass[i - 6] / 1000.0) >= meanWeightFrac) && this.pseudocomponents && i != this.getLastPlusFractionNumber() - 1) continue;
            String name = i == firstPS ? "PC" + Integer.toString(firstPS) : "PC" + Integer.toString(firstPS) + "-" + Integer.toString(i);
            this.system.addTBPfraction(name, totalNumberOfMoles * zPlus[k], Maverage / zPlus[k], denstemp1 / denstemp2);
            denstemp1 = 0.0;
            denstemp2 = 0.0;
            weightFrac = 0.0;
            Maverage = 0.0;
            ++k;
            firstPS = i + 1;
        }
        for (i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
            if (!this.system.getPhase(0).getComponent(i).isIsPlusFraction()) continue;
            this.system.removeComponent(this.system.getPhase(0).getComponent(i).getName());
            break;
        }
    }

    public void addPseudoTBPfraction(int start, int end) {
    }

    public int[] getCarbonNumberVector() {
        return this.carbonNumberVector;
    }

    public void setCarbonNumberVector(int[] carbonNumberVector) {
        this.carbonNumberVector = carbonNumberVector;
    }

    @Override
    public int getFirstPlusFractionNumber() {
        return this.firstPlusFractionNumber;
    }

    @Override
    public int getLastPlusFractionNumber() {
        return this.lastPlusFractionNumber;
    }

    public void setFirstPlusFractionNumber(int firstPlusFractionNumber) {
        this.firstPlusFractionNumber = firstPlusFractionNumber;
    }

    public int getStartPlus() {
        return this.firstPlusFractionNumber;
    }

    @Deprecated
    public void setStartPlus(int startPlus) {
        this.setFirstPlusFractionNumber(startPlus);
    }

    @Override
    public double getMPlus() {
        return this.MPlus;
    }

    @Override
    public void setMPlus(double MPlus) {
        this.MPlus = MPlus;
    }

    @Override
    public double getZPlus() {
        return this.zPlus;
    }

    @Override
    public void setZPlus(double zPlus) {
        this.zPlus = zPlus;
    }

    @Override
    public double[] getPlusCoefs() {
        return this.plusCoefs;
    }

    @Override
    public double getPlusCoefs(int i) {
        return this.plusCoefs[i];
    }

    @Override
    public void setPlusCoefs(double[] plusCoefs) {
        this.plusCoefs = plusCoefs;
    }

    @Override
    public double getDensPlus() {
        return this.densPlus;
    }

    public void setDensPlus(double densPlus) {
        this.densPlus = densPlus;
    }

    @Override
    public boolean groupTBPfractions() {
        return true;
    }

    public int getNumberOfPseudocomponents() {
        return this.numberOfPseudocomponents;
    }

    @Override
    public void setNumberOfPseudocomponents(int numberOfPseudocomponents) {
        this.numberOfPseudocomponents = numberOfPseudocomponents;
    }

    @Override
    public boolean isPseudocomponents() {
        return this.pseudocomponents;
    }

    @Override
    public void setPseudocomponents(boolean pseudocomponents) {
        this.pseudocomponents = pseudocomponents;
    }

    @Override
    public void removeTBPfraction() {
        int i;
        ArrayList<String> list = new ArrayList<String>();
        for (i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
            double boilpoint = this.system.getPhase(0).getComponent(i).getNormalBoilingPoint();
            if (!(boilpoint >= 69.0)) continue;
            list.add(this.system.getPhase(0).getComponent(i).getName());
        }
        for (i = 0; i < list.size(); ++i) {
            try {
                this.system.removeComponent((String)list.get(i));
                logger.info("removing " + (String)list.get(i));
                continue;
            }
            catch (Exception ex) {
                logger.error("not able to remove " + (String)list.get(i));
            }
        }
    }

    @Override
    public void addTBPFractions() {
    }

    @Override
    public double getDensLastTBP() {
        return this.densLastTBP;
    }

    @Override
    public void setDensLastTBP(double densLastTBP) {
        this.densLastTBP = densLastTBP;
    }

    public void characterizePlusFraction() {
        this.system.init(0);
        for (int i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
            if (!this.system.getPhase(0).getComponent(i).isIsPlusFraction()) continue;
            this.MPlus = this.system.getPhase(0).getComponent(i).getMolarMass();
            this.zPlus = this.system.getPhase(0).getComponent(i).getz();
            this.densPlus = this.system.getPhase(0).getComponent(i).getNormalLiquidDensity();
        }
        this.coefs[0] = 0.1;
        this.coefs[1] = Math.log(this.zPlus) / (double)this.getFirstPlusFractionNumber();
        this.solve();
    }
}

