/*
 * Decompiled with CFR 0.152.
 */
package neqsim.standards.oilQuality;

import neqsim.standards.Standard;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Standard_ASTM_D6377
extends Standard {
    private static final long serialVersionUID = 1L;
    static Logger logger = LogManager.getLogger(Standard_ASTM_D6377.class);
    String unit = "bara";
    double RVP = 1.0;

    public Standard_ASTM_D6377(SystemInterface thermoSystem) {
        super("Standard_ASTM_D6377", "Standard_ASTM_D6377", thermoSystem);
    }

    @Override
    public void calculate() {
        this.thermoSystem.setTemperature(310.95);
        this.thermoSystem.setPressure(1.01325);
        this.thermoOps = new ThermodynamicOperations(this.thermoSystem);
        try {
            this.thermoOps.bubblePointPressureFlash(false);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        double liquidVolume = this.thermoSystem.getVolume();
        this.thermoSystem.setPressure(0.9);
        try {
            this.thermoOps.TVflash(liquidVolume * 4.0);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        this.RVP = (0.752 * (100.0 * this.thermoSystem.getPressure()) + 6.07) / 100.0;
    }

    @Override
    public boolean isOnSpec() {
        return true;
    }

    @Override
    public String getUnit(String returnParameter) {
        return this.unit;
    }

    @Override
    public double getValue(String returnParameter, String returnUnit) {
        return this.RVP;
    }

    @Override
    public double getValue(String returnParameter) {
        return this.RVP;
    }

    public static void main(String[] args) {
        SystemSrkEos testSystem = new SystemSrkEos(275.15, 1.0);
        testSystem.addComponent("methane", 6.538E-4);
        testSystem.addComponent("ethane", 0.006538);
        testSystem.addComponent("propane", 0.006538);
        testSystem.addComponent("n-pentane", 0.545);
        testSystem.setMixingRule(2);
        testSystem.init(0);
        Standard_ASTM_D6377 standard = new Standard_ASTM_D6377(testSystem);
        standard.calculate();
        System.out.println("RVP " + standard.getValue("RVP", "bara"));
    }
}

