/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.util;

import java.util.UUID;
import neqsim.processSimulation.processEquipment.TwoPortEquipment;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class MoleFractionControllerUtil
extends TwoPortEquipment {
    private static final long serialVersionUID = 1000L;
    SystemInterface thermoSystem;
    ThermodynamicOperations thermoOps;
    String compName = null;
    double moleFrac = 1.0;
    double molesChange = 0.0;
    double moleFractionReductionRatio = 0.0;
    boolean moleFractionReduction = false;

    public MoleFractionControllerUtil(StreamInterface inletStream) {
        super("MoleFractionControllerUtil");
        this.setInletStream(inletStream);
    }

    @Override
    public void setInletStream(StreamInterface inletStream) {
        this.inStream = inletStream;
        this.thermoSystem = inletStream.getThermoSystem().clone();
        this.outStream = new Stream("outStream", this.thermoSystem);
    }

    public double getMolesChange() {
        return this.molesChange;
    }

    public void setMoleFraction(String compName, double moleFrac) {
        this.moleFractionReduction = false;
        this.moleFrac = moleFrac;
        this.compName = compName;
    }

    public void setComponentRate(String compName, double rate, String unit) {
        this.moleFractionReduction = false;
        if (unit.equals("litre/MSm^3")) {
            this.moleFrac = rate * this.thermoSystem.getPhase(0).getComponent(compName).getNormalLiquidDensity() / this.thermoSystem.getPhase(0).getComponent(compName).getMolarMass() / 4.229489667E7;
        }
        this.compName = compName;
    }

    public void setRelativeMoleFractionReduction(String compName, double moleFracRatio) {
        this.moleFractionReduction = true;
        this.moleFractionReductionRatio = moleFracRatio;
        this.compName = compName;
    }

    @Override
    public void run(UUID id) {
        this.thermoSystem = this.inStream.getThermoSystem().clone();
        if (this.thermoSystem.getPhase(0).hasComponent(this.compName)) {
            this.thermoOps = new ThermodynamicOperations(this.thermoSystem);
            this.thermoSystem.init(1);
            double deltaFrac = this.moleFrac - this.thermoSystem.getPhase(0).getComponent(this.compName).getz();
            if (this.moleFractionReduction) {
                deltaFrac = this.moleFractionReductionRatio * this.thermoSystem.getPhase(0).getComponent(this.compName).getz();
            }
            double molesChange = deltaFrac * this.thermoSystem.getTotalNumberOfMoles();
            this.thermoSystem.addComponent(this.compName, molesChange);
            this.thermoOps.TPflash();
        }
        this.outStream.setThermoSystem(this.thermoSystem);
        this.setCalculationIdentifier(id);
    }

    @Override
    public void displayResult() {
        this.thermoSystem.display(this.getName());
    }
}

