/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.util;

import java.util.ArrayList;
import java.util.UUID;
import neqsim.processSimulation.processEquipment.ProcessEquipmentBaseClass;
import neqsim.processSimulation.processEquipment.ProcessEquipmentInterface;
import neqsim.processSimulation.processEquipment.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Calculator
extends ProcessEquipmentBaseClass {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Calculator.class);
    ArrayList<ProcessEquipmentInterface> inputVariable = new ArrayList();
    private ProcessEquipmentInterface outputVariable;
    String type = "sumTEG";

    public Calculator(String name) {
        super(name);
    }

    public void addInputVariable(ProcessEquipmentInterface unit) {
        this.inputVariable.add(unit);
    }

    public ProcessEquipmentInterface getOutputVariable() {
        return this.outputVariable;
    }

    @Override
    public void run(UUID id) {
        double sum = 0.0;
        if (this.name.equals("MEG makeup calculator")) {
            for (int i = 0; i < this.inputVariable.size(); ++i) {
                sum += this.inputVariable.get(i).getFluid().getPhase(0).getComponent("MEG").getFlowRate("kg/hr");
            }
        } else {
            for (int i = 0; i < this.inputVariable.size(); ++i) {
                sum += this.inputVariable.get(i).getFluid().getComponent("TEG").getFlowRate("kg/hr");
            }
        }
        try {
            if (sum < 1.0E-10) {
                sum = 1.0E-10;
            }
            ((Stream)this.outputVariable).setFlowRate(sum, "kg/hr");
            this.outputVariable.run();
            this.outputVariable.setCalculationIdentifier(id);
        }
        catch (Exception ex) {
            logger.info("flow rate error " + sum);
            logger.error("error in calculator");
        }
        this.setCalculationIdentifier(id);
    }

    public void setOutputVariable(ProcessEquipmentInterface outputVariable) {
        this.outputVariable = outputVariable;
    }
}

