/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.splitter;

import java.util.UUID;
import neqsim.processSimulation.processEquipment.ProcessEquipmentBaseClass;
import neqsim.processSimulation.processEquipment.splitter.SplitterInterface;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Splitter
extends ProcessEquipmentBaseClass
implements SplitterInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Splitter.class);
    SystemInterface thermoSystem;
    SystemInterface gasSystem;
    SystemInterface waterSystem;
    SystemInterface liquidSystem;
    SystemInterface thermoSystemCloned;
    StreamInterface inletStream;
    StreamInterface[] splitStream;
    protected int splitNumber = 1;
    double[] splitFactor = new double[1];
    double[] flowRates;
    String flowUnit = "mole/sec";

    public Splitter() {
        super("Splitter");
    }

    @Deprecated
    public Splitter(StreamInterface inletStream) {
        this();
        this.setInletStream(inletStream);
    }

    public Splitter(String name) {
        super(name);
    }

    public Splitter(String name, StreamInterface inStream) {
        this(name);
        this.setInletStream(inStream);
    }

    public Splitter(String name, StreamInterface inletStream, int i) {
        this(name);
        this.setSplitNumber(i);
        this.setInletStream(inletStream);
    }

    @Override
    public void setSplitNumber(int i) {
        this.splitNumber = i;
        this.splitFactor = new double[this.splitNumber];
        this.splitFactor[0] = 1.0;
        this.setInletStream(this.inletStream);
    }

    public void setSplitFactors(double[] splitFact) {
        int i;
        double sum = 0.0;
        for (i = 0; i < splitFact.length; ++i) {
            if (splitFact[i] < 0.0) {
                splitFact[i] = 0.0;
            }
            sum += splitFact[i];
        }
        this.splitFactor = new double[splitFact.length];
        for (i = 0; i < splitFact.length; ++i) {
            this.splitFactor[i] = splitFact[i] / sum;
        }
        this.splitNumber = splitFact.length;
        this.flowRates = null;
        this.setInletStream(this.inletStream);
    }

    public void setFlowRates(double[] flowRates, String flowUnit) {
        if (flowRates.length != this.splitNumber) {
            this.setInletStream(this.inletStream);
        }
        this.flowRates = flowRates;
        this.flowUnit = flowUnit;
        this.splitNumber = flowRates.length;
        this.splitFactor = new double[flowRates.length];
        this.splitFactor[0] = 1.0;
        this.setInletStream(this.inletStream);
    }

    public void calcSplitFactors() {
        int i;
        double sum = 0.0;
        for (int i2 = 0; i2 < this.flowRates.length; ++i2) {
            if (!(this.flowRates[i2] > 0.0)) continue;
            sum += this.flowRates[i2];
        }
        double missingFlowRate = 0.0;
        for (i = 0; i < this.flowRates.length; ++i) {
            if (!(this.flowRates[i] < -0.1)) continue;
            missingFlowRate = this.inletStream.getFlowRate(this.flowUnit) - sum;
            sum += missingFlowRate;
        }
        this.splitFactor = new double[this.flowRates.length];
        for (i = 0; i < this.flowRates.length; ++i) {
            this.splitFactor[i] = this.flowRates[i] / sum;
            if (!(this.flowRates[i] < -0.1)) continue;
            this.splitFactor[i] = missingFlowRate / sum;
        }
    }

    @Override
    public void setInletStream(StreamInterface inletStream) {
        this.inletStream = inletStream;
        if (this.splitStream == null || this.splitStream.length != this.splitNumber) {
            this.splitStream = new Stream[this.splitNumber];
            try {
                for (int i = 0; i < this.splitNumber; ++i) {
                    this.splitStream[i] = new Stream("Split Stream", inletStream.getThermoSystem().clone());
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
            }
        }
    }

    @Override
    public StreamInterface getSplitStream(int i) {
        return this.splitStream[i];
    }

    @Override
    public void run(UUID id) {
        int i;
        double totSplit = 0.0;
        if (this.flowRates != null) {
            this.calcSplitFactors();
        }
        for (i = 0; i < this.splitNumber; ++i) {
            if (this.splitFactor[i] < 0.0) {
                logger.debug("split factor negative = " + this.splitFactor[i]);
                this.splitFactor[i] = 0.0;
            }
            totSplit += this.splitFactor[i];
        }
        if (Math.abs(totSplit - 1.0) > 1.0E-10) {
            logger.debug("total split factor different from 0 in splitter - totsplit = " + totSplit);
            logger.debug("setting first split to = " + (1.0 - totSplit));
            this.splitFactor[0] = 1.0 - totSplit;
        }
        for (i = 0; i < this.splitNumber; ++i) {
            this.thermoSystem = this.inletStream.getThermoSystem().clone();
            this.thermoSystem.init(0);
            this.splitStream[i].setThermoSystem(this.thermoSystem);
            for (int j = 0; j < this.inletStream.getThermoSystem().getPhase(0).getNumberOfComponents(); ++j) {
                int index = this.inletStream.getThermoSystem().getPhase(0).getComponent(j).getComponentNumber();
                double moles = this.inletStream.getThermoSystem().getPhase(0).getComponent(j).getNumberOfmoles();
                this.splitStream[i].getThermoSystem().addComponent(index, moles * this.splitFactor[i] - moles);
            }
            ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.splitStream[i].getThermoSystem());
            thermoOps.TPflash();
        }
        this.setCalculationIdentifier(id);
    }

    @Override
    public void displayResult() {
    }
}

