/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.powerGeneration;

import java.util.UUID;
import neqsim.processSimulation.mechanicalDesign.compressor.CompressorMechanicalDesign;
import neqsim.processSimulation.processEquipment.TwoPortEquipment;
import neqsim.processSimulation.processEquipment.compressor.Compressor;
import neqsim.processSimulation.processEquipment.expander.Expander;
import neqsim.processSimulation.processEquipment.heatExchanger.Cooler;
import neqsim.processSimulation.processEquipment.heatExchanger.Heater;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.Fluid;
import neqsim.thermo.system.SystemInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GasTurbine
extends TwoPortEquipment {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Compressor.class);
    public SystemInterface thermoSystem;
    public StreamInterface airStream;
    public Compressor airCompressor;
    public double combustionpressure = 2.5;
    double airGasRatio = 2.8;
    double expanderPower = 0.0;
    double compressorPower = 0.0;
    private double heat = 0.0;
    public double power = 0.0;

    public GasTurbine() {
        this("GasTurbine");
    }

    public GasTurbine(String name) {
        super(name);
        SystemInterface airThermoSystem = new Fluid().create("combustion air");
        airThermoSystem.createDatabase(true);
        this.airStream = new Stream("airStream", airThermoSystem);
        this.airStream.setPressure(1.01325);
        this.airStream.setTemperature(288.15, "K");
        this.airCompressor = new Compressor("airCompressor", this.airStream);
    }

    @Deprecated
    public GasTurbine(StreamInterface inletStream) {
        this();
        this.setInletStream(inletStream);
    }

    public GasTurbine(String name, StreamInterface inletStream) {
        super(name, inletStream);
    }

    @Override
    public CompressorMechanicalDesign getMechanicalDesign() {
        return new CompressorMechanicalDesign(this);
    }

    public double getHeat() {
        return this.heat;
    }

    public double getPower() {
        return this.power;
    }

    @Override
    public void setInletStream(StreamInterface inletStream) {
        this.inStream = inletStream;
        try {
            this.outStream = inletStream.clone();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
    }

    @Override
    public void run(UUID id) {
        this.thermoSystem = this.inStream.getThermoSystem().clone();
        this.airStream.setFlowRate(this.thermoSystem.getFlowRate("mole/sec") * this.airGasRatio, "mole/sec");
        this.airStream.setPressure(1.01325);
        this.airStream.run(id);
        this.airCompressor.setInletStream(this.airStream);
        this.airCompressor.setOutletPressure(this.combustionpressure);
        this.airCompressor.run(id);
        this.compressorPower = this.airCompressor.getPower();
        StreamInterface outStreamAir = this.airCompressor.getOutletStream().clone();
        outStreamAir.getFluid().addFluid(this.thermoSystem);
        outStreamAir.run(id);
        double heatOfCombustion = this.inStream.LCV() * this.inStream.getFlowRate("mole/sec");
        Heater locHeater = new Heater("locHeater", outStreamAir);
        locHeater.setEnergyInput(heatOfCombustion);
        locHeater.run(id);
        double moleMethane = outStreamAir.getFluid().getComponent("methane").getNumberOfmoles();
        locHeater.getOutletStream().getFluid().addComponent("CO2", moleMethane);
        locHeater.getOutletStream().getFluid().addComponent("water", moleMethane * 2.0);
        locHeater.getOutletStream().getFluid().addComponent("methane", -moleMethane);
        locHeater.getOutletStream().getFluid().addComponent("oxygen", -moleMethane * 2.0);
        locHeater.getOutletStream().getFluid().init(3);
        locHeater.displayResult();
        Expander expander = new Expander("expander", locHeater.getOutletStream());
        expander.setOutletPressure(1.01325);
        expander.run(id);
        Cooler cooler1 = new Cooler("cooler1", expander.getOutletStream());
        cooler1.setOutTemperature(288.15);
        cooler1.run(id);
        this.expanderPower = expander.getPower();
        this.power = this.expanderPower - this.compressorPower;
        this.heat = cooler1.getDuty();
        this.setCalculationIdentifier(id);
    }
}

