/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.pipeline;

import java.util.UUID;
import neqsim.fluidMechanics.flowSystem.FlowSystemInterface;
import neqsim.processSimulation.processEquipment.pipeline.Pipeline;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.processSimulation.processSystem.ProcessSystem;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class AdiabaticTwoPhasePipe
extends Pipeline {
    private static final long serialVersionUID = 1000L;
    double inletPressure = 0.0;
    boolean setTemperature = false;
    boolean setPressureOut = false;
    protected double temperatureOut = 270.0;
    protected double pressureOut = 0.0;
    private double pressureOutLimit = 0.0;
    double length = 100.0;
    double flowLimit = 1.0E20;
    String maxflowunit = "kg/hr";
    double insideDiameter = 0.1;
    double velocity = 1.0;
    double pipeWallRoughness = 1.0E-5;
    private double inletElevation = 0.0;
    private double outletElevation = 0.0;
    double dH = 0.0;
    String flowPattern = "unknown";
    String pipeSpecification = "AP02";

    @Deprecated
    public AdiabaticTwoPhasePipe() {
    }

    @Deprecated
    public AdiabaticTwoPhasePipe(StreamInterface inStream) {
        this("AdiabaticTwoPhasePipe", inStream);
    }

    public AdiabaticTwoPhasePipe(String name) {
        super(name);
    }

    public AdiabaticTwoPhasePipe(String name, StreamInterface inStream) {
        super(name, inStream);
    }

    public void setPipeSpecification(double nominalDiameter, String pipeSec) {
        this.pipeSpecification = pipeSec;
        this.insideDiameter = nominalDiameter / 1000.0;
    }

    @Override
    public SystemInterface getThermoSystem() {
        return this.outStream.getThermoSystem();
    }

    public void setOutTemperature(double temperature) {
        this.setTemperature = true;
        this.temperatureOut = temperature;
    }

    public void setOutPressure(double pressure) {
        this.setPressureOut = true;
        this.pressureOut = pressure;
    }

    public double calcWallFrictionFactor(double reynoldsNumber) {
        double relativeRoughnes = this.getPipeWallRoughness() / this.insideDiameter;
        if (Math.abs(reynoldsNumber) < 2000.0) {
            this.flowPattern = "laminar";
            return 64.0 / reynoldsNumber;
        }
        this.flowPattern = "turbulent";
        return Math.pow(1.0 / (-1.8 * Math.log10(6.9 / reynoldsNumber + Math.pow(relativeRoughnes / 3.7, 1.11))), 2.0);
    }

    public double calcPressureOut() {
        double area = 0.7853981633974483 * Math.pow(this.insideDiameter, 2.0);
        this.velocity = this.system.getFlowRate("m3/sec") / area;
        double supGasVel = this.system.getPhase(0).getFlowRate("m3/sec") / area;
        double supoilVel = this.system.getPhase(0).getFlowRate("m3/sec") / area;
        double reynoldsNumber = this.velocity * this.insideDiameter / this.system.getKinematicViscosity("m2/sec");
        double frictionFactor = this.calcWallFrictionFactor(reynoldsNumber);
        double dp = 6253000.0 * Math.pow(this.system.getFlowRate("kg/hr"), 2.0) * frictionFactor / Math.pow(this.insideDiameter * 1000.0, 5.0) / this.system.getDensity("kg/m3") / 100.0 * 1000.0 * this.length;
        double dp_gravity = this.system.getDensity("kg/m3") * 9.80665 * (this.inletElevation - this.outletElevation);
        return (this.inletPressure * 100000.0 - dp) / 100000.0 + dp_gravity / 100000.0;
    }

    public double calcFlow(double pressureOut) {
        double averagePressue = (pressureOut + pressureOut) / 2.0;
        this.system.setPressure(averagePressue);
        ThermodynamicOperations testOps = new ThermodynamicOperations(this.system);
        testOps.TPflash();
        this.system.initProperties();
        double area = 0.7853981633974483 * Math.pow(this.insideDiameter, 2.0);
        double presdrop2 = Math.pow(this.inletPressure * 100.0, 2.0) - Math.pow(pressureOut * 100.0, 2.0);
        double gasGravity = this.system.getMolarMass() / 0.028;
        double oldReynold = 0.0;
        double reynoldsNumber = -1000.0;
        double flow = 0.0;
        do {
            oldReynold = reynoldsNumber;
            this.velocity = this.system.getVolume("m3") / area;
            reynoldsNumber = this.velocity * this.insideDiameter / this.system.getKinematicViscosity();
            double frictionFactor = this.calcWallFrictionFactor(reynoldsNumber) * 4.0;
            double temp = Math.sqrt(presdrop2 * Math.pow(this.insideDiameter * 1000.0, 5.0) / (gasGravity * this.system.getZ() * this.system.getTemperature() * frictionFactor * this.length / 1000.0));
            flow = 0.33119961 / (this.system.getPressure() * 100.0) * temp;
            this.system.setTotalFlowRate(flow / 1000000.0, "MSm^3/day");
            testOps.TPflash();
            this.system.initProperties();
        } while (Math.abs(reynoldsNumber - oldReynold) / reynoldsNumber > 0.001);
        return flow;
    }

    @Override
    public void run(UUID id) {
        this.system = this.inStream.getThermoSystem().clone();
        this.inletPressure = this.system.getPressure();
        if (this.setTemperature) {
            this.system.setTemperature(this.temperatureOut);
        }
        ThermodynamicOperations testOps = new ThermodynamicOperations(this.system);
        testOps.TPflash();
        double oldPressure = 0.0;
        int iter = 0;
        if (!this.setPressureOut) {
            if (this.system.getFlowRate(this.maxflowunit) > this.flowLimit) {
                this.system.setTotalFlowRate(this.flowLimit, this.maxflowunit);
                testOps = new ThermodynamicOperations(this.system);
                testOps.TPflash();
            }
            this.system.initProperties();
            double outP = this.calcPressureOut();
            if (outP < 1.0E-10 || Double.isNaN(outP)) {
                this.system.setPressure(0.001);
                logger.debug("pressure too low in pipe....");
            }
            this.system.setPressure(outP);
            testOps = new ThermodynamicOperations(this.system);
            testOps.TPflash();
            if (this.system.getPressure() < this.pressureOutLimit) {
                iter = 0;
                outP = this.system.getPressure();
                do {
                    ++iter;
                    oldPressure = this.system.getNumberOfMoles();
                    this.system.setTotalNumberOfMoles(this.system.getNumberOfMoles() * outP / this.pressureOutLimit);
                    testOps = new ThermodynamicOperations(this.system);
                    testOps.TPflash();
                    this.system.initProperties();
                    outP = this.calcPressureOut();
                    this.system.setPressure(outP);
                } while (!(outP < 1.0E-10) && !Double.isNaN(outP) && Math.abs(this.system.getNumberOfMoles() - oldPressure) / oldPressure > 0.001 && iter < 3);
            }
            if (this.system.getFlowRate(this.maxflowunit) > this.flowLimit) {
                this.system.setTotalFlowRate(this.flowLimit, this.maxflowunit);
                this.system.init(1);
            }
            this.inStream.getThermoSystem().setTotalFlowRate(this.system.getFlowRate(this.maxflowunit), this.maxflowunit);
            this.inStream.run(id);
        } else {
            this.calcFlow(this.pressureOut);
            this.inStream.getThermoSystem().setTotalFlowRate(this.system.getFlowRate("kg/sec"), "kg/sec");
            this.system.setPressure(this.pressureOut);
            this.system.init(3);
            if (this.system.getFlowRate(this.maxflowunit) > this.flowLimit) {
                this.system.setTotalFlowRate(this.flowLimit, this.maxflowunit);
                this.inStream.getThermoSystem().setTotalFlowRate(this.flowLimit, this.maxflowunit);
                iter = 0;
                do {
                    ++iter;
                    oldPressure = this.system.getPressure();
                    this.system.init(3);
                    this.system.initPhysicalProperties();
                    this.system.setPressure(this.calcPressureOut());
                    testOps = new ThermodynamicOperations(this.system);
                    testOps.TPflash();
                } while (Math.abs(this.system.getPressure() - oldPressure) > 0.01 && iter < 25);
            }
        }
        testOps = new ThermodynamicOperations(this.system);
        testOps.TPflash();
        System.out.println("flow rate " + this.system.getFlowRate(this.maxflowunit));
        this.outStream.setThermoSystem(this.system);
        this.outStream.setCalculationIdentifier(id);
        this.setCalculationIdentifier(id);
    }

    @Override
    public void displayResult() {
        this.system.display();
    }

    public double getSuperficialVelocity() {
        return this.getInletStream().getThermoSystem().getFlowRate("kg/sec") / this.getInletStream().getThermoSystem().getDensity("kg/m3") / (0.7853981633974483 * Math.pow(this.insideDiameter, 2.0));
    }

    @Override
    public FlowSystemInterface getPipe() {
        return null;
    }

    @Override
    public void setInitialFlowPattern(String flowPattern) {
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public double getDiameter() {
        return this.insideDiameter;
    }

    public void setDiameter(double diameter) {
        this.insideDiameter = diameter;
    }

    public double getPipeWallRoughness() {
        return this.pipeWallRoughness;
    }

    public void setPipeWallRoughness(double pipeWallRoughness) {
        this.pipeWallRoughness = pipeWallRoughness;
    }

    public double getInletElevation() {
        return this.inletElevation;
    }

    public void setInletElevation(double inletElevation) {
        this.inletElevation = inletElevation;
    }

    public double getOutletElevation() {
        return this.outletElevation;
    }

    public void setOutletElevation(double outletElevation) {
        this.outletElevation = outletElevation;
    }

    public static void main(String[] name) {
        SystemSrkEos testSystem = new SystemSrkEos(278.15, 200.0);
        testSystem.addComponent("methane", 75.0, "MSm^3/day");
        testSystem.addComponent("n-heptane", 1.0E-7, "MSm^3/day");
        testSystem.createDatabase(true);
        testSystem.setMixingRule(2);
        testSystem.init(0);
        Stream stream_1 = new Stream("Stream1", testSystem);
        AdiabaticTwoPhasePipe pipe = new AdiabaticTwoPhasePipe(stream_1);
        pipe.setLength(400000.0);
        pipe.setDiameter(1.017112);
        pipe.setPipeWallRoughness(5.0E-6);
        AdiabaticTwoPhasePipe pipe2 = new AdiabaticTwoPhasePipe(pipe.getOutletStream());
        pipe2.setLength(100.0);
        pipe2.setDiameter(0.3017112);
        pipe2.setPipeWallRoughness(5.0E-6);
        ProcessSystem operations = new ProcessSystem();
        operations.add(stream_1);
        operations.add(pipe);
        operations.add(pipe2);
        operations.run();
        System.out.println("flow " + pipe2.getOutletStream().getFluid().getFlowRate("MSm3/day"));
        System.out.println("out pressure " + pipe.getOutletStream().getPressure("bara"));
        System.out.println("velocity " + pipe.getSuperficialVelocity());
        System.out.println("out pressure " + pipe2.getOutletStream().getPressure("bara"));
        System.out.println("velocity " + pipe2.getSuperficialVelocity());
    }

    public double getPressureOutLimit() {
        return this.pressureOutLimit;
    }

    public void setPressureOutLimit(double pressureOutLimit) {
        this.pressureOutLimit = pressureOutLimit;
    }

    public void setFlowLimit(double flowLimit, String unit) {
        this.flowLimit = flowLimit;
        this.maxflowunit = unit;
    }
}

