/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.compressor;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.fitting.PolynomialCurveFitter;
import org.apache.commons.math3.fitting.WeightedObservedPoints;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StoneWallCurve
implements Serializable {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(StoneWallCurve.class);
    double[] flow;
    double[] head;
    double[] chartConditions = null;
    private boolean isActive = false;
    final WeightedObservedPoints flowFitter = new WeightedObservedPoints();
    PolynomialFunction flowFitterFunc = null;

    public StoneWallCurve() {
    }

    public StoneWallCurve(double[] flow, double[] head) {
        this.flow = flow;
        this.head = head;
    }

    public void setCurve(double[] chartConditions, double[] flow, double[] head) {
        this.chartConditions = chartConditions;
        for (int i = 0; i < flow.length; ++i) {
            this.flowFitter.add(head[i], flow[i]);
        }
        PolynomialCurveFitter fitter = PolynomialCurveFitter.create(2);
        this.flowFitterFunc = new PolynomialFunction(fitter.fit(this.flowFitter.toList()));
        this.isActive = true;
    }

    public double getStoneWallFlow(double head) {
        return this.flowFitterFunc.value(head);
    }

    public boolean isStoneWall(double head, double flow) {
        return this.getStoneWallFlow(head) < flow;
    }

    boolean isActive() {
        return this.isActive;
    }

    void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.chartConditions);
        result = 31 * result + Arrays.hashCode(this.flow);
        result = 31 * result + Arrays.hashCode(this.head);
        result = 31 * result + Objects.hash(this.flowFitterFunc, this.isActive);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StoneWallCurve other = (StoneWallCurve)obj;
        return Arrays.equals(this.chartConditions, other.chartConditions) && Arrays.equals(this.flow, other.flow) && Objects.equals(this.flowFitterFunc, other.flowFitterFunc) && Arrays.equals(this.head, other.head) && this.isActive == other.isActive;
    }
}

