/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.measurementDevice;

import neqsim.processSimulation.measurementDevice.MeasurementDeviceBaseClass;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HydrateEquilibriumTemperatureAnalyser
extends MeasurementDeviceBaseClass {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(HydrateEquilibriumTemperatureAnalyser.class);
    protected StreamInterface stream = null;
    private double referencePressure = 0.0;

    public HydrateEquilibriumTemperatureAnalyser() {
    }

    public HydrateEquilibriumTemperatureAnalyser(StreamInterface stream) {
        this.stream = stream;
        this.unit = "K";
        this.setConditionAnalysisMaxDeviation(1.0);
    }

    @Override
    public void displayResult() {
    }

    @Override
    public double getMeasuredValue() {
        return this.getMeasuredValue(this.unit);
    }

    @Override
    public double getMeasuredValue(String unit) {
        SystemInterface tempFluid = this.stream.getThermoSystem().clone();
        if (!tempFluid.getHydrateCheck()) {
            tempFluid.setHydrateCheck(true);
        }
        tempFluid.setTemperature(10.0, "C");
        if (this.referencePressure > 1.0E-10) {
            tempFluid.setPressure(this.referencePressure);
        }
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(tempFluid);
        try {
            thermoOps.hydrateFormationTemperature();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        return tempFluid.getTemperature(unit);
    }

    public double getReferencePressure() {
        return this.referencePressure;
    }

    public void setReferencePressure(double referencePressure) {
        this.referencePressure = referencePressure;
    }
}

