/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.util.parameterFitting.binaryComponentParameterFitting.diffusivity;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.physicalProperties.util.parameterFitting.binaryComponentParameterFitting.diffusivity.DiffusivityFunction;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestDiffusivity {
    static Logger logger = LogManager.getLogger(TestDiffusivity.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        try (ResultSet dataSet = database.getResultSet("SELECT * FROM binaryliquiddiffusioncoefficientdata WHERE ComponentSolute='CO2' AND ComponentSolvent='water'");){
            logger.info("adding....");
            while (dataSet.next()) {
                DiffusivityFunction function = new DiffusivityFunction();
                double[] guess = new double[]{0.001};
                function.setInitialGuess(guess);
                SystemSrkEos testSystem = new SystemSrkEos(280.0, 0.001);
                testSystem.addComponent(dataSet.getString("ComponentSolute"), 1.0E-10);
                testSystem.addComponent(dataSet.getString("ComponentSolvent"), 1.0);
                testSystem.createDatabase(true);
                testSystem.setPressure(Double.parseDouble(dataSet.getString("Pressure")));
                testSystem.setTemperature(Double.parseDouble(dataSet.getString("Temperature")));
                testSystem.init(0);
                testSystem.setPhysicalPropertyModel(4);
                testSystem.initPhysicalProperties();
                double[] sample1 = new double[]{testSystem.getTemperature()};
                double[] standardDeviation1 = new double[]{0.1};
                SampleValue sample = new SampleValue(Double.parseDouble(dataSet.getString("DiffusionCoefficient")), 0.01, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
    }
}

