/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.interfaceProperties.surfaceTension;

import neqsim.physicalProperties.interfaceProperties.surfaceTension.GTSurfaceTensionUtils;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import no.uib.cipr.matrix.BandMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GTSurfaceTensionFullGT {
    static Logger logger = LogManager.getLogger(GTSurfaceTensionFullGT.class);
    private int ncomp;
    private SystemInterface sys;
    private double[] ci;
    private double[] mueq;
    private double[] rho_ph1;
    private double[] rho_ph2;
    private double t;
    private double[] p0;
    private static final double Pa = 1.0E-5;
    private static final double m3 = 1.0E-5;
    public double normtol = 1.0E-11;
    public double reltol = 1.0E-6;
    public double abstol = 1.0E-6;
    public int maxit = 40;
    private static final boolean NDEBUG = true;
    private static final boolean DEBUGPLOT = false;

    public GTSurfaceTensionFullGT(SystemInterface flashedSystem, int phase1, int phase2) {
        int i = 0;
        this.sys = flashedSystem.clone();
        this.ncomp = this.sys.getPhase(0).getNumberOfComponents();
        this.t = this.sys.getPhase(0).getTemperature();
        this.rho_ph1 = new double[this.ncomp];
        this.rho_ph2 = new double[this.ncomp];
        this.p0 = new double[1];
        this.ci = new double[this.ncomp];
        this.mueq = new double[this.ncomp];
        boolean hasAddedComp = false;
        for (i = 0; i < this.ncomp; ++i) {
            if (!(this.sys.getPhase(phase1).getComponent(i).getx() < Double.MIN_VALUE)) continue;
            this.sys.addComponent(i, this.sys.getTotalNumberOfMoles() / 1.0E10);
            hasAddedComp = true;
        }
        if (hasAddedComp) {
            ThermodynamicOperations ops = new ThermodynamicOperations(this.sys);
            ops.TPflash();
        }
        for (i = 0; i < this.ncomp; ++i) {
            this.ci[i] = this.sys.getPhase(0).getComponent(i).getSurfaceTenisionInfluenceParameter(this.t);
            this.rho_ph1[i] = this.sys.getPhase(phase1).getComponent(i).getx() / this.sys.getPhase(phase1).getMolarVolume() / 1.0E-5;
            this.rho_ph2[i] = this.sys.getPhase(phase2).getComponent(i).getx() / this.sys.getPhase(phase2).getMolarVolume() / 1.0E-5;
        }
        this.sys.setBeta(1.0);
        this.sys.init(0);
        this.sys.setUseTVasIndependentVariables(true);
        this.sys.setNumberOfPhases(1);
        this.sys.getPhase(0).setTotalVolume(1.0);
        this.sys.useVolumeCorrection(false);
        this.sys.setEmptyFluid();
        double[] nv = new double[this.ncomp];
        for (i = 0; i < this.ncomp; ++i) {
            nv[i] = this.rho_ph1[i] * 1.0E-5;
        }
        this.sys.setTotalFlowRate(1.0, "mol/sec");
        this.sys.setMolarComposition(nv);
        this.sys.init_x_y();
        this.sys.setBeta(1.0);
        this.sys.init(3);
    }

    public double runcase() {
        int j;
        int i;
        double[][] cij = new double[this.ncomp][this.ncomp];
        double[] delta_mu = new double[this.ncomp];
        double[][] dmu_drho = new double[this.ncomp][this.ncomp];
        double sigma = 0.0;
        int Nlevel = 3;
        int Ngrid = (1 << Nlevel) + 1;
        double[][] rhomat = new double[Ngrid][this.ncomp];
        int Nrefinements = 7;
        double StopTolerance = 0.01;
        double sigma_old = 9.9E99;
        double nm = 1.0;
        double L = 3.0 * nm;
        int N_Newton = 20;
        double maxRelChange = 0.5;
        boolean highOrder = true;
        boolean directMethod = true;
        GTSurfaceTensionFullGT.initmu(this.sys, this.ncomp, this.t, this.rho_ph1, this.rho_ph2, this.mueq, this.p0, this.reltol);
        int N2 = 1 << Nlevel - 1;
        for (i = 0; i < N2; ++i) {
            rhomat[i] = (double[])this.rho_ph1.clone();
        }
        int N1 = N2;
        N2 = 1 + (1 << Nlevel);
        for (i = N1; i < N2; ++i) {
            rhomat[i] = (double[])this.rho_ph2.clone();
        }
        for (i = 0; i < this.ncomp; ++i) {
            this.ci[i] = this.sys.getPhase(0).getComponent(i).getSurfaceTenisionInfluenceParameter(this.t);
        }
        for (i = 0; i < this.ncomp; ++i) {
            for (j = i; j < this.ncomp; ++j) {
                cij[i][j] = 1.0E18 * Math.sqrt(this.ci[i] * this.ci[j]);
                cij[j][i] = cij[i][j];
            }
        }
        GTSurfaceTensionFullGT.delta_mu(this.sys, this.ncomp, this.t, this.mueq, this.rho_ph1, delta_mu, dmu_drho);
        double[] xgrid = GTSurfaceTensionFullGT.linspace(-L, L, Ngrid);
        for (i = 0; i < Nrefinements; ++i) {
            sigma = GTSurfaceTensionFullGT.Newton(cij, L, N_Newton, maxRelChange, highOrder, directMethod, rhomat, this.sys, this.ncomp, this.t, this.mueq);
            double[][] drhodz = new double[rhomat.length - 1][this.ncomp];
            sigma = GTSurfaceTensionFullGT.sigmaCalc(xgrid[1] - xgrid[0], rhomat, cij, false, drhodz, this.ncomp);
            double std = this.calc_std_integral(xgrid, cij, drhodz);
            if (i > 0 && Math.abs(sigma - sigma_old) < StopTolerance * sigma) break;
            sigma_old = sigma;
            double H = 2.0 * L / ((double)Ngrid - 1.0);
            int Nhalf = (int)Math.round(Math.ceil(6.0 * std / H));
            int Nideal = 2 * Nhalf + 1;
            double Lnew = (double)Nhalf * H;
            int NgridNew = 2 * Nideal - 1;
            double[] xgridNew = GTSurfaceTensionFullGT.linspace(-Lnew, Lnew, NgridNew);
            int kk = 0;
            double[][] rhotmp = new double[NgridNew][this.ncomp];
            for (j = 0; j < rhotmp.length; ++j) {
                if (xgridNew[j] < xgrid[0]) {
                    rhotmp[j] = (double[])this.rho_ph1.clone();
                    continue;
                }
                if (xgridNew[j] > xgrid[xgrid.length - 1]) {
                    rhotmp[j] = (double[])this.rho_ph2.clone();
                    continue;
                }
                while (xgridNew[j] > xgrid[kk + 1]) {
                    ++kk;
                }
                double alpha = (xgrid[kk + 1] - xgridNew[j]) / (xgrid[kk + 1] - xgrid[kk]);
                for (int k = 0; k < this.ncomp; ++k) {
                    rhotmp[j][k] = alpha * rhomat[kk][k] + (1.0 - alpha) * rhomat[kk + 1][k];
                }
            }
            rhotmp[0] = (double[])this.rho_ph1.clone();
            rhotmp[rhotmp.length - 1] = (double[])this.rho_ph2.clone();
            L = Lnew;
            rhomat = rhotmp;
            Ngrid = NgridNew;
            xgrid = xgridNew;
        }
        return sigma;
    }

    public static double Newton(double[][] cij, double L, int N_Newton, double allowedRelChange, boolean highOrder, boolean directMethod, double[][] rhomat, SystemInterface sys, int ncomp, double t, double[] mueq) {
        int k;
        int j;
        int i;
        int Ngrid = rhomat.length;
        double H = 2.0 * L / (double)(Ngrid - 1);
        double[][][] Jac = new double[Ngrid][ncomp][ncomp];
        double[][] dmu = new double[Ngrid][ncomp];
        double[][] rres = new double[Ngrid][ncomp];
        double[][] rrho_prev = new double[Ngrid][ncomp];
        double[][] drhodz = new double[Ngrid - 1][ncomp];
        double sigma = 0.0;
        double[] xgrid = GTSurfaceTensionFullGT.linspace(-L, L, Ngrid);
        for (i = 0; i < Ngrid; ++i) {
            GTSurfaceTensionFullGT.delta_mu(sys, ncomp, t, mueq, rhomat[i], dmu[i], Jac[i]);
            for (j = 0; j < ncomp; ++j) {
                rres[i][j] = dmu[i][j];
                for (k = 0; k < ncomp; ++k) {
                    double[] dArray = rres[i];
                    int n = j;
                    dArray[n] = dArray[n] - Jac[i][j][k] * rhomat[i][k];
                }
            }
        }
        if (highOrder) {
            for (i = 1; i < Ngrid - 1; ++i) {
                for (j = 0; j < ncomp; ++j) {
                    double[] dArray = rres[i];
                    int n = j;
                    dArray[n] = dArray[n] + (dmu[i - 1][j] - 2.0 * dmu[i][j] + dmu[i + 1][j]) / 12.0;
                }
            }
        }
        for (int NewtonStep = 0; NewtonStep < N_Newton; ++NewtonStep) {
            for (i = 0; i < Ngrid; ++i) {
                for (j = 0; j < ncomp; ++j) {
                    rrho_prev[i][j] = rhomat[i][j];
                }
            }
            GTSurfaceTensionFullGT.directsolve(rres, Jac, cij, H, Ngrid, rhomat, ncomp);
            double maxrelchange = 0.0;
            for (i = 1; i < Ngrid - 1; ++i) {
                for (j = 0; j < ncomp; ++j) {
                    if (!(Math.abs(rhomat[i][j] - rrho_prev[i][j]) > maxrelchange * Math.abs(rrho_prev[i][j]))) continue;
                    maxrelchange = Math.abs(rhomat[i][j] - rrho_prev[i][j]) / Math.abs(rrho_prev[i][j]);
                }
            }
            double urel_Newton = Math.min(allowedRelChange / maxrelchange, 1.0);
            for (i = 1; i < Ngrid - 1; ++i) {
                for (j = 0; j < ncomp; ++j) {
                    rhomat[i][j] = urel_Newton * rhomat[i][j] + (1.0 - urel_Newton) * rrho_prev[i][j];
                }
            }
            if (urel_Newton * maxrelchange < 1.0E-5) break;
            sigma = GTSurfaceTensionFullGT.sigmaCalc(H, rhomat, cij, false, drhodz, ncomp);
            double sum_ztmp = 0.0;
            double sum_tmp = 0.0;
            for (i = 0; i < drhodz.length; ++i) {
                double tmp = 0.0;
                for (j = 0; j < ncomp; ++j) {
                    for (k = 0; k < ncomp; ++k) {
                        tmp += drhodz[i][j] * cij[j][k] * drhodz[i][k];
                    }
                }
                sum_ztmp += 0.5 * (xgrid[i + 1] + xgrid[i]) * tmp;
                sum_tmp += tmp;
            }
            double cg = sum_ztmp / sum_tmp;
            int icorr = (int)Math.round(cg / H);
            if (icorr > 0) {
                for (i = 1; i < Ngrid - icorr; ++i) {
                    rhomat[i] = rhomat[i + icorr];
                }
                for (i = Ngrid - icorr; i < Ngrid - 1; ++i) {
                    rhomat[i] = (double[])rhomat[Ngrid - 1].clone();
                }
            } else if (icorr < 0) {
                icorr = -icorr;
                for (i = Ngrid - 2; i >= icorr; --i) {
                    rhomat[i] = rhomat[i - icorr];
                }
                for (i = 1; i < icorr; ++i) {
                    rhomat[i] = (double[])rhomat[0].clone();
                }
            }
            for (i = 1; i < Ngrid - 1; ++i) {
                GTSurfaceTensionFullGT.delta_mu(sys, ncomp, t, mueq, rhomat[i], dmu[i], Jac[i]);
                for (j = 0; j < ncomp; ++j) {
                    rres[i][j] = dmu[i][j];
                    for (k = 0; k < ncomp; ++k) {
                        double[] dArray = rres[i];
                        int n = j;
                        dArray[n] = dArray[n] - Jac[i][j][k] * rhomat[i][k];
                    }
                }
            }
            if (!highOrder) continue;
            for (i = 1; i < Ngrid - 1; ++i) {
                for (j = 0; j < ncomp; ++j) {
                    double[] dArray = rres[i];
                    int n = j;
                    dArray[n] = dArray[n] + (dmu[i - 1][j] - 2.0 * dmu[i][j] + dmu[i + 1][j]) / 12.0;
                }
            }
        }
        return sigma;
    }

    public static void directsolve(double[][] rres, double[][][] JJ, double[][] C, double H, int Ngrid, double[][] rhomat, int ncomp) {
        int skip;
        int k;
        double bbtmp;
        int j;
        int i;
        double H2 = H * H;
        int Neq = (Ngrid - 2) * ncomp;
        int kl = 2 * ncomp + 1;
        int ku = 2 * ncomp + 1;
        BandMatrix Jac = new BandMatrix(Neq, kl, ku);
        DenseMatrix bb = new DenseMatrix(Neq, 1);
        DenseMatrix drho = new DenseMatrix(Neq, 1);
        int iglob = 0;
        for (i = 1; i < Ngrid - 1; ++i) {
            for (j = 0; j < ncomp; ++j) {
                bbtmp = rres[i][j];
                for (k = 0; k < ncomp; ++k) {
                    bbtmp += JJ[i][j][k] * rhomat[i][k] - C[j][k] * (rhomat[i - 1][k] - 2.0 * rhomat[i][k] + rhomat[i + 1][k]) / H2;
                }
                bb.set(iglob++, 0, -bbtmp);
            }
        }
        i = 1;
        for (j = 0; j < ncomp; ++j) {
            for (k = 0; k < ncomp; ++k) {
                Jac.set(j, k, JJ[i][j][k] + 2.0 / H2 * C[j][k]);
                Jac.set(j, k + ncomp, -1.0 / H2 * C[j][k]);
            }
        }
        for (i = 2; i < Ngrid - 2; ++i) {
            skip = ncomp * (i - 1);
            for (j = 0; j < ncomp; ++j) {
                for (k = 0; k < ncomp; ++k) {
                    Jac.set(j + skip, k + skip - ncomp, -1.0 / H2 * C[j][k]);
                    Jac.set(j + skip, k + skip, JJ[i][j][k] + 2.0 / H2 * C[j][k]);
                    Jac.set(j + skip, k + skip + ncomp, -1.0 / H2 * C[j][k]);
                }
            }
        }
        i = Ngrid - 2;
        skip = ncomp * (i - 1);
        for (j = 0; j < ncomp; ++j) {
            for (k = 0; k < ncomp; ++k) {
                Jac.set(j + skip, k + skip - ncomp, -1.0 / H2 * C[j][k]);
                Jac.set(j + skip, k + skip, JJ[i][j][k] + 2.0 / H2 * C[j][k]);
            }
        }
        Jac.solve(bb, drho);
        iglob = 0;
        for (i = 1; i < Ngrid - 1; ++i) {
            j = 0;
            while (j < ncomp) {
                bbtmp = drho.get(iglob++, 0);
                double[] dArray = rhomat[i];
                int n = j++;
                dArray[n] = dArray[n] + bbtmp;
            }
        }
    }

    public static double sigmaCalc(double h, double[][] rrho, double[][] C, boolean highOrder, double[][] drhodz, int ncomp) {
        int j;
        int i;
        for (i = 0; i < rrho.length - 1; ++i) {
            for (j = 0; j < ncomp; ++j) {
                drhodz[i][j] = (rrho[i + 1][j] - rrho[i][j]) / h;
            }
        }
        double sigma = 0.0;
        for (j = 0; j < ncomp; ++j) {
            for (int k = 0; k < ncomp; ++k) {
                double drho2 = 0.0;
                for (i = 0; i < rrho.length - 1; ++i) {
                    drho2 += drhodz[i][j] * drhodz[i][k];
                }
                sigma += C[j][k] * drho2;
            }
        }
        return sigma *= h * 1.0E-9;
    }

    public double calc_std_integral(double[] z, double[][] C, double[][] drhodz) {
        double h1 = z[1] - z[0];
        int Ngrid = drhodz.length + 1;
        double zdum = 0.0;
        double z2dum = 0.0;
        double sumdum = 0.0;
        for (int j = 0; j < Ngrid - 1; ++j) {
            double dum = 0.0;
            for (int m = 0; m < this.ncomp; ++m) {
                for (int n = 0; n < this.ncomp; ++n) {
                    dum = drhodz[j][m] * C[m][n] * drhodz[j][n];
                }
            }
            sumdum += dum * h1;
            zdum += dum * (z[j + 1] * z[j + 1] - z[j] * z[j]) / 2.0;
            z2dum += dum * (z[j + 1] * z[j + 1] * z[j + 1] - z[j] * z[j] * z[j]) / 3.0;
        }
        double mean = zdum / sumdum;
        return Math.sqrt(z2dum / sumdum - mean * mean);
    }

    public static void delta_mu(SystemInterface sys, int ncomp, double t, double[] mueq, double[] rho, double[] delta_mu, double[][] dmu_drho) {
        double[] pdummy = new double[ncomp];
        double[] mu = new double[ncomp];
        GTSurfaceTensionUtils.mufun(sys, ncomp, t, rho, mu, dmu_drho, pdummy);
        for (int i = 0; i < ncomp; ++i) {
            delta_mu[i] = mu[i] - mueq[i];
        }
    }

    public static double[] linspace(double a, double b, int N) {
        double[] x = new double[N];
        double dx = (b - a) / (double)(N - 1);
        for (int i = 0; i < N; ++i) {
            x[i] = a + (double)i * dx;
        }
        return x;
    }

    public static void debugPlot(double[] x, double[][] y) {
        int N = y.length;
        int M = y[0].length;
        double[] yy = new double[N];
        for (int j = 0; j < M; ++j) {
            for (int i = 0; i < N; ++i) {
                yy[i] = Math.log10(y[i][j]);
            }
            if (j != 0) continue;
        }
    }

    public static void initmu(SystemInterface sys, int ncomp, double t, double[] rho_ph1, double[] rho_ph2, double[] mueq, double[] p0, double reltol) {
        double maxerr = 0.0;
        double[][] dmu_drho1 = new double[ncomp][ncomp];
        double[][] dmu_drho2 = new double[ncomp][ncomp];
        double[] mueq2 = new double[ncomp];
        GTSurfaceTensionUtils.mufun(sys, ncomp, t, rho_ph1, mueq, dmu_drho1, p0);
        GTSurfaceTensionUtils.mufun(sys, ncomp, t, rho_ph2, mueq2, dmu_drho2, p0);
        for (int i = 0; i < ncomp; ++i) {
            maxerr = Math.max(maxerr, Math.abs(mueq[i] / mueq2[i] - 1.0));
        }
        if (maxerr > reltol) {
            logger.error("Flash is not properly solved.  Maximum relative error in chemical potential:  " + maxerr + " > " + reltol);
            throw new RuntimeException("Flash not solved!");
        }
    }
}

