/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.geometryDefinitions.internalGeometry.wall;

import java.util.ArrayList;
import neqsim.fluidMechanics.geometryDefinitions.internalGeometry.wall.MaterialLayer;
import neqsim.fluidMechanics.geometryDefinitions.internalGeometry.wall.WallInterface;

public class Wall
implements WallInterface {
    private ArrayList<MaterialLayer> wallMaterialLayers = new ArrayList();
    private double heatTransferCoefficient = 10.0;

    public double getHeatTransferCoefficient() {
        return this.heatTransferCoefficient;
    }

    public void setHeatTransferCoefficient(double heatTransferCOefficient) {
        this.heatTransferCoefficient = heatTransferCOefficient;
    }

    @Override
    public void addMaterialLayer(MaterialLayer layer) {
        this.wallMaterialLayers.add(layer);
        this.heatTransferCoefficient = this.calcHeatTransferCoefficient();
    }

    @Override
    public MaterialLayer getWallMaterialLayer(int i) {
        return this.wallMaterialLayers.get(i);
    }

    public double calcHeatTransferCoefficient() {
        double invheatTransCoef = 0.0;
        for (MaterialLayer mat : this.wallMaterialLayers) {
            invheatTransCoef += 1.0 / (mat.getConductivity() / mat.getThickness());
        }
        return 1.0 / invheatTransCoef;
    }
}

