/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.flowSolver.twoPhaseFlowSolver.stirredCellSolver;

import Jama.Matrix;
import neqsim.fluidMechanics.flowSolver.twoPhaseFlowSolver.twoPhasePipeFlowSolver.TwoPhaseFixedStaggeredGridSolver;
import neqsim.fluidMechanics.flowSolver.twoPhaseFlowSolver.twoPhasePipeFlowSolver.TwoPhasePipeFlowSolver;
import neqsim.fluidMechanics.flowSystem.FlowSystemInterface;
import neqsim.thermo.ThermodynamicConstantsInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class StirredCellSolver
extends TwoPhasePipeFlowSolver
implements ThermodynamicConstantsInterface {
    private static final long serialVersionUID = 1000L;
    Matrix diffMatrix;
    double[][] dn;
    int iter = 0;
    Matrix[] diff4Matrix;
    double[][][] xNew;
    protected double[][] oldMass;
    protected double[][] oldComp;
    protected double[][] oldDensity;
    protected double[][] oldVelocity;
    protected double[][][] oldComposition;
    protected double[][] oldInternalEnergy;
    protected double[][] oldImpuls;
    protected double[][] oldEnergy;

    public StirredCellSolver() {
    }

    public StirredCellSolver(FlowSystemInterface pipe, double length, int nodes) {
        super(pipe, length, nodes);
    }

    public StirredCellSolver(FlowSystemInterface pipe, double length, int nodes, boolean dynamic) {
        super(pipe, length, nodes);
        this.dynamic = dynamic;
        this.oldMass = new double[2][nodes];
        this.oldComp = new double[2][nodes];
        this.oldImpuls = new double[2][nodes];
        this.diff4Matrix = new Matrix[pipe.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents()];
        this.oldEnergy = new double[2][nodes];
        this.oldVelocity = new double[2][nodes];
        this.oldDensity = new double[2][nodes];
        this.oldInternalEnergy = new double[2][nodes];
        this.oldComposition = new double[2][pipe.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents()][nodes];
        this.numberOfVelocityNodes = nodes;
    }

    @Override
    public TwoPhaseFixedStaggeredGridSolver clone() {
        TwoPhaseFixedStaggeredGridSolver clonedSystem = null;
        try {
            clonedSystem = (TwoPhaseFixedStaggeredGridSolver)super.clone();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return clonedSystem;
    }

    public void initProfiles() {
        SystemInterface tempSyst = this.pipe.getNode(0).getBulkSystem().clone();
        ThermodynamicOperations testOps = new ThermodynamicOperations(tempSyst);
        testOps.TPflash();
        testOps.displayResult();
        double[][][] molDiff = new double[this.numberOfNodes][2][this.pipe.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents()];
        this.pipe.getNode(0).init();
        this.pipe.getNode(0).calcFluxes();
        for (int i = 1; i < this.numberOfNodes - 1; ++i) {
            this.pipe.getNode(i).init();
            this.pipe.getNode(i).calcFluxes();
            for (int componentNumber = 0; componentNumber < this.pipe.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents(); ++componentNumber) {
                double liquidMolarRate = this.pipe.getNode(i).getFluidBoundary().getInterphaseMolarFlux(componentNumber) * this.pipe.getNode(i).getInterphaseContactLength(0) * this.pipe.getNode(i).getGeometry().getNodeLength();
                double gasMolarRate = -this.pipe.getNode(i).getFluidBoundary().getInterphaseMolarFlux(componentNumber) * this.pipe.getNode(i).getInterphaseContactLength(0) * this.pipe.getNode(i).getGeometry().getNodeLength();
                double liquidHeatRate = this.pipe.getNode(i).getFluidBoundary().getInterphaseHeatFlux(1) * this.pipe.getNode(i).getInterphaseContactLength(0) * this.pipe.getNode(i).getGeometry().getNodeLength();
                double gasHeatRate = -this.pipe.getNode(i).getFluidBoundary().getInterphaseHeatFlux(0) * this.pipe.getNode(i).getInterphaseContactLength(0) * this.pipe.getNode(i).getGeometry().getNodeLength();
                double liquid_dT = -liquidHeatRate / this.pipe.getNode(i).getBulkSystem().getPhase(1).getCp();
                double gas_dT = gasHeatRate / this.pipe.getNode(i).getBulkSystem().getPhase(0).getCp();
                molDiff[i][0][componentNumber] = molDiff[i - 1][0][componentNumber] + gasMolarRate;
                molDiff[i][1][componentNumber] = molDiff[i - 1][1][componentNumber] + liquidMolarRate;
                this.pipe.getNode(i + 1).getBulkSystem().getPhases()[0].addMoles(componentNumber, molDiff[i][0][componentNumber]);
                this.pipe.getNode(i + 1).getBulkSystem().getPhases()[1].addMoles(componentNumber, molDiff[i][1][componentNumber]);
                this.pipe.getNode(i + 1).getBulkSystem().getPhase(0).setTemperature(this.pipe.getNode(i).getBulkSystem().getPhase(0).getTemperature() + gas_dT);
                this.pipe.getNode(i + 1).getBulkSystem().getPhase(1).setTemperature(this.pipe.getNode(i).getBulkSystem().getPhase(1).getTemperature() + liquid_dT);
            }
            this.pipe.getNode(i + 1).getBulkSystem().initBeta();
            this.pipe.getNode(i + 1).getBulkSystem().init_x_y();
            this.pipe.getNode(i + 1).initFlowCalc();
            System.out.println("x " + this.pipe.getNode(i - 1).getBulkSystem().getPhases()[1].getComponents()[0].getx());
            System.out.println("x " + this.pipe.getNode(i - 1).getBulkSystem().getPhases()[1].getComponents()[1].getx());
            System.out.println("y " + this.pipe.getNode(i - 1).getBulkSystem().getPhases()[0].getComponents()[0].getx());
            System.out.println("y " + this.pipe.getNode(i - 1).getBulkSystem().getPhases()[0].getComponents()[1].getx());
        }
        this.pipe.getNode(this.numberOfNodes - 1).init();
        this.pipe.getNode(this.numberOfNodes - 1).calcFluxes();
        this.initNodes();
        System.out.println("finisched initializing....");
    }

    public void initMatrix() {
        for (int i = 0; i < this.numberOfNodes; ++i) {
            this.pipe.getNode(i).init();
            double enthalpy0 = this.pipe.getNode(i).getBulkSystem().getPhases()[0].getEnthalpy() / this.pipe.getNode(i).getBulkSystem().getPhases()[0].getNumberOfMolesInPhase() / this.pipe.getNode(i).getBulkSystem().getPhases()[0].getMolarMass();
            double enthalpy1 = this.pipe.getNode(i).getBulkSystem().getPhases()[1].getEnthalpy() / this.pipe.getNode(i).getBulkSystem().getPhases()[1].getNumberOfMolesInPhase() / this.pipe.getNode(i).getBulkSystem().getPhases()[1].getMolarMass();
            this.solMatrix[0].set(i, 0, this.pipe.getNode(i).getVelocityIn(0).doubleValue());
            this.solMatrix[1].set(i, 0, this.pipe.getNode(i).getVelocityIn(1).doubleValue());
            this.sol3Matrix[0].set(i, 0, enthalpy0);
            this.sol3Matrix[1].set(i, 0, enthalpy1);
            this.solPhaseConsMatrix[0].set(i, 0, this.pipe.getNode(i).getBulkSystem().getPhases()[0].getPhysicalProperties().getDensity());
            this.solPhaseConsMatrix[1].set(i, 0, this.pipe.getNode(i).getPhaseFraction(1));
            for (int phase = 0; phase < 2; ++phase) {
                for (int j = 0; j < this.pipe.getNode(i).getBulkSystem().getPhases()[0].getNumberOfComponents(); ++j) {
                    this.solMolFracMatrix[phase][j].set(i, 0, this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getComponents()[j].getx() * this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getComponents()[j].getMolarMass() / this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getMolarMass());
                }
            }
        }
    }

    public void initPressure(int phase) {
        for (int i = 0; i < this.numberOfNodes; ++i) {
            this.pipe.getNode(i).init();
            this.pipe.getNode(i).getBulkSystem().setPressure(0.8 * this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getdPdrho() * this.diffMatrix.get(i, 0) * 1.0E-5 + this.pipe.getNode(i).getBulkSystem().getPressure());
            this.pipe.getNode(i).init();
        }
    }

    public void initVelocity(int phase) {
        int i;
        for (i = 0; i < this.numberOfNodes; ++i) {
            this.pipe.getNode(i).setVelocityIn(phase, this.pipe.getNode(i).getVelocityIn(phase).doubleValue() + 0.8 * (this.solMatrix[phase].get(i, 0) - this.pipe.getNode(i).getVelocityIn(phase).doubleValue()));
        }
        for (i = 0; i < this.numberOfNodes; ++i) {
            double meanVelocity = this.pipe.getNode(i).getVelocityIn(phase).doubleValue();
            this.pipe.getNode(i).setVelocity(phase, meanVelocity);
            this.pipe.getNode(i).init();
        }
    }

    public void initTemperature(int phase) {
        for (int i = 0; i < this.numberOfNodes; ++i) {
            this.pipe.getNode(i).init();
            this.pipe.getNode(i).getBulkSystem().setTemperature(this.pipe.getNode(i).getBulkSystem().getTemperature(phase) + 0.8 * this.diffMatrix.get(i, 0) / (this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getCp() / this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getNumberOfMolesInPhase() / this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getMolarMass()), phase);
            this.pipe.getNode(i).init();
        }
    }

    public void initPhaseFraction(int phase) {
        for (int i = 0; i < this.numberOfNodes; ++i) {
            this.pipe.getNode(i).setPhaseFraction(phase, this.pipe.getNode(i).getPhaseFraction(phase) + 0.8 * this.diffMatrix.get(i, 0));
            this.pipe.getNode(i).setPhaseFraction(0, 1.0 - this.pipe.getNode(i).getPhaseFraction(phase));
            this.pipe.getNode(i).init();
        }
    }

    public void initComposition(int phase, int comp) {
        for (int j = 0; j < this.numberOfNodes; ++j) {
            if (this.pipe.getNode(j).getBulkSystem().getPhases()[phase].getComponents()[comp].getx() + this.diffMatrix.get(j, 0) * this.pipe.getNode(j).getBulkSystem().getPhases()[phase].getMolarMass() / this.pipe.getNode(j).getBulkSystem().getPhases()[phase].getComponents()[comp].getMolarMass() > 1.0) {
                this.pipe.getNode(j).getBulkSystem().getPhases()[phase].getComponents()[comp].setx(1.0);
            } else if (this.pipe.getNode(j).getBulkSystem().getPhases()[phase].getComponents()[comp].getx() + this.diffMatrix.get(j, 0) * this.pipe.getNode(j).getBulkSystem().getPhases()[phase].getMolarMass() / this.pipe.getNode(j).getBulkSystem().getPhases()[phase].getComponents()[comp].getMolarMass() < 0.0) {
                this.pipe.getNode(j).getBulkSystem().getPhases()[phase].getComponents()[comp].setx(1.0E-30);
            } else {
                this.pipe.getNode(j).getBulkSystem().getPhases()[phase].getComponents()[comp].setx(this.pipe.getNode(j).getBulkSystem().getPhases()[phase].getComponents()[comp].getx() + this.diffMatrix.get(j, 0) * this.pipe.getNode(j).getBulkSystem().getPhases()[phase].getMolarMass() / this.pipe.getNode(j).getBulkSystem().getPhases()[phase].getComponents()[comp].getMolarMass());
            }
            double xSum = 0.0;
            for (int i = 0; i < this.pipe.getNode(j).getBulkSystem().getPhases()[phase].getNumberOfComponents() - 1; ++i) {
                xSum += this.pipe.getNode(j).getBulkSystem().getPhases()[phase].getComponents()[i].getx();
            }
            this.pipe.getNode(j).getBulkSystem().getPhases()[phase].getComponents()[this.pipe.getNode(j).getBulkSystem().getPhases()[phase].getNumberOfComponents() - 1].setx(1.0 - xSum);
            this.pipe.getNode(j).init();
        }
    }

    public void initFinalResults(int phase) {
        for (int i = 0; i < this.numberOfNodes; ++i) {
            this.oldVelocity[phase][i] = this.pipe.getNode(i).getVelocityIn().doubleValue();
            this.oldDensity[phase][i] = this.pipe.getNode(i).getBulkSystem().getPhases()[0].getPhysicalProperties().getDensity();
            this.oldInternalEnergy[phase][i] = this.pipe.getNode(i).getBulkSystem().getPhases()[0].getEnthalpy() / this.pipe.getNode(i).getBulkSystem().getPhases()[0].getNumberOfMolesInPhase() / this.pipe.getNode(i).getBulkSystem().getPhases()[0].getMolarMass();
            for (int j = 0; j < this.pipe.getNode(i).getBulkSystem().getPhases()[0].getNumberOfComponents(); ++j) {
                this.oldComposition[phase][j][i] = this.xNew[phase][j][i];
            }
        }
    }

    public void calcFluxes() {
        for (int i = 0; i < this.numberOfNodes; ++i) {
            this.pipe.getNode(i).calcFluxes();
        }
    }

    public void initNodes() {
        for (int i = 0; i < this.numberOfNodes; ++i) {
            this.pipe.getNode(i).init();
        }
    }

    @Override
    public void solveTDMA() {
        this.initProfiles();
    }
}

