/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.flowNode.fluidBoundary.heatMassTransferCalc.nonEquilibriumFluidBoundary.filmModelBoundary.reactiveFilmModel;

import Jama.Matrix;
import neqsim.fluidMechanics.flowNode.FlowNodeInterface;
import neqsim.fluidMechanics.flowNode.fluidBoundary.heatMassTransferCalc.nonEquilibriumFluidBoundary.filmModelBoundary.KrishnaStandartFilmModel;
import neqsim.thermo.system.SystemInterface;

public abstract class ReactiveFluidBoundary
extends KrishnaStandartFilmModel {
    private static final long serialVersionUID = 1000L;
    protected int neq = 0;
    protected Matrix dx;
    protected Matrix Jac;
    protected Matrix fvec;
    protected Matrix uMassTrans;
    protected Matrix uMassTransold;
    protected Matrix Xgij;
    public double[][] molFractionDifference;

    public ReactiveFluidBoundary() {
    }

    public ReactiveFluidBoundary(SystemInterface system) {
        super(system);
        this.neq = 3 * this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents();
        this.Jac = new Matrix(this.neq, this.neq);
        this.fvec = new Matrix(this.neq, 1);
    }

    public ReactiveFluidBoundary(FlowNodeInterface flowNode) {
        super(flowNode);
        this.neq = 3 * this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents();
        this.Jac = new Matrix(this.neq, this.neq);
        this.fvec = new Matrix(this.neq, 1);
    }

    @Override
    public ReactiveFluidBoundary clone() {
        ReactiveFluidBoundary clonedSystem = null;
        try {
            clonedSystem = (ReactiveFluidBoundary)super.clone();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return clonedSystem;
    }

    @Override
    public void setfvecMassTrans() {
        int i;
        double sumx = 0.0;
        double sumy = 0.0;
        for (i = 0; i < this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(); ++i) {
            this.fvec.set(i, 0, Math.log(this.interphaseSystem.getPhases()[0].getComponents()[i].getFugacityCoefficient() * this.interphaseSystem.getPhases()[0].getComponents()[i].getx()) - Math.log(this.interphaseSystem.getPhases()[1].getComponents()[i].getFugacityCoefficient() * this.interphaseSystem.getPhases()[1].getComponents()[i].getx()));
            sumx += this.interphaseSystem.getPhases()[0].getComponents()[i].getx();
            sumy += this.interphaseSystem.getPhases()[1].getComponents()[i].getx();
        }
        this.fvec.set(this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() - 1, 0, 1.0 - sumx);
        this.fvec.set(this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(), 0, 1.0 - sumy);
        for (i = this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() + 1; i < 2 * this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(); ++i) {
            this.fvec.set(i, 0, this.totalMassTransferCoefficientMatrix[1].get(i - (this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() + 1), i - (this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() + 1)) * (this.bulkSystem.getPhases()[0].getComponents()[i - (this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() + 1)].getx() - this.interphaseSystem.getPhases()[0].getComponents()[i - (this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() + 1)].getx()) + this.totalMassTransferCoefficientMatrix[0].get(i - (this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() + 1), i - (this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() + 1)) * (this.bulkSystem.getPhases()[1].getComponents()[i - (this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() + 1)].getx() - this.interphaseSystem.getPhases()[1].getComponents()[i - (this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() + 1)].getx()));
        }
    }

    @Override
    public void setfvecMassTrans2() {
        double sumx = 0.0;
        double sumy = 0.0;
        for (int i = 0; i < this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(); ++i) {
            this.fvec.set(i, 0, Math.log(this.interphaseSystem.getPhases()[0].getComponents()[i].getFugacityCoefficient() * this.interphaseSystem.getPhases()[0].getComponents()[i].getx()) - Math.log(this.interphaseSystem.getPhases()[1].getComponents()[i].getFugacityCoefficient() * this.interphaseSystem.getPhases()[1].getComponents()[i].getx()));
            sumx += this.interphaseSystem.getPhases()[1].getComponents()[i].getx();
            sumy += this.interphaseSystem.getPhases()[0].getComponents()[i].getx();
        }
        this.fvec.set(this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(), 0, 1.0 - sumx);
        this.fvec.set(this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() + 1, 0, 1.0 - sumy);
        Matrix dx = new Matrix(1, this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() - 1);
        Matrix dy = new Matrix(1, this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() - 1);
        Matrix x = new Matrix(1, this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() - 1);
        Matrix y = new Matrix(1, this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() - 1);
        for (int i = 0; i < this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() - 1; ++i) {
            dy.set(0, i, this.bulkSystem.getPhases()[0].getComponents()[i].getx() - this.interphaseSystem.getPhases()[0].getComponents()[i].getx());
            dx.set(0, i, this.bulkSystem.getPhases()[1].getComponents()[i].getx() - this.interphaseSystem.getPhases()[1].getComponents()[i].getx());
            y.set(0, i, this.bulkSystem.getPhases()[0].getComponents()[i].getx());
            x.set(0, i, this.bulkSystem.getPhases()[1].getComponents()[i].getx());
        }
        Matrix fluxX = this.totalMassTransferCoefficientMatrix[1].times(dx.transpose()).times(this.bulkSystem.getPhases()[1].getPhysicalProperties().getDensity() / this.bulkSystem.getPhases()[1].getMolarMass());
        Matrix fluxY = this.totalMassTransferCoefficientMatrix[0].times(dy.transpose()).times(this.bulkSystem.getPhases()[0].getPhysicalProperties().getDensity() / this.bulkSystem.getPhases()[0].getMolarMass());
        Matrix errX = this.nFlux.getMatrix(0, this.bulkSystem.getPhases()[1].getNumberOfMolecularComponents() - 2, 0, 0).plus(fluxX).minus(x.transpose().times(this.totalFlux));
        Matrix errY = this.nFlux.getMatrix(0, this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() - 2, 0, 0).minus(fluxY).minus(y.transpose().times(this.totalFlux));
        for (int i = this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() + 2; i < 2 * this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() + 1; ++i) {
            this.fvec.set(i, 0, errX.get(i - (this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() + 2), 0));
            this.fvec.set(i + (this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() - 1), 0, errY.get(i - (this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() + 2), 0));
        }
    }

    @Override
    public void setJacMassTrans() {
        int j;
        int i;
        double dij = 0.0;
        double tempJ = 0.0;
        this.Jac.timesEquals(0.0);
        for (i = 0; i < this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() - 1; ++i) {
            for (j = 0; j < this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(); ++j) {
                dij = i == j ? 1.0 : 0.0;
                tempJ = dij * 1.0 / this.interphaseSystem.getPhases()[0].getComponents()[i].getx() + this.interphaseSystem.getPhases()[0].getComponents()[i].getdfugdx(j);
                this.Jac.set(i, j, tempJ);
            }
        }
        for (i = 0; i < this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(); ++i) {
            this.Jac.set(this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() - 1, i, -1.0);
            this.Jac.set(this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() - 1, this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() + i, 0.0);
            this.Jac.set(this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(), i, 0.0);
            this.Jac.set(this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(), this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() + i, -1.0);
        }
        for (i = 0; i < this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() - 1; ++i) {
            for (j = 0; j < this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(); ++j) {
                dij = i == j ? 1.0 : 0.0;
                tempJ = dij * 1.0 / this.interphaseSystem.getPhases()[1].getComponents()[i].getx() + this.interphaseSystem.getPhases()[1].getComponents()[i].getdfugdx(j);
                this.Jac.set(i, j + this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(), -tempJ);
            }
        }
        for (i = this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(); i < 2 * this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() - 1; ++i) {
            for (j = 0; j < this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(); ++j) {
                dij = i == j + this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() ? 1.0 : 0.0;
                tempJ = -dij * this.totalMassTransferCoefficientMatrix[1].get(i - this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(), i - this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents());
                this.Jac.set(i + 1, j, tempJ);
            }
        }
        for (i = this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(); i < 2 * this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() - 1; ++i) {
            for (j = this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(); j < 2 * this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(); ++j) {
                dij = i == j ? 1.0 : 0.0;
                tempJ = -dij * this.totalMassTransferCoefficientMatrix[0].get(i - this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(), i - this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents());
                this.Jac.set(i + 1, j, tempJ);
            }
        }
    }

    @Override
    public void setJacMassTrans2() {
        int j;
        int i;
        double dij = 0.0;
        double tempJ = 0.0;
        this.Jac.timesEquals(0.0);
        for (i = 0; i < this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(); ++i) {
            for (j = 0; j < this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(); ++j) {
                dij = i == j ? 1.0 : 0.0;
                tempJ = dij * 1.0 / this.interphaseSystem.getPhases()[0].getComponents()[i].getx() + this.interphaseSystem.getPhases()[0].getComponents()[i].getdfugdx(j);
                this.Jac.set(i, j, tempJ);
            }
        }
        for (i = 0; i < this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(); ++i) {
            this.Jac.set(this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(), i, 0.0);
            this.Jac.set(this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(), this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() + i, -1.0);
            this.Jac.set(this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() + 1, i, -1.0);
            this.Jac.set(this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() + 1, this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() + i, 0.0);
        }
        for (i = 0; i < this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(); ++i) {
            for (j = 0; j < this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(); ++j) {
                dij = i == j ? 1.0 : 0.0;
                tempJ = dij * 1.0 / this.interphaseSystem.getPhases()[1].getComponents()[i].getx() + this.interphaseSystem.getPhases()[1].getComponents()[i].getdfugdx(j);
                this.Jac.set(i, j + this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(), -tempJ);
            }
        }
        for (i = this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(); i < 2 * this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() - 1; ++i) {
            for (j = 0; j < this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(); ++j) {
                double d = dij = i == j + this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() ? 1.0 : 0.0;
                if (j != this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() - 1) {
                    this.Jac.set(i + 2, j + this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(), -this.totalMassTransferCoefficientMatrix[1].get(i - this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(), j) * this.bulkSystem.getPhases()[1].getPhysicalProperties().getDensity() / this.bulkSystem.getPhases()[1].getMolarMass());
                }
                this.Jac.set(i + 2, j + 2 * this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(), dij - this.bulkSystem.getPhases()[1].getComponents()[i - this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents()].getx());
            }
        }
        for (i = this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(); i < 2 * this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() - 1; ++i) {
            for (j = this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(); j < 2 * this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(); ++j) {
                double d = dij = i == j ? 1.0 : 0.0;
                if (j != 2 * this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents() - 1) {
                    this.Jac.set(i + 1 + this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(), j - this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(), this.totalMassTransferCoefficientMatrix[0].get(i - this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(), j - this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents()) * this.bulkSystem.getPhases()[0].getPhysicalProperties().getDensity() / this.bulkSystem.getPhases()[0].getMolarMass());
                }
                this.Jac.set(i + 1 + this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(), j + this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(), dij - this.bulkSystem.getPhases()[0].getComponents()[i - this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents()].getx());
            }
        }
    }

    @Override
    public void setuMassTrans() {
        int i;
        for (i = 0; i < this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(); ++i) {
            this.uMassTrans.set(i, 0, this.interphaseSystem.getPhases()[0].getComponents()[i].getx());
            this.uMassTrans.set(i + this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(), 0, this.interphaseSystem.getPhases()[1].getComponents()[i].getx());
        }
        for (i = 2 * this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(); i < 3 * this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(); ++i) {
            this.uMassTrans.set(i, 0, this.nFlux.get(i - 2 * this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(), 0));
        }
    }

    @Override
    public void updateMassTrans() {
        int i;
        for (i = 0; i < this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(); ++i) {
            this.interphaseSystem.getPhases()[0].getComponents()[i].setx(this.uMassTrans.get(i, 0));
            this.interphaseSystem.getPhases()[1].getComponents()[i].setx(this.uMassTrans.get(i + this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(), 0));
        }
        for (i = 2 * this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(); i < 3 * this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(); ++i) {
            this.nFlux.set(i - 2 * this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(), 0, this.uMassTrans.get(i, 0));
        }
    }

    @Override
    public void calcMolFractionDifference() {
        for (int i = 0; i < this.getBulkSystem().getPhases()[0].getNumberOfMolecularComponents() - 1; ++i) {
            this.molFractionDifference[0][i] = this.bulkSystem.getPhases()[0].getComponents()[i].getx() - this.interphaseSystem.getPhases()[0].getComponents()[i].getx();
            this.molFractionDifference[1][i] = this.bulkSystem.getPhases()[1].getComponents()[i].getx() - this.interphaseSystem.getPhases()[1].getComponents()[i].getx();
        }
    }

    @Override
    public void calcHeatTransferCoefficients(int phase) {
        this.prandtlNumber[phase] = this.getBulkSystem().getPhases()[phase].getCp() * this.getBulkSystem().getPhases()[phase].getPhysicalProperties().getViscosity() / this.getBulkSystem().getPhases()[phase].getPhysicalProperties().getConductivity();
        this.heatTransferCoefficient[phase] = this.flowNode.getInterphaseTransportCoefficient().calcInterphaseHeatTransferCoefficient(phase, this.prandtlNumber[phase], this.flowNode);
    }

    @Override
    public void calcHeatTransferCorrection(int phase) {
        double temp = 0.0;
        for (int i = 0; i < this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(); ++i) {
            temp += this.bulkSystem.getPhases()[0].getComponents()[i].getNumberOfMolesInPhase() * this.getBulkSystem().getPhases()[phase].getCp() / this.heatTransferCoefficient[phase];
        }
        this.heatTransferCorrection[phase] = temp;
    }

    @Override
    public void initMassTransferCalc() {
        super.initMassTransferCalc();
    }

    @Override
    public void initHeatTransferCalc() {
        super.initHeatTransferCalc();
    }

    @Override
    public void init() {
        this.calcMolFractionDifference();
        super.init();
    }

    @Override
    public void heatTransSolve() {
        double f = 0.0;
        double df = 0.0;
        double dhtot = 0.0;
        do {
            dhtot = 0.0;
            for (int i = 0; i < this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(); ++i) {
                dhtot += this.nFlux.get(i, 0) * (this.bulkSystem.getPhases()[0].getComponents()[i].getEnthalpy(this.bulkSystem.getPhases()[0].getTemperature()) - this.bulkSystem.getPhases()[1].getComponents()[i].getEnthalpy(this.bulkSystem.getPhases()[1].getTemperature()));
            }
            f = this.heatTransferCoefficient[0] * this.heatTransferCorrection[0] * (this.bulkSystem.getPhases()[0].getTemperature() - this.interphaseSystem.getTemperature()) + this.heatTransferCoefficient[1] * this.heatTransferCorrection[1] * (this.bulkSystem.getPhases()[1].getTemperature() - this.interphaseSystem.getTemperature()) + dhtot;
            df = -this.heatTransferCoefficient[0] * this.heatTransferCorrection[0] - this.heatTransferCoefficient[1] * this.heatTransferCorrection[1];
            this.interphaseSystem.setTemperature(this.interphaseSystem.getTemperature() - f / df);
        } while (Math.abs(f) > 1.0E-10);
    }

    @Override
    public void massTransSolve() {
        int iter = 0;
        this.setuMassTrans();
        do {
            ++iter;
            this.init();
            this.setfvecMassTrans2();
            this.setJacMassTrans2();
            this.dx = this.Jac.solve(this.fvec);
            this.uMassTrans.minusEquals(this.dx.times(0.1));
            this.updateMassTrans();
            this.calcFluxes();
            this.dx.print(30, 30);
        } while (Math.abs(this.dx.norm2() / this.uMassTrans.norm2()) > 1.0E-10 && iter < 50);
        this.calcFluxes2();
    }

    @Override
    public double[] calcFluxes() {
        double sum = 0.0;
        for (int i = 0; i < this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(); ++i) {
            sum += this.nFlux.get(i, 0);
        }
        this.totalFlux = sum;
        return this.nFlux.transpose().getArray()[0];
    }

    public double[] calcFluxes2() {
        double sum = 0.0;
        for (int i = 0; i < this.bulkSystem.getPhases()[0].getNumberOfMolecularComponents(); ++i) {
            sum += this.nFlux.get(i, 0);
        }
        this.totalFlux = sum;
        return this.nFlux.transpose().getArray()[0];
    }

    @Override
    public void solve() {
        int iterOuter = 0;
        double totalFluxOld = this.totalFlux;
        do {
            ++iterOuter;
            totalFluxOld = this.totalFlux;
            if (this.massTransferCalc) {
                this.massTransSolve();
            }
            if (!this.heatTransferCalc) continue;
            this.heatTransSolve();
        } while (Math.abs((totalFluxOld - this.totalFlux) / this.totalFlux) > 1.0E-10 && iterOuter < 55);
        this.init();
    }
}

