/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.flowNode;

import neqsim.fluidMechanics.flowNode.fluidBoundary.heatMassTransferCalc.FluidBoundaryInterface;
import neqsim.fluidMechanics.flowNode.fluidBoundary.interphaseTransportCoefficient.InterphaseTransportCoefficientInterface;
import neqsim.fluidMechanics.geometryDefinitions.GeometryDefinitionInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import neqsim.util.util.DoubleCloneable;

public interface FlowNodeInterface
extends Cloneable {
    public SystemInterface getBulkSystem();

    public FluidBoundaryInterface getFluidBoundary();

    public SystemInterface getInterphaseSystem();

    public void init();

    default public double getVelocity() {
        return this.getVelocity(0);
    }

    public double getVelocity(int var1);

    default public DoubleCloneable getVelocityIn() {
        return this.getVelocityIn(0);
    }

    public DoubleCloneable getVelocityIn(int var1);

    default public DoubleCloneable getVelocityOut() {
        return this.getVelocityOut(0);
    }

    public DoubleCloneable getVelocityOut(int var1);

    public void setInterphaseModelType(int var1);

    default public double getWallFrictionFactor() {
        return this.getWallFrictionFactor(0);
    }

    public double getWallFrictionFactor(int var1);

    public double calcStantonNumber(double var1, int var3);

    public double getHydraulicDiameter(int var1);

    public void write(String var1, String var2, boolean var3);

    default public void setVelocity(double vel) {
        this.setVelocity(0, vel);
    }

    public void setVelocity(int var1, double var2);

    public void increaseMolarRate(double var1);

    public double getSchmidtNumber(int var1, int var2, int var3);

    public double getEffectiveSchmidtNumber(int var1, int var2);

    default public double getReynoldsNumber() {
        return this.getReynoldsNumber(0);
    }

    public double getReynoldsNumber(int var1);

    public FlowNodeInterface getNextNode();

    public ThermodynamicOperations getOperations();

    public double getDistanceToCenterOfNode();

    public void update();

    public void setEnhancementType(int var1);

    public double getMolarMassTransferRate(int var1);

    default public void setVelocityOut(double vel) {
        this.setVelocityOut(0, vel);
    }

    public void setVelocityOut(int var1, double var2);

    default public void setVelocityOut(DoubleCloneable vel) {
        this.setVelocityOut(0, vel);
    }

    public void setVelocityOut(int var1, DoubleCloneable var2);

    public InterphaseTransportCoefficientInterface getInterphaseTransportCoefficient();

    public double getPhaseFraction(int var1);

    public double getInterphaseContactArea();

    public void setFrictionFactorType(int var1);

    public void setPhaseFraction(int var1, double var2);

    public double getWallContactLength(int var1);

    public double getInterphaseContactLength(int var1);

    public double getMassFlowRate(int var1);

    public double getInterPhaseFrictionFactor();

    public void setDistanceToCenterOfNode(double var1);

    public void setLengthOfNode(double var1);

    public double getLengthOfNode();

    public double getVolumetricFlow();

    public double getArea(int var1);

    public void updateMolarFlow();

    public double getPrandtlNumber(int var1);

    default public void setVelocityIn(double vel) {
        this.setVelocityIn(0, vel);
    }

    public void setVelocityIn(int var1, double var2);

    default public void setVelocityIn(DoubleCloneable vel) {
        this.setVelocityIn(0, vel);
    }

    public void setVelocityIn(int var1, DoubleCloneable var2);

    public void initFlowCalc();

    public double calcSherwoodNumber(double var1, int var3);

    public double calcNusseltNumber(double var1, int var3);

    public void calcFluxes();

    public double getSuperficialVelocity(int var1);

    public GeometryDefinitionInterface getGeometry();

    public void setGeometryDefinitionInterface(GeometryDefinitionInterface var1);

    public void setFluxes(double[] var1);

    public void setInterphaseSystem(SystemInterface var1);

    public void setBulkSystem(SystemInterface var1);

    public double getVerticalPositionOfNode();

    public int getFlowDirection(int var1);

    public void setFlowDirection(int var1, int var2);

    public void setVerticalPositionOfNode(double var1);

    public String getFlowNodeType();

    public double calcTotalHeatTransferCoefficient(int var1);

    public void initBulkSystem();

    default public void display() {
        this.display("");
    }

    public void display(String var1);

    default public void setWallFrictionFactor(double frictionFactor) {
        this.setWallFrictionFactor(0, frictionFactor);
    }

    public void setWallFrictionFactor(int var1, double var2);
}

