/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.flowLeg;

import java.io.Serializable;
import neqsim.fluidMechanics.flowLeg.FlowLegInterface;
import neqsim.fluidMechanics.flowNode.FlowNodeInterface;
import neqsim.fluidMechanics.flowNode.FlowNodeSelector;
import neqsim.fluidMechanics.geometryDefinitions.GeometryDefinitionInterface;
import neqsim.thermo.system.SystemInterface;

public abstract class FlowLeg
implements FlowLegInterface,
Serializable {
    private static final long serialVersionUID = 1000L;
    protected FlowNodeInterface[] flowNode;
    protected int numberOfNodes = 0;
    protected double startLongitudionalCoordinate;
    protected double endLongitudionalCoordinate;
    protected double startHeightCoordinate;
    protected double endHeightCoordinate;
    protected double startOuterTemperature;
    protected double endOuterTemperature;
    protected double startOuterHeatTransferCoefficient;
    protected double endOuterHeatTransferCoefficient;
    protected double startWallHeatTransferCOefficients;
    protected double endWallHeatTransferCOefficients;
    protected SystemInterface thermoSystem;
    protected GeometryDefinitionInterface equipmentGeometry;
    protected double heightChangePerNode = 0.0;
    protected double longitudionalChangePerNode = 0.0;
    protected double temperatureChangePerNode = 0.0;
    protected FlowNodeSelector nodeSelector = new FlowNodeSelector();

    public FlowLeg() {
        this.flowNode = new FlowNodeInterface[this.getNumberOfNodes()];
    }

    @Override
    public void createFlowNodes() {
        this.temperatureChangePerNode = (this.endOuterTemperature - this.startOuterTemperature) / (1.0 * (double)this.getNumberOfNodes());
        this.longitudionalChangePerNode = (this.endLongitudionalCoordinate - this.startLongitudionalCoordinate) / (1.0 * (double)this.getNumberOfNodes());
        this.heightChangePerNode = (this.endHeightCoordinate - this.startHeightCoordinate) / (1.0 * (double)this.getNumberOfNodes());
        this.flowNode[0].setDistanceToCenterOfNode(this.startLongitudionalCoordinate + 0.5 * this.longitudionalChangePerNode);
        this.flowNode[0].setLengthOfNode(this.longitudionalChangePerNode);
        this.flowNode[0].setVerticalPositionOfNode(this.startHeightCoordinate + 0.5 * this.heightChangePerNode);
        this.flowNode[0].getGeometry().getSurroundingEnvironment().setTemperature(this.startOuterTemperature + 0.5 * this.temperatureChangePerNode);
        this.flowNode[0].init();
        for (int i = 0; i < this.getNumberOfNodes() - 1; ++i) {
            this.flowNode[i + 1] = this.flowNode[i].getNextNode();
            this.flowNode[i + 1].setDistanceToCenterOfNode(this.flowNode[0].getDistanceToCenterOfNode() + (double)(i + 1) * this.longitudionalChangePerNode);
            this.flowNode[i + 1].setVerticalPositionOfNode(this.flowNode[0].getVerticalPositionOfNode() + (double)(i + 1) * this.heightChangePerNode);
            this.flowNode[i + 1].setLengthOfNode(this.longitudionalChangePerNode);
            this.flowNode[i].getGeometry().getSurroundingEnvironment().setTemperature(this.startOuterTemperature + (double)(i + 1) * this.temperatureChangePerNode);
            this.flowNode[i].getGeometry().getSurroundingEnvironment().setHeatTransferCoefficient(this.startOuterHeatTransferCoefficient + (double)(i + 1) * 1.0 / ((double)this.getNumberOfNodes() * 1.0) * (this.endOuterHeatTransferCoefficient - this.startOuterHeatTransferCoefficient));
            this.flowNode[i].getGeometry().setWallHeatTransferCoefficient(this.startWallHeatTransferCOefficients + (double)(i + 1) * 1.0 / ((double)this.getNumberOfNodes() * 1.0) * (this.endWallHeatTransferCOefficients - this.startWallHeatTransferCOefficients));
            this.flowNode[i + 1].init();
        }
    }

    public void setFlowNodeTypes() {
        this.nodeSelector.getFlowNodeType(this.flowNode);
        for (int i = 0; i < this.getNumberOfNodes(); ++i) {
            this.flowNode[i].setDistanceToCenterOfNode(this.flowNode[0].getDistanceToCenterOfNode() + (double)i * this.longitudionalChangePerNode);
            this.flowNode[i].setLengthOfNode(this.longitudionalChangePerNode);
            this.flowNode[i].setVerticalPositionOfNode(this.flowNode[0].getVerticalPositionOfNode() + (double)i * this.heightChangePerNode);
            this.flowNode[i].getGeometry().getSurroundingEnvironment().setTemperature(this.startOuterTemperature + (double)i * this.temperatureChangePerNode);
            this.flowNode[i].init();
        }
    }

    @Override
    public void setFlowPattern(String flowPattern) {
        this.nodeSelector.setFlowPattern(this.flowNode, flowPattern);
        this.flowNode[0].init();
        this.flowNode[0].setDistanceToCenterOfNode(this.startLongitudionalCoordinate + 0.5 * this.longitudionalChangePerNode);
        this.flowNode[0].setLengthOfNode(this.longitudionalChangePerNode);
        this.flowNode[0].setVerticalPositionOfNode(this.startHeightCoordinate + 0.5 * this.heightChangePerNode);
        for (int i = 0; i < this.getNumberOfNodes() - 1; ++i) {
            this.flowNode[i + 1] = this.flowNode[i].getNextNode();
            this.flowNode[i + 1].setDistanceToCenterOfNode(this.flowNode[0].getDistanceToCenterOfNode() + (double)(i + 1) * this.longitudionalChangePerNode);
            this.flowNode[i + 1].setVerticalPositionOfNode(this.flowNode[0].getVerticalPositionOfNode() + (double)(i + 1) * this.heightChangePerNode);
            this.flowNode[i + 1].setLengthOfNode(this.longitudionalChangePerNode);
            this.flowNode[i].getGeometry().getSurroundingEnvironment().setTemperature(this.startOuterTemperature + (double)i * this.temperatureChangePerNode);
            this.flowNode[i + 1].init();
        }
    }

    @Override
    public void setThermoSystem(SystemInterface thermoSystem) {
        this.thermoSystem = thermoSystem.clone();
    }

    @Override
    public void setEquipmentGeometry(GeometryDefinitionInterface equipmentGeometry) {
        this.equipmentGeometry = equipmentGeometry.clone();
    }

    @Override
    public void setNumberOfNodes(int numberOfNodes) {
        this.numberOfNodes = numberOfNodes;
    }

    @Override
    public int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    @Override
    public void setHeightCoordinates(double startHeightCoordinate, double endHeightCoordinate) {
        this.startHeightCoordinate = startHeightCoordinate;
        this.endHeightCoordinate = endHeightCoordinate;
    }

    @Override
    public void setOuterHeatTransferCoefficients(double startHeatTransferCoefficient, double endHeatTransferCoefficient) {
        this.startOuterHeatTransferCoefficient = startHeatTransferCoefficient;
        this.endOuterHeatTransferCoefficient = endHeatTransferCoefficient;
    }

    @Override
    public void setWallHeatTransferCoefficients(double startHeatTransferCoefficient, double endHeatTransferCoefficient) {
        this.startWallHeatTransferCOefficients = startHeatTransferCoefficient;
        this.endWallHeatTransferCOefficients = endHeatTransferCoefficient;
    }

    @Override
    public void setLongitudionalCoordinates(double startLongitudionalCoordinate, double endLongitudionalCoordinate) {
        this.startLongitudionalCoordinate = startLongitudionalCoordinate;
        this.endLongitudionalCoordinate = endLongitudionalCoordinate;
    }

    @Override
    public void setOuterTemperatures(double startTemperature, double endTemperature) {
        this.startOuterTemperature = startTemperature;
        this.endOuterTemperature = endTemperature;
    }

    @Override
    public FlowNodeInterface[] getFlowNodes() {
        return this.flowNode;
    }

    @Override
    public FlowNodeInterface getNode(int i) {
        return this.flowNode[i];
    }
}

