/*
 * Decompiled with CFR 0.152.
 */
package neqsim.util.database;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import neqsim.util.util.FileSystemSettings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NeqSimDataBase
implements FileSystemSettings,
Serializable {
    private static final long serialVersionUID = 1000L;
    public static String dataBasePath = "";
    static Logger logger = LogManager.getLogger(NeqSimDataBase.class);
    private static boolean createTemporaryTables = false;
    private static String username = "remote";
    private static String password = "remote";
    private static String dataBaseType = "H2fromCSV";
    private static String connectionString = "jdbc:h2:mem:neqsimthermodatabase";
    private static boolean h2IsInit = false;
    private Statement statement = null;
    protected Connection databaseConnection = null;

    public static boolean createTemporaryTables() {
        return createTemporaryTables;
    }

    public static void setCreateTemporaryTables(boolean createTemporaryTables) {
        NeqSimDataBase.createTemporaryTables = createTemporaryTables;
    }

    public NeqSimDataBase() {
        if (dataBaseType == "H2fromCSV" && !h2IsInit) {
            h2IsInit = true;
            NeqSimDataBase.initH2DatabaseFromCSVfiles();
        }
        NeqSimDataBase.setDataBaseType(dataBaseType);
        try {
            this.databaseConnection = this.openConnection();
            this.statement = this.databaseConnection.createStatement();
        }
        catch (Exception ex) {
            logger.error("SQLException " + ex.getMessage());
            throw new RuntimeException(ex);
        }
    }

    public Connection openConnection() throws SQLException, ClassNotFoundException {
        InitialContext ctx = null;
        DataSource ds = null;
        try {
            if (System.getenv("NEQSIMTHERMODB_CS") != null) {
                Properties properties = new Properties();
                properties.setProperty("user", System.getenv("MYSQL_USER"));
                properties.setProperty("password", System.getenv("MYSQL_PASSWORD"));
                properties.setProperty("useSSL", "false");
                Connection connection = DriverManager.getConnection(System.getenv("NEQSIMTHERMODB_CS"), properties);
                return connection;
            }
            if (dataBaseType.equals("MSAccess")) {
                String dir = "";
                dir = System.getProperty("NeqSim.home") == null ? "c:\\programming\\NeqSimSourceCode\\java\\neqsim" : System.getProperty("NeqSim.home");
                Connection connection = DriverManager.getConnection("jdbc:odbc:DRIVER={Microsoft Access Driver (*.mdb)};DBQ=" + dir + "\\data\\NeqSimDatabase");
                return connection;
            }
            if (dataBaseType.equals("H2fromCSV") || dataBaseType.equals("H2") || dataBaseType.equals("H2RT")) {
                Connection dir = DriverManager.getConnection(connectionString, "sa", "");
                return dir;
            }
            if (dataBaseType.equals("MSAccessUCanAccess")) {
                Connection dir = DriverManager.getConnection(NeqSimDataBase.getConnectionString());
                return dir;
            }
            if (dataBaseType.equals("mySQL") || dataBaseType.equals("mySQLNTNU") || dataBaseType.equals("Derby")) {
                Connection dir = DriverManager.getConnection(NeqSimDataBase.getConnectionString(), username, password);
                return dir;
            }
            if (dataBaseType.equals("mySQLNeqSimWeb")) {
                ctx = new InitialContext();
                ds = (DataSource)ctx.lookup("java:comp/env/jdbc/NeqsimThermoDatabase");
                Connection dir = ds.getConnection();
                return dir;
            }
            Connection dir = DriverManager.getConnection(NeqSimDataBase.getConnectionString());
            return dir;
        }
        catch (Exception ex) {
            logger.error("error loading NeqSimDataBase... " + ex.toString());
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (Exception ex) {
                logger.error("error", (Throwable)ex);
            }
        }
    }

    public Connection getConnection() {
        return this.databaseConnection;
    }

    public ResultSet getResultSet(String sqlString) {
        try {
            ResultSet result = this.getStatement().executeQuery(sqlString);
            return result;
        }
        catch (Exception ex) {
            logger.error("error loading NeqSimbataBase " + ex.toString());
            throw new RuntimeException(ex);
        }
    }

    public void execute(String sqlString) {
        try {
            if (this.databaseConnection == null) {
                this.databaseConnection = this.openConnection();
                this.setStatement(this.databaseConnection.createStatement());
            }
            this.getStatement().execute(sqlString);
        }
        catch (Exception ex) {
            logger.error("error in NeqSimDataBase " + ex.toString(), (Throwable)ex);
            logger.error("The database must be rgistered on the local DBMS to work.");
            throw new RuntimeException(ex);
        }
    }

    public void executeQuery(String sqlString) {
        try {
            if (this.databaseConnection == null) {
                this.databaseConnection = this.openConnection();
                this.setStatement(this.databaseConnection.createStatement());
            }
            this.getStatement().executeQuery(sqlString);
        }
        catch (Exception ex) {
            logger.error("error in NeqSimDataBase " + ex.toString(), (Throwable)ex);
            logger.error("The database must be rgistered on the local DBMS to work.");
            throw new RuntimeException(ex);
        }
    }

    public static String getDataBaseType() {
        return dataBaseType;
    }

    public static void setDataBaseType(String aDataBaseType) {
        NeqSimDataBase.setDataBaseType(aDataBaseType, null);
    }

    public static void setDataBaseType(String aDataBaseType, String connectionString) {
        dataBaseType = aDataBaseType;
        if (connectionString != null) {
            NeqSimDataBase.connectionString = connectionString;
        }
        try {
            if (dataBaseType.equals("MSAccess")) {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            } else if (!(dataBaseType.equals("H2fromCSV") || dataBaseType.equals("H2") || dataBaseType.equals("H2RT"))) {
                if (dataBaseType.equals("MSAccessUCanAccess")) {
                    Class.forName("net.ucanaccess.jdbc.UcanaccessDriver");
                } else if (dataBaseType.equals("mySQL")) {
                    Class.forName("com.mysql.cj.jdbc.Driver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                } else if (dataBaseType.equals("mySQLNTNU")) {
                    Class.forName("com.mysql.cj.jdbc.Driver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                } else if (dataBaseType.equals("Derby")) {
                    Class.forName("org.apache.derby.jdbc.EmbeddedDriver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                } else if (dataBaseType.equals("oracle")) {
                    Class.forName("oracle.jdbc.driver.OracleDriver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                } else if (dataBaseType.equals("oracleST")) {
                    Class.forName("oracle.jdbc.driver.OracleDriver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                } else {
                    Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
                }
            }
        }
        catch (Exception ex) {
            logger.error("error loading database driver.. " + ex.toString());
            throw new RuntimeException(ex);
        }
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public static void setUsername(String aUsername) {
        username = aUsername;
    }

    public static void setPassword(String aPassword) {
        password = aPassword;
    }

    public static String getConnectionString() {
        return connectionString;
    }

    public static void setConnectionString(String aConnectionString) {
        connectionString = aConnectionString;
    }

    public static void main(String[] args) {
        NeqSimDataBase database = new NeqSimDataBase();
        try (ResultSet dataSet = database.getResultSet("SELECT * FROM comp WHERE NAME='methane'");){
            dataSet.next();
            System.out.println("dataset " + dataSet.getString("molarmass"));
            logger.info("dataset " + dataSet.getString("molarmass"));
            dataSet.close();
            database.getConnection().close();
        }
        catch (Exception ex) {
            logger.error("failed " + ex.toString());
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] getComponentNames() {
        NeqSimDataBase database = new NeqSimDataBase();
        try (ResultSet dataSet = database.getResultSet("SELECT name FROM comp ORDER BY ID");){
            ArrayList<String> names = new ArrayList<String>();
            while (dataSet.next()) {
                names.add(dataSet.getString("name"));
            }
            String[] stringArray = names.toArray(new String[0]);
            return stringArray;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean hasComponent(String compName) {
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = null;
        try {
            dataSet = database.getResultSet("select count(*) from comp WHERE NAME='" + compName + "'");
            dataSet.next();
            int size = dataSet.getInt(1);
            if (size == 0) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
                if (database.getStatement() != null) {
                    database.getStatement().close();
                }
                if (database.getConnection() != null) {
                    database.getConnection().close();
                }
            }
            catch (Exception ex) {
                logger.error("error closing database.....", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initH2DatabaseFromCSVfiles() {
        connectionString = "jdbc:h2:mem:neqsimthermodatabase;DB_CLOSE_DELAY=-1";
        createTemporaryTables = false;
        dataBaseType = "H2";
        NeqSimDataBase database = new NeqSimDataBase();
        String createCOMP = "CREATE TABLE comp AS SELECT * FROM CSVREAD('classpath:/data/COMP.csv')";
        String createINTER = "CREATE TABLE inter AS SELECT * FROM CSVREAD('classpath:/data/INTER.csv')";
        String createElement = "CREATE TABLE element AS SELECT * FROM CSVREAD('classpath:/data/element.csv')";
        String create_iso6976 = "CREATE TABLE iso6976constants AS SELECT * FROM CSVREAD('classpath:/data/ISO6976constants.csv')";
        String create_iso6976_2016 = "CREATE TABLE iso6976constants2016 AS SELECT * FROM CSVREAD('classpath:/data/ISO6976constants2016.csv')";
        String create_STOCCOEFDATA = "CREATE TABLE STOCCOEFDATA AS SELECT * FROM CSVREAD('classpath:/data/STOCCOEFDATA.csv')";
        String create_REACTIONDATA = "CREATE TABLE REACTIONDATA AS SELECT * FROM CSVREAD('classpath:/data/REACTIONDATA.csv')";
        String ReactionKSPdata = "CREATE TABLE ReactionKSPdata AS SELECT * FROM CSVREAD('classpath:/data/ReactionKSPdata.csv')";
        String create_AdsorptionParameters = "CREATE TABLE AdsorptionParameters AS SELECT * FROM CSVREAD('classpath:/data/AdsorptionParameters.csv')";
        String create_UNIFACcomp = "CREATE TABLE UNIFACcomp AS SELECT * FROM CSVREAD('classpath:/data/UNIFACcomp.csv')";
        String create_UNIFACcompUMRPRU = "CREATE TABLE UNIFACcompUMRPRU AS SELECT * FROM CSVREAD('classpath:/data/UNIFACcompUMRPRU.csv')";
        String UNIFACGroupParam = "CREATE TABLE UNIFACGroupParam AS SELECT * FROM CSVREAD('classpath:/data/UNIFACGroupParam.csv')";
        String UNIFACInterParam = "CREATE TABLE UNIFACInterParam AS SELECT * FROM CSVREAD('classpath:/data/UNIFACInterParam.csv')";
        String UNIFACInterParamA_UMR = "CREATE TABLE UNIFACInterParamA_UMR AS SELECT * FROM CSVREAD('classpath:/data/UNIFACInterParamA_UMR.csv')";
        String UNIFACInterParamA_UMRMC = "CREATE TABLE UNIFACInterParamA_UMRMC AS SELECT * FROM CSVREAD('classpath:/data/UNIFACInterParamA_UMRMC.csv')";
        String UNIFACInterParamB = "CREATE TABLE UNIFACInterParamB AS SELECT * FROM CSVREAD('classpath:/data/UNIFACInterParamB.csv')";
        String UNIFACInterParamB_UMR = "CREATE TABLE UNIFACInterParamB_UMR AS SELECT * FROM CSVREAD('classpath:/data/UNIFACInterParamB_UMR.csv')";
        String UNIFACInterParamB_UMRMC = "CREATE TABLE UNIFACInterParamB_UMRMC AS SELECT * FROM CSVREAD('classpath:/data/UNIFACInterParamB_UMRMC.csv')";
        String UNIFACInterParamC = "CREATE TABLE UNIFACInterParamC AS SELECT * FROM CSVREAD('classpath:/data/UNIFACInterParamC.csv')";
        String UNIFACInterParamC_UMR = "CREATE TABLE UNIFACInterParamC_UMR AS SELECT * FROM CSVREAD('classpath:/data/UNIFACInterParamC_UMR.csv')";
        String UNIFACInterParamC_UMRMC = "CREATE TABLE UNIFACInterParamC_UMRMC AS SELECT * FROM CSVREAD('classpath:/data/UNIFACInterParamC_UMRMC.csv')";
        try {
            database.execute(createCOMP);
            database.execute(createINTER);
            database.execute(createElement);
            database.execute(create_iso6976);
            database.execute(create_iso6976_2016);
            database.execute(create_STOCCOEFDATA);
            database.execute(create_REACTIONDATA);
            database.execute(ReactionKSPdata);
            database.execute(create_AdsorptionParameters);
            database.execute(create_UNIFACcomp);
            database.execute(create_UNIFACcompUMRPRU);
            database.execute(UNIFACGroupParam);
            database.execute(UNIFACInterParam);
            database.execute(UNIFACInterParamA_UMR);
            database.execute(UNIFACInterParamA_UMRMC);
            database.execute(UNIFACInterParamB);
            database.execute(UNIFACInterParamB_UMR);
            database.execute(UNIFACInterParamB_UMRMC);
            database.execute(UNIFACInterParamC);
            database.execute(UNIFACInterParamC_UMR);
            database.execute(UNIFACInterParamC_UMRMC);
            database.execute("CREATE TABLE comptemp AS SELECT * FROM comp");
            database.execute("CREATE TABLE intertemp AS SELECT * FROM inter");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (database.getStatement() != null) {
                    database.getStatement().close();
                }
                if (database.getConnection() != null) {
                    database.getConnection().close();
                }
            }
            catch (Exception ex) {
                logger.error("error closing database.....", (Throwable)ex);
            }
        }
    }
}

