/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps;

import java.util.ArrayList;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.flashOps.TPflash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ejml.simple.SimpleMatrix;

public class TPmultiflash
extends TPflash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(TPmultiflash.class);
    boolean multiPhaseTest = false;
    double[][] dQdbeta;
    double[][] Qmatrix;
    double[] Erow;
    double Q = 0.0;
    boolean doStabilityAnalysis = true;
    boolean removePhase = false;
    boolean checkOneRemove = false;
    boolean secondTime = false;
    double[] multTerm;
    double[] multTerm2;

    public TPmultiflash() {
    }

    public TPmultiflash(SystemInterface system) {
        super(system);
        this.Erow = new double[system.getPhase(0).getNumberOfComponents()];
    }

    public TPmultiflash(SystemInterface system, boolean check) {
        super(system, check);
        this.Erow = new double[system.getPhase(0).getNumberOfComponents()];
        this.multTerm = new double[system.getPhase(0).getNumberOfComponents()];
        this.multTerm2 = new double[system.getPhase(0).getNumberOfComponents()];
    }

    public void calcMultiPhaseBeta() {
    }

    public void setDoubleArrays() {
        this.dQdbeta = new double[this.system.getNumberOfPhases()][1];
        this.Qmatrix = new double[this.system.getNumberOfPhases()][this.system.getNumberOfPhases()];
    }

    public void setXY() {
        for (int k = 0; k < this.system.getNumberOfPhases(); ++k) {
            for (int i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
                if (this.system.getPhase(0).getComponent(i).getz() > 1.0E-100) {
                    this.system.getPhase(k).getComponents()[i].setx(this.system.getPhase(0).getComponents()[i].getz() / this.Erow[i] / this.system.getPhase(k).getComponent(i).getFugacityCoefficient());
                }
                if (this.system.getPhase(0).getComponent(i).getIonicCharge() != 0.0 && !this.system.getPhase(k).getPhaseTypeName().equals("aqueous")) {
                    this.system.getPhase(k).getComponents()[i].setx(1.0E-50);
                }
                if (this.system.getPhase(0).getComponent(i).getIonicCharge() == 0.0 || !this.system.getPhase(k).getPhaseTypeName().equals("aqueous")) continue;
                this.system.getPhase(k).getComponents()[i].setx(this.system.getPhase(k).getComponents()[i].getNumberOfmoles() / this.system.getPhase(k).getNumberOfMolesInPhase());
            }
            this.system.getPhase(k).normalize();
        }
    }

    public void calcE() {
        for (int i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
            this.Erow[i] = 0.0;
            for (int k = 0; k < this.system.getNumberOfPhases(); ++k) {
                int n = i;
                this.Erow[n] = this.Erow[n] + this.system.getPhase(k).getBeta() / this.system.getPhase(k).getComponent(i).getFugacityCoefficient();
            }
        }
    }

    public double calcQ() {
        int i;
        this.calcE();
        for (i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
            this.multTerm[i] = this.system.getPhase(0).getComponent(i).getz() / this.Erow[i];
            this.multTerm2[i] = this.system.getPhase(0).getComponent(i).getz() / (this.Erow[i] * this.Erow[i]);
        }
        for (int k = 0; k < this.system.getNumberOfPhases(); ++k) {
            this.dQdbeta[k][0] = 1.0;
            for (int i2 = 0; i2 < this.system.getPhase(0).getNumberOfComponents(); ++i2) {
                double[] dArray = this.dQdbeta[k];
                dArray[0] = dArray[0] - this.multTerm[i2] / this.system.getPhase(k).getComponent(i2).getFugacityCoefficient();
            }
        }
        for (i = 0; i < this.system.getNumberOfPhases(); ++i) {
            for (int j = 0; j < this.system.getNumberOfPhases(); ++j) {
                this.Qmatrix[i][j] = 0.0;
                for (int k = 0; k < this.system.getPhase(0).getNumberOfComponents(); ++k) {
                    double[] dArray = this.Qmatrix[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.multTerm2[k] / (this.system.getPhase(j).getComponent(k).getFugacityCoefficient() * this.system.getPhase(i).getComponent(k).getFugacityCoefficient());
                }
                if (i != j) continue;
                double[] dArray = this.Qmatrix[i];
                int n = j;
                dArray[n] = dArray[n] + 0.001;
            }
        }
        return this.Q;
    }

    public double solveBeta() {
        SimpleMatrix betaMatrix = new SimpleMatrix(1, this.system.getNumberOfPhases());
        SimpleMatrix ans = null;
        double err = 1.0;
        int iter = 1;
        do {
            ++iter;
            for (int k = 0; k < this.system.getNumberOfPhases(); ++k) {
                betaMatrix.set(0, k, this.system.getPhase(k).getBeta());
            }
            this.calcQ();
            SimpleMatrix dQM = new SimpleMatrix(this.dQdbeta);
            SimpleMatrix dQdBM = new SimpleMatrix(this.Qmatrix);
            try {
                ans = (SimpleMatrix)dQdBM.solve(dQM).transpose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            betaMatrix = (SimpleMatrix)betaMatrix.minus(ans.scale((double)iter / ((double)iter + 3.0)));
            this.removePhase = false;
            for (int k = 0; k < this.system.getNumberOfPhases(); ++k) {
                this.system.setBeta(k, betaMatrix.get(0, k));
                if (betaMatrix.get(0, k) < 1.0E-12) {
                    this.system.setBeta(k, 1.0E-12);
                    if (this.checkOneRemove) {
                        this.checkOneRemove = false;
                        this.removePhase = true;
                    }
                    this.checkOneRemove = true;
                    continue;
                }
                if (!(betaMatrix.get(0, k) > 0.999999999999)) continue;
                this.system.setBeta(k, 0.999999999999);
            }
            this.system.normalizeBeta();
            this.system.init(1);
            this.calcE();
            this.setXY();
            this.system.init(1);
        } while ((err = ans.normF()) > 1.0E-12 && iter < 50 || iter < 3);
        return err;
    }

    @Override
    public void stabilityAnalysis() {
        int i;
        double[] logWi = new double[this.system.getPhase(0).getNumberOfComponents()];
        double[][] Wi = new double[this.system.getPhase(0).getNumberOfComponents()][this.system.getPhase(0).getNumberOfComponents()];
        double[] deltalogWi = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[] oldDeltalogWi = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[] oldoldDeltalogWi = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[] sumw = new double[this.system.getPhase(0).getNumberOfComponents()];
        double err = 0.0;
        double[] oldlogw = new double[this.system.getPhase(0).getNumberOfComponents()];
        double[] oldoldlogw = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[] oldoldoldlogw = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[] d = new double[this.system.getPhase(0).getNumberOfComponents()];
        double[][] x = new double[this.system.getPhase(0).getNumberOfComponents()][this.system.getPhase(0).getNumberOfComponents()];
        this.tm = new double[this.system.getPhase(0).getNumberOfComponents()];
        double[] alpha = null;
        ArrayList<SystemInterface> clonedSystem = new ArrayList<SystemInterface>(1);
        this.minimumGibbsEnergySystem = this.system;
        clonedSystem.add(this.system.clone());
        this.lowestGibbsEnergyPhase = 0;
        for (int k = 0; k < this.minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents(); ++k) {
            if (!(this.system.getPhase(0).getComponent(k).getx() > 1.0E-100)) continue;
            d[k] = Math.log(this.system.getPhase(0).getComponents()[k].getx()) + this.system.getPhase(0).getComponents()[k].getLogFugacityCoefficient();
        }
        for (int j = 0; j < this.minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents(); ++j) {
            logWi[j] = this.system.getPhase(0).getComponent(j).getz() > 1.0E-100 ? 1.0 : -10000.0;
        }
        int hydrocarbonTestCompNumb = 0;
        int lightTestCompNumb = 0;
        double Mmax = 0.0;
        double Mmin = 1.0E10;
        for (i = 0; i < this.minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents(); ++i) {
            if (!this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).isHydrocarbon()) continue;
            if (this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).getMolarMass() > Mmax) {
                Mmax = this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).getMolarMass();
            }
            if (!(this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).getMolarMass() < Mmin)) continue;
            Mmin = this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).getMolarMass();
        }
        for (i = 0; i < this.minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents(); ++i) {
            if (this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).isHydrocarbon() && this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).getz() > 1.0E-50 && Math.abs(this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).getMolarMass() - Mmax) < 1.0E-5) {
                hydrocarbonTestCompNumb = i;
            }
            if (!this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).isHydrocarbon() || !(this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).getz() > 1.0E-50) || !(Math.abs(this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).getMolarMass() - Mmin) < 1.0E-5)) continue;
            lightTestCompNumb = i;
        }
        for (int j = this.system.getPhase(0).getNumberOfComponents() - 1; j >= 0; --j) {
            if (this.minimumGibbsEnergySystem.getPhase(0).getComponent(j).getx() < 1.0E-100 || this.minimumGibbsEnergySystem.getPhase(0).getComponent(j).getIonicCharge() != 0.0 || this.minimumGibbsEnergySystem.getPhase(0).getComponent(j).isHydrocarbon() && j != hydrocarbonTestCompNumb && j != lightTestCompNumb) continue;
            double nomb = 0.0;
            for (int cc = 0; cc < this.system.getPhase(0).getNumberOfComponents(); ++cc) {
                double d2 = nomb = cc == j ? 1.0 : 1.0E-12;
                if (this.system.getPhase(0).getComponent(cc).getz() < 1.0E-100) {
                    nomb = 0.0;
                }
                if (!((SystemInterface)clonedSystem.get(0)).isPhase(1)) continue;
                try {
                    ((SystemInterface)clonedSystem.get(0)).getPhase(1).getComponents()[cc].setx(nomb);
                    continue;
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                }
            }
            int iter = 0;
            double errOld = 1.0E100;
            do {
                int i2;
                errOld = err;
                err = 0.0;
                if (++iter <= 150 || !this.system.isImplementedCompositionDeriativesofFugacity()) {
                    if (iter % 7 == 0) {
                        double vec1 = 0.0;
                        double vec2 = 0.0;
                        double prod1 = 0.0;
                        double prod2 = 0.0;
                        this.i = 0;
                        while (this.i < this.system.getPhase(0).getNumberOfComponents()) {
                            vec1 = oldDeltalogWi[this.i] * oldoldDeltalogWi[this.i];
                            vec2 = Math.pow(oldoldDeltalogWi[this.i], 2.0);
                            prod1 += vec1 * vec2;
                            prod2 += vec2 * vec2;
                            ++this.i;
                        }
                        double lambda = prod1 / prod2;
                        this.i = 0;
                        while (this.i < this.system.getPhase(0).getNumberOfComponents()) {
                            int n = this.i;
                            logWi[n] = logWi[n] + lambda / (1.0 - lambda) * deltalogWi[this.i];
                            err += Math.abs((logWi[this.i] - oldlogw[this.i]) / oldlogw[this.i]);
                            Wi[j][this.i] = Math.exp(logWi[this.i]);
                            ++this.i;
                        }
                    } else {
                        int i3;
                        for (i3 = 0; i3 < this.system.getPhase(0).getNumberOfComponents(); ++i3) {
                            oldoldoldlogw[i3] = oldoldlogw[i3];
                            oldoldlogw[i3] = oldlogw[i3];
                            oldlogw[i3] = logWi[i3];
                            oldoldDeltalogWi[i3] = oldoldlogw[i3] - oldoldoldlogw[i3];
                            oldDeltalogWi[i3] = oldlogw[i3] - oldoldlogw[i3];
                        }
                        ((SystemInterface)clonedSystem.get(0)).init(1, 1);
                        for (i3 = 0; i3 < this.system.getPhase(0).getNumberOfComponents(); ++i3) {
                            if (!Double.isInfinite(((SystemInterface)clonedSystem.get(0)).getPhase(1).getComponents()[i3].getLogFugacityCoefficient()) && this.system.getPhase(0).getComponent(i3).getx() > 1.0E-100) {
                                logWi[i3] = d[i3] - ((SystemInterface)clonedSystem.get(0)).getPhase(1).getComponents()[i3].getLogFugacityCoefficient();
                                if (((SystemInterface)clonedSystem.get(0)).getPhase(1).getComponents()[i3].getIonicCharge() != 0.0) {
                                    logWi[i3] = -1000.0;
                                }
                            }
                            deltalogWi[i3] = logWi[i3] - oldlogw[i3];
                            err += Math.abs(logWi[i3] - oldlogw[i3]);
                            Wi[j][i3] = Math.exp(logWi[i3]);
                        }
                    }
                } else {
                    int i4;
                    SimpleMatrix f = new SimpleMatrix(this.system.getPhases()[0].getNumberOfComponents(), 1);
                    SimpleMatrix df = null;
                    SimpleMatrix identitytimesConst = null;
                    for (i4 = 0; i4 < this.system.getPhase(0).getNumberOfComponents(); ++i4) {
                        oldoldoldlogw[i4] = oldoldlogw[i4];
                        oldoldlogw[i4] = oldlogw[i4];
                        oldlogw[i4] = logWi[i4];
                        oldoldDeltalogWi[i4] = oldoldlogw[i4] - oldoldoldlogw[i4];
                        oldDeltalogWi[i4] = oldlogw[i4] - oldoldlogw[i4];
                    }
                    ((SystemInterface)clonedSystem.get(0)).init(3, 1);
                    alpha = new double[((SystemInterface)clonedSystem.get(0)).getPhases()[0].getNumberOfComponents()];
                    df = new SimpleMatrix(this.system.getPhases()[0].getNumberOfComponents(), this.system.getPhases()[0].getNumberOfComponents());
                    identitytimesConst = SimpleMatrix.identity(this.system.getPhases()[0].getNumberOfComponents());
                    for (i4 = 0; i4 < ((SystemInterface)clonedSystem.get(0)).getPhases()[0].getNumberOfComponents(); ++i4) {
                        alpha[i4] = 2.0 * Math.sqrt(Wi[j][i4]);
                    }
                    for (i4 = 0; i4 < this.system.getPhase(0).getNumberOfComponents(); ++i4) {
                        if (this.system.getPhase(0).getComponent(i4).getz() > 1.0E-100) {
                            f.set(i4, 0, Math.sqrt(Wi[j][i4]) * (Math.log(Wi[j][i4]) + ((SystemInterface)clonedSystem.get(0)).getPhases()[1].getComponents()[i4].getLogFugacityCoefficient() - d[i4]));
                        }
                        for (int k = 0; k < ((SystemInterface)clonedSystem.get(0)).getPhases()[0].getNumberOfComponents(); ++k) {
                            double kronDelt;
                            double d3 = kronDelt = i4 == k ? 1.0 : 0.0;
                            if (this.system.getPhase(0).getComponent(i4).getz() > 1.0E-100) {
                                df.set(i4, k, kronDelt + Math.sqrt(Wi[j][k] * Wi[j][i4]) * ((SystemInterface)clonedSystem.get(0)).getPhases()[1].getComponents()[i4].getdfugdn(k));
                                continue;
                            }
                            df.set(i4, k, 0.0);
                        }
                    }
                    SimpleMatrix dx = (SimpleMatrix)df.plus(identitytimesConst).solve(f).negative();
                    for (int i5 = 0; i5 < this.system.getPhase(0).getNumberOfComponents(); ++i5) {
                        double alphaNew = alpha[i5] + dx.get(i5, 0);
                        Wi[j][i5] = Math.pow(alphaNew / 2.0, 2.0);
                        if (this.system.getPhase(0).getComponent(i5).getz() > 1.0E-100) {
                            logWi[i5] = Math.log(Wi[j][i5]);
                        }
                        if (this.system.getPhase(0).getComponent(i5).getIonicCharge() != 0.0) {
                            logWi[i5] = -1000.0;
                        }
                        err += Math.abs((logWi[i5] - oldlogw[i5]) / oldlogw[i5]);
                    }
                }
                sumw[j] = 0.0;
                for (i2 = 0; i2 < this.system.getPhase(0).getNumberOfComponents(); ++i2) {
                    int n = j;
                    sumw[n] = sumw[n] + Math.exp(logWi[i2]);
                }
                for (i2 = 0; i2 < this.system.getPhase(0).getNumberOfComponents(); ++i2) {
                    if (this.system.getPhase(0).getComponent(i2).getx() > 1.0E-100) {
                        ((SystemInterface)clonedSystem.get(0)).getPhase(1).getComponents()[i2].setx(Math.exp(logWi[i2]) / sumw[j]);
                    }
                    if (this.system.getPhase(0).getComponent(i2).getIonicCharge() == 0.0) continue;
                    ((SystemInterface)clonedSystem.get(0)).getPhase(1).getComponents()[i2].setx(1.0E-50);
                }
            } while ((Math.abs(err) > 1.0E-9 || err > errOld) && iter < 600);
            double xTrivialCheck0 = 0.0;
            double xTrivialCheck1 = 0.0;
            this.tm[j] = 1.0;
            for (int i6 = 0; i6 < this.system.getPhase(1).getNumberOfComponents(); ++i6) {
                if (this.system.getPhase(0).getComponent(i6).getx() > 1.0E-100) {
                    int n = j;
                    this.tm[n] = this.tm[n] - Math.exp(logWi[i6]);
                }
                x[j][i6] = ((SystemInterface)clonedSystem.get(0)).getPhase(1).getComponents()[i6].getx();
                xTrivialCheck0 += Math.abs(x[j][i6] - this.system.getPhase(0).getComponent(i6).getx());
                xTrivialCheck1 += Math.abs(x[j][i6] - this.system.getPhase(1).getComponent(i6).getx());
            }
            if (iter >= 599) {
                // empty if block
            }
            if (Math.abs(xTrivialCheck0) < 1.0E-4 || Math.abs(xTrivialCheck1) < 1.0E-4) {
                this.tm[j] = 10.0;
            }
            if (this.tm[j] < -1.0E-8) break;
        }
        int unstabcomp = 0;
        for (int k = this.system.getPhase(0).getNumberOfComponents() - 1; k >= 0; --k) {
            if (!(this.tm[k] < -1.0E-8) || Double.isNaN(this.tm[k])) continue;
            this.system.addPhase();
            unstabcomp = k;
            for (int i7 = 0; i7 < this.system.getPhase(1).getNumberOfComponents(); ++i7) {
                this.system.getPhase(this.system.getNumberOfPhases() - 1).getComponents()[i7].setx(x[k][i7]);
            }
            this.system.getPhases()[this.system.getNumberOfPhases() - 1].normalize();
            this.multiPhaseTest = true;
            this.system.setBeta(this.system.getNumberOfPhases() - 1, this.system.getPhase(0).getComponent(unstabcomp).getz());
            this.system.init(1);
            this.system.normalizeBeta();
            return;
        }
        this.system.normalizeBeta();
    }

    public void stabilityAnalysis2() {
        int i;
        int k;
        double[] logWi = new double[this.system.getPhase(0).getNumberOfComponents()];
        double[][] Wi = new double[this.system.getPhase(0).getNumberOfComponents()][this.system.getPhase(0).getNumberOfComponents()];
        double[] deltalogWi = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[] oldDeltalogWi = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[] oldoldDeltalogWi = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[] sumw = new double[this.system.getPhase(0).getNumberOfComponents()];
        double err = 0.0;
        double[] oldlogw = new double[this.system.getPhase(0).getNumberOfComponents()];
        double[] oldoldlogw = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[] oldoldoldlogw = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[] d = new double[this.system.getPhase(0).getNumberOfComponents()];
        double[][] x = new double[this.system.getPhase(0).getNumberOfComponents()][this.system.getPhase(0).getNumberOfComponents()];
        this.tm = new double[this.system.getPhase(0).getNumberOfComponents()];
        double[] alpha = null;
        ArrayList<SystemInterface> clonedSystem = new ArrayList<SystemInterface>(1);
        this.minimumGibbsEnergySystem = this.system;
        for (int i2 = 0; i2 < this.system.getPhase(0).getNumberOfComponents(); ++i2) {
            if (this.system.getPhase(0).getComponent(i2).getx() < 1.0E-100) {
                clonedSystem.add(null);
                continue;
            }
            double numb = 0.0;
            clonedSystem.add(this.system.clone());
            for (int j = 0; j < this.system.getPhase(0).getNumberOfComponents(); ++j) {
                double d2 = numb = i2 == j ? 1.0 : 1.0E-12;
                if (this.system.getPhase(0).getComponent(j).getz() < 1.0E-100) {
                    numb = 0.0;
                }
                ((SystemInterface)clonedSystem.get(i2)).getPhase(1).getComponents()[j].setx(numb);
            }
            if (this.system.getPhase(0).getComponent(i2).getIonicCharge() != 0.0) continue;
            ((SystemInterface)clonedSystem.get(i2)).init(1);
        }
        this.lowestGibbsEnergyPhase = 0;
        for (k = 0; k < this.minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents(); ++k) {
            for (int i3 = 0; i3 < this.minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents(); ++i3) {
                if (clonedSystem.get(k) == null) continue;
                int n = k;
                sumw[n] = sumw[n] + ((SystemInterface)clonedSystem.get(k)).getPhase(1).getComponents()[i3].getx();
            }
        }
        for (k = 0; k < this.minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents(); ++k) {
            for (int i4 = 0; i4 < this.minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents(); ++i4) {
                if (clonedSystem.get(k) == null || !(this.system.getPhase(0).getComponent(k).getx() > 1.0E-100)) continue;
                ((SystemInterface)clonedSystem.get(k)).getPhase(1).getComponents()[i4].setx(((SystemInterface)clonedSystem.get(k)).getPhase(1).getComponents()[i4].getx() / sumw[0]);
            }
            if (!(this.system.getPhase(0).getComponent(k).getx() > 1.0E-100)) continue;
            d[k] = Math.log(this.system.getPhase(0).getComponents()[k].getx()) + this.system.getPhase(0).getComponents()[k].getLogFugacityCoefficient();
        }
        for (int j = 0; j < this.minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents(); ++j) {
            logWi[j] = this.system.getPhase(0).getComponent(j).getz() > 1.0E-100 ? 1.0 : -10000.0;
        }
        int hydrocarbonTestCompNumb = 0;
        int lightTestCompNumb = 0;
        double Mmax = 0.0;
        double Mmin = 1.0E10;
        for (i = 0; i < this.minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents(); ++i) {
            if (!this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).isHydrocarbon()) continue;
            if (this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).getMolarMass() > Mmax) {
                Mmax = this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).getMolarMass();
            }
            if (!(this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).getMolarMass() < Mmin)) continue;
            Mmin = this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).getMolarMass();
        }
        for (i = 0; i < this.minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents(); ++i) {
            if (this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).isHydrocarbon() && this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).getz() > 1.0E-50 && Math.abs(this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).getMolarMass() - Mmax) < 1.0E-5) {
                hydrocarbonTestCompNumb = i;
            }
            if (!this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).isHydrocarbon() || !(this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).getz() > 1.0E-50) || !(Math.abs(this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).getMolarMass() - Mmin) < 1.0E-5)) continue;
            lightTestCompNumb = i;
        }
        for (int j = this.system.getPhase(0).getNumberOfComponents() - 1; j >= 0; --j) {
            if (this.minimumGibbsEnergySystem.getPhase(0).getComponent(j).getx() < 1.0E-100 || this.minimumGibbsEnergySystem.getPhase(0).getComponent(j).getIonicCharge() != 0.0 || this.minimumGibbsEnergySystem.getPhase(0).getComponent(j).isHydrocarbon() && j != hydrocarbonTestCompNumb && j != lightTestCompNumb) continue;
            int iter = 0;
            double errOld = 1.0E100;
            do {
                int i5;
                errOld = err;
                err = 0.0;
                if (++iter <= 20 || !this.system.isImplementedCompositionDeriativesofFugacity()) {
                    if (iter % 7 == 0) {
                        double vec1 = 0.0;
                        double vec2 = 0.0;
                        double prod1 = 0.0;
                        double prod2 = 0.0;
                        this.i = 0;
                        while (this.i < this.system.getPhase(0).getNumberOfComponents()) {
                            vec1 = oldDeltalogWi[this.i] * oldoldDeltalogWi[this.i];
                            vec2 = Math.pow(oldoldDeltalogWi[this.i], 2.0);
                            prod1 += vec1 * vec2;
                            prod2 += vec2 * vec2;
                            ++this.i;
                        }
                        double lambda = prod1 / prod2;
                        this.i = 0;
                        while (this.i < this.system.getPhase(0).getNumberOfComponents()) {
                            int n = this.i;
                            logWi[n] = logWi[n] + lambda / (1.0 - lambda) * deltalogWi[this.i];
                            err += Math.abs((logWi[this.i] - oldlogw[this.i]) / oldlogw[this.i]);
                            Wi[j][this.i] = Math.exp(logWi[this.i]);
                            ++this.i;
                        }
                    } else {
                        int i6;
                        for (i6 = 0; i6 < this.system.getPhase(0).getNumberOfComponents(); ++i6) {
                            oldoldoldlogw[i6] = oldoldlogw[i6];
                            oldoldlogw[i6] = oldlogw[i6];
                            oldlogw[i6] = logWi[i6];
                            oldoldDeltalogWi[i6] = oldoldlogw[i6] - oldoldoldlogw[i6];
                            oldDeltalogWi[i6] = oldlogw[i6] - oldoldlogw[i6];
                        }
                        ((SystemInterface)clonedSystem.get(j)).init(1, 1);
                        for (i6 = 0; i6 < this.system.getPhase(0).getNumberOfComponents(); ++i6) {
                            if (!Double.isInfinite(((SystemInterface)clonedSystem.get(j)).getPhase(1).getComponents()[i6].getLogFugacityCoefficient()) && this.system.getPhase(0).getComponent(i6).getx() > 1.0E-100) {
                                logWi[i6] = d[i6] - ((SystemInterface)clonedSystem.get(j)).getPhase(1).getComponents()[i6].getLogFugacityCoefficient();
                                if (((SystemInterface)clonedSystem.get(j)).getPhase(1).getComponents()[i6].getIonicCharge() != 0.0) {
                                    logWi[i6] = -1000.0;
                                }
                            }
                            deltalogWi[i6] = logWi[i6] - oldlogw[i6];
                            err += Math.abs(logWi[i6] - oldlogw[i6]);
                            Wi[j][i6] = Math.exp(logWi[i6]);
                        }
                    }
                } else {
                    int i7;
                    SimpleMatrix f = new SimpleMatrix(this.system.getPhases()[0].getNumberOfComponents(), 1);
                    SimpleMatrix df = null;
                    SimpleMatrix identitytimesConst = null;
                    for (i7 = 0; i7 < this.system.getPhase(0).getNumberOfComponents(); ++i7) {
                        oldoldoldlogw[i7] = oldoldlogw[i7];
                        oldoldlogw[i7] = oldlogw[i7];
                        oldlogw[i7] = logWi[i7];
                        oldoldDeltalogWi[i7] = oldoldlogw[i7] - oldoldoldlogw[i7];
                        oldDeltalogWi[i7] = oldlogw[i7] - oldoldlogw[i7];
                    }
                    ((SystemInterface)clonedSystem.get(j)).init(3, 1);
                    alpha = new double[((SystemInterface)clonedSystem.get(j)).getPhases()[0].getNumberOfComponents()];
                    df = new SimpleMatrix(this.system.getPhases()[0].getNumberOfComponents(), this.system.getPhases()[0].getNumberOfComponents());
                    identitytimesConst = SimpleMatrix.identity(this.system.getPhases()[0].getNumberOfComponents());
                    for (i7 = 0; i7 < ((SystemInterface)clonedSystem.get(j)).getPhases()[0].getNumberOfComponents(); ++i7) {
                        alpha[i7] = 2.0 * Math.sqrt(Wi[j][i7]);
                    }
                    for (i7 = 0; i7 < this.system.getPhase(0).getNumberOfComponents(); ++i7) {
                        if (this.system.getPhase(0).getComponent(i7).getz() > 1.0E-100) {
                            f.set(i7, 0, Math.sqrt(Wi[j][i7]) * (Math.log(Wi[j][i7]) + ((SystemInterface)clonedSystem.get(j)).getPhases()[1].getComponents()[i7].getLogFugacityCoefficient() - d[i7]));
                        }
                        for (int k2 = 0; k2 < ((SystemInterface)clonedSystem.get(j)).getPhases()[0].getNumberOfComponents(); ++k2) {
                            double kronDelt;
                            double d3 = kronDelt = i7 == k2 ? 1.0 : 0.0;
                            if (this.system.getPhase(0).getComponent(i7).getz() > 1.0E-100) {
                                df.set(i7, k2, kronDelt + Math.sqrt(Wi[j][k2] * Wi[j][i7]) * ((SystemInterface)clonedSystem.get(j)).getPhases()[1].getComponents()[i7].getdfugdn(k2));
                                continue;
                            }
                            df.set(i7, k2, 0.0);
                        }
                    }
                    SimpleMatrix dx = (SimpleMatrix)df.plus(identitytimesConst).solve(f).negative();
                    for (int i8 = 0; i8 < this.system.getPhase(0).getNumberOfComponents(); ++i8) {
                        double alphaNew = alpha[i8] + dx.get(i8, 0);
                        Wi[j][i8] = Math.pow(alphaNew / 2.0, 2.0);
                        if (this.system.getPhase(0).getComponent(i8).getz() > 1.0E-100) {
                            logWi[i8] = Math.log(Wi[j][i8]);
                        }
                        if (this.system.getPhase(0).getComponent(i8).getIonicCharge() != 0.0) {
                            logWi[i8] = -1000.0;
                        }
                        err += Math.abs((logWi[i8] - oldlogw[i8]) / oldlogw[i8]);
                    }
                }
                sumw[j] = 0.0;
                for (i5 = 0; i5 < this.system.getPhase(0).getNumberOfComponents(); ++i5) {
                    int n = j;
                    sumw[n] = sumw[n] + Math.exp(logWi[i5]);
                }
                for (i5 = 0; i5 < this.system.getPhase(0).getNumberOfComponents(); ++i5) {
                    if (this.system.getPhase(0).getComponent(i5).getx() > 1.0E-100) {
                        ((SystemInterface)clonedSystem.get(j)).getPhase(1).getComponents()[i5].setx(Math.exp(logWi[i5]) / sumw[j]);
                    }
                    if (this.system.getPhase(0).getComponent(i5).getIonicCharge() == 0.0) continue;
                    ((SystemInterface)clonedSystem.get(j)).getPhase(1).getComponents()[i5].setx(1.0E-50);
                }
            } while ((Math.abs(err) > 1.0E-9 || err > errOld) && iter < 200);
            double xTrivialCheck0 = 0.0;
            double xTrivialCheck1 = 0.0;
            this.tm[j] = 1.0;
            for (int i9 = 0; i9 < this.system.getPhase(1).getNumberOfComponents(); ++i9) {
                if (this.system.getPhase(0).getComponent(i9).getx() > 1.0E-100) {
                    int n = j;
                    this.tm[n] = this.tm[n] - Math.exp(logWi[i9]);
                }
                x[j][i9] = ((SystemInterface)clonedSystem.get(j)).getPhase(1).getComponents()[i9].getx();
                xTrivialCheck0 += Math.abs(x[j][i9] - this.system.getPhase(0).getComponent(i9).getx());
                xTrivialCheck1 += Math.abs(x[j][i9] - this.system.getPhase(1).getComponent(i9).getx());
            }
            if (iter >= 199) {
                logger.info("iter > maxiter multiphase stability ");
                logger.info("error " + Math.abs(err));
                logger.info("tm: " + this.tm[j]);
            }
            if (Math.abs(xTrivialCheck0) < 1.0E-6 || Math.abs(xTrivialCheck1) < 1.0E-6) {
                this.tm[j] = 10.0;
            }
            if (this.tm[j] < -1.0E-8) break;
        }
        int unstabcomp = 0;
        for (int k3 = this.system.getPhase(0).getNumberOfComponents() - 1; k3 >= 0; --k3) {
            if (!(this.tm[k3] < -1.0E-8) || Double.isNaN(this.tm[k3])) continue;
            this.system.addPhase();
            unstabcomp = k3;
            for (int i10 = 0; i10 < this.system.getPhase(1).getNumberOfComponents(); ++i10) {
                this.system.getPhase(this.system.getNumberOfPhases() - 1).getComponents()[i10].setx(x[k3][i10]);
            }
            this.system.getPhases()[this.system.getNumberOfPhases() - 1].normalize();
            this.multiPhaseTest = true;
            this.system.setBeta(this.system.getNumberOfPhases() - 1, this.system.getPhase(0).getComponent(unstabcomp).getz());
            this.system.init(1);
            this.system.normalizeBeta();
            return;
        }
        this.system.normalizeBeta();
    }

    @Override
    public void run() {
        int aqueousPhaseNumber = 0;
        if (this.doStabilityAnalysis) {
            this.stabilityAnalysis();
        }
        this.doStabilityAnalysis = true;
        aqueousPhaseNumber = this.system.getPhaseNumberOfPhase("aqueous");
        if (this.system.isChemicalSystem()) {
            this.system.getChemicalReactionOperations().solveChemEq(this.system.getPhaseNumberOfPhase("aqueous"), 0);
            this.system.getChemicalReactionOperations().solveChemEq(this.system.getPhaseNumberOfPhase("aqueous"), 1);
        }
        int iterations = 0;
        if (this.multiPhaseTest) {
            int i;
            double diff = 1.0E10;
            double oldDiff = 1.0E10;
            double chemdev = 0.0;
            int iterOut = 0;
            do {
                ++iterOut;
                if (this.system.isChemicalSystem()) {
                    if (this.system.getPhaseNumberOfPhase("aqueous") != aqueousPhaseNumber) {
                        aqueousPhaseNumber = this.system.getPhaseNumberOfPhase("aqueous");
                        this.system.getChemicalReactionOperations().solveChemEq(this.system.getPhaseNumberOfPhase("aqueous"), 0);
                    }
                    for (int phase = this.system.getPhaseNumberOfPhase("aqueous"); phase < this.system.getPhaseNumberOfPhase("aqueous") + 1; ++phase) {
                        chemdev = 0.0;
                        double[] xchem = new double[this.system.getPhase(phase).getNumberOfComponents()];
                        this.i = 0;
                        while (this.i < this.system.getPhase(0).getNumberOfComponents()) {
                            xchem[this.i] = this.system.getPhase(phase).getComponents()[this.i].getx();
                            ++this.i;
                        }
                        this.system.init(1);
                        this.system.getChemicalReactionOperations().solveChemEq(this.system.getPhaseNumberOfPhase("aqueous"), 1);
                        this.i = 0;
                        while (this.i < this.system.getPhase(0).getNumberOfComponents()) {
                            chemdev += Math.abs(xchem[this.i] - this.system.getPhase(phase).getComponents()[this.i].getx());
                            ++this.i;
                        }
                    }
                }
                this.setDoubleArrays();
                iterations = 0;
                do {
                    oldDiff = diff;
                } while ((diff = this.solveBeta()) > 1.0E-12 && !this.removePhase && (diff < oldDiff || ++iterations < 50) && iterations < 200);
                if (iterations < 199) continue;
                logger.error("error in multiphase flash..did not solve in 200 iterations");
                diff = this.solveBeta();
            } while (Math.abs(chemdev) > 1.0E-10 && iterOut < 100 || iterOut < 3 && this.system.isChemicalSystem());
            boolean hasRemovedPhase = false;
            for (int i2 = 0; i2 < this.system.getNumberOfPhases(); ++i2) {
                if (!(this.system.getBeta(i2) < 1.1000000000000002E-12)) continue;
                this.system.removePhaseKeepTotalComposition(i2);
                this.doStabilityAnalysis = false;
                hasRemovedPhase = true;
            }
            boolean trivialSolution = false;
            for (i = 0; i < this.system.getNumberOfPhases() - 1; ++i) {
                for (int j = 0; j < this.system.getPhase(i).getNumberOfComponents(); ++j) {
                    if (!(Math.abs(this.system.getPhase(i).getDensity() - this.system.getPhase(i + 1).getDensity()) < 1.1E-5)) continue;
                    trivialSolution = true;
                }
            }
            if (trivialSolution && !hasRemovedPhase) {
                for (i = 0; i < this.system.getNumberOfPhases() - 1; ++i) {
                    if (!(Math.abs(this.system.getPhase(i).getDensity() - this.system.getPhase(i + 1).getDensity()) < 1.1E-5)) continue;
                    this.system.removePhaseKeepTotalComposition(i + 1);
                    this.doStabilityAnalysis = false;
                    hasRemovedPhase = true;
                }
            }
            if (hasRemovedPhase && !this.secondTime) {
                this.secondTime = true;
                this.run();
            }
        }
    }
}

