/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.readwrite;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import neqsim.thermo.phase.PhaseEosInterface;
import neqsim.thermo.system.SystemEos;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemPrEos;
import neqsim.thermo.system.SystemPrEos1978;
import neqsim.thermo.system.SystemSrkEos;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EclipseFluidReadWrite {
    static Logger logger = LogManager.getLogger(EclipseFluidReadWrite.class);
    public static String pseudoName = "";

    public static void setComposition(SystemInterface fluid, String inputFile, String pseudoNameIn) {
        pseudoName = pseudoNameIn;
        EclipseFluidReadWrite.setComposition(fluid, inputFile);
    }

    public static void setComposition(SystemInterface fluid, String inputFile) {
        fluid.setEmptyFluid();
        try (BufferedReader br = new BufferedReader(new FileReader(new File(inputFile)));){
            String st;
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<Double> ZI = new ArrayList<Double>();
            while ((st = br.readLine()) != null) {
                if (st.equals("CNAMES")) {
                    while ((st = br.readLine().replace("/", "")) != null && !st.startsWith("--")) {
                        names.add(st);
                    }
                }
                if (!st.equals("ZI")) continue;
                while ((st = br.readLine().replace("/", "")) != null && !st.startsWith("--")) {
                    ZI.add(Double.parseDouble(st));
                }
            }
            for (int counter = 0; counter < names.size(); ++counter) {
                String name = (String)names.get(counter);
                if (name.equals("C1")) {
                    name = "methane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                    continue;
                }
                if (name.equals("C2")) {
                    name = "ethane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                    continue;
                }
                if (name.equals("N2")) {
                    name = "nitrogen";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                    continue;
                }
                if (name.equals("iC4")) {
                    name = "i-butane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                    continue;
                }
                if (name.equals("C4")) {
                    name = "n-butane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                    continue;
                }
                if (name.equals("iC5")) {
                    name = "i-pentane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                    continue;
                }
                if (name.equals("C5")) {
                    name = "n-pentane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                    continue;
                }
                if (name.equals("C6")) {
                    name = "n-hexane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                    continue;
                }
                if (name.equals("C3")) {
                    name = "propane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                    continue;
                }
                if (name.equals("CO2")) {
                    name = "CO2";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                    continue;
                }
                fluid.addComponent(name + pseudoName, (double)((Double)ZI.get(counter)));
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
    }

    public static SystemInterface read(String inputFile, String pseudoNameIn) {
        pseudoName = pseudoNameIn;
        return EclipseFluidReadWrite.read(inputFile);
    }

    public static SystemInterface read(String inputFile) {
        SystemEos fluid = new SystemSrkEos(288.15, 1.01325);
        double[][] kij = null;
        try (BufferedReader br = new BufferedReader(new FileReader(new File(inputFile)));){
            int i;
            String st;
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<Double> TC = new ArrayList<Double>();
            ArrayList<Double> PC = new ArrayList<Double>();
            ArrayList<Double> ACF = new ArrayList<Double>();
            ArrayList<Double> MW = new ArrayList<Double>();
            ArrayList<Double> SSHIFT = new ArrayList<Double>();
            ArrayList<Double> TBOIL = new ArrayList<Double>();
            ArrayList<Double> VCRIT = new ArrayList<Double>();
            ArrayList<Double> PARACHOR = new ArrayList<Double>();
            ArrayList<Double> ZI = new ArrayList<Double>();
            ArrayList<Double> BIC = new ArrayList<Double>();
            block11: while ((st = br.readLine()) != null) {
                if (st.trim().equals("EOS")) {
                    String EOS = br.readLine().replace("/", "");
                    if (EOS.contains("SRK")) {
                        fluid = new SystemSrkEos(288.15, 100.01325);
                    } else if (EOS.contains("PR")) {
                        fluid = new SystemPrEos(288.15, 1.01325);
                    } else if (EOS.contains("PR78")) {
                        fluid = new SystemPrEos1978(288.15, 1.01325);
                    }
                }
                if (st.equals("CNAMES")) {
                    while ((st = br.readLine().replace("/", "")) != null && !st.startsWith("--")) {
                        names.add(st);
                    }
                }
                if (st.equals("TCRIT")) {
                    while ((st = br.readLine().replace("/", "")) != null && !st.startsWith("--")) {
                        TC.add(Double.parseDouble(st));
                    }
                }
                if (st.equals("PCRIT")) {
                    while ((st = br.readLine().replace("/", "")) != null && !st.startsWith("--")) {
                        PC.add(Double.parseDouble(st));
                    }
                }
                if (st.equals("ACF")) {
                    while ((st = br.readLine().replace("/", "")) != null && !st.startsWith("--")) {
                        ACF.add(Double.parseDouble(st));
                    }
                }
                if (st.equals("MW")) {
                    while ((st = br.readLine().replace("/", "")) != null && !st.startsWith("--")) {
                        MW.add(Double.parseDouble(st));
                    }
                }
                if (st.equals("TBOIL")) {
                    while ((st = br.readLine().replace("/", "")) != null && !st.startsWith("--")) {
                        TBOIL.add(Double.parseDouble(st));
                    }
                }
                if (st.equals("VCRIT")) {
                    while ((st = br.readLine().replace("/", "")) != null && !st.startsWith("--")) {
                        VCRIT.add(Double.parseDouble(st));
                    }
                }
                if (st.equals("SSHIFT")) {
                    while ((st = br.readLine().replace("/", "")) != null && !st.startsWith("--")) {
                        SSHIFT.add(Double.parseDouble(st));
                    }
                }
                if (st.equals("PARACHOR")) {
                    while ((st = br.readLine().replace("/", "")) != null && !st.startsWith("--")) {
                        PARACHOR.add(Double.parseDouble(st));
                    }
                }
                if (st.equals("ZI")) {
                    while ((st = br.readLine().replace("/", "")) != null && !st.startsWith("--")) {
                        ZI.add(Double.parseDouble(st));
                    }
                }
                if (!st.equals("BIC")) continue;
                int numb = 0;
                kij = new double[names.size()][names.size()];
                while ((st = br.readLine().replace("/", "")) != null) {
                    String[] arr;
                    ++numb;
                    if (st.startsWith("--") || (arr = st.split("  ")).length == 1) continue block11;
                    for (i = 0; i < arr.length - 1; ++i) {
                        BIC.add(Double.parseDouble(arr[i + 1]));
                        kij[numb][i] = Double.parseDouble(arr[i + 1]);
                        kij[i][numb] = kij[numb][i];
                    }
                    Double.parseDouble(arr[1]);
                }
            }
            for (int counter = 0; counter < names.size(); ++counter) {
                String name = (String)names.get(counter);
                if (name.equals("C1") || (Double)TC.get(counter) < 0.0) {
                    name = "methane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                } else if (name.equals("C2") || (Double)TC.get(counter) < 0.0) {
                    name = "ethane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                } else if (name.equals("N2") || (Double)TC.get(counter) < 0.0) {
                    name = "nitrogen";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                } else if (name.equals("iC4") || (Double)TC.get(counter) < 0.0) {
                    name = "i-butane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                } else if (name.equals("C4") || (Double)TC.get(counter) < 0.0) {
                    name = "n-butane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                } else if (name.equals("iC5") || (Double)TC.get(counter) < 0.0) {
                    name = "i-pentane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                } else if (name.equals("C5") || (Double)TC.get(counter) < 0.0) {
                    name = "n-pentane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                } else if (name.equals("C6") || (Double)TC.get(counter) < 0.0) {
                    name = "n-hexane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                } else if (name.equals("C3") || (Double)TC.get(counter) < 0.0) {
                    name = "propane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                } else if (name.equals("CO2") || (Double)TC.get(counter) < 0.0) {
                    name = "CO2";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                } else if ((Double)TC.get(counter) >= 0.0) {
                    name = (String)names.get(counter);
                    fluid.addTBPfraction(name, (Double)ZI.get(counter), (Double)MW.get(counter) / 1000.0, 0.9);
                    name = name + "_PC";
                } else {
                    name = (String)names.get(counter);
                    fluid.addTBPfraction(name, (Double)ZI.get(counter), (Double)MW.get(counter) / 1000.0, 0.9);
                    name = name + "_PC";
                }
                for (i = 0; i < fluid.getMaxNumberOfPhases(); ++i) {
                    fluid.getPhase(i).getComponent(name).setTC((Double)TC.get(counter));
                    fluid.getPhase(i).getComponent(name).setPC((Double)PC.get(counter));
                    fluid.getPhase(i).getComponent(name).setAcentricFactor((Double)ACF.get(counter));
                    fluid.getPhase(i).getComponent(name).setMolarMass((Double)MW.get(counter) / 1000.0);
                    fluid.getPhase(i).getComponent(name).setNormalBoilingPoint((Double)TBOIL.get(counter));
                    fluid.getPhase(i).getComponent(name).setCriticalVolume((Double)VCRIT.get(counter));
                    fluid.getPhase(i).getComponent(name).setParachorParameter((Double)PARACHOR.get(counter));
                    fluid.getPhase(i).getComponent(name).setVolumeCorrectionConst((Double)SSHIFT.get(counter));
                }
                if (!fluid.getPhase(0).getComponent(name).isIsTBPfraction()) continue;
                fluid.changeComponentName(name, ((String)names.get(counter)).replaceAll("_PC", "") + pseudoName);
            }
            fluid.setMixingRule(2);
            fluid.useVolumeCorrection(true);
            fluid.init(0);
            for (int i2 = 0; i2 < names.size(); ++i2) {
                for (int j = i2; j < names.size(); ++j) {
                    for (int phase = 0; phase < fluid.getMaxNumberOfPhases(); ++phase) {
                        ((PhaseEosInterface)fluid.getPhase(phase)).getMixingRule().setBinaryInteractionParameter(i2, j, kij[i2][j]);
                        ((PhaseEosInterface)fluid.getPhase(phase)).getMixingRule().setBinaryInteractionParameter(j, i2, kij[i2][j]);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        return fluid;
    }
}

