/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.acentricFactorFitting;

import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardtFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MathiasCopemanToDewPoint
extends LevenbergMarquardtFunction {
    static Logger logger = LogManager.getLogger(MathiasCopemanToDewPoint.class);

    public MathiasCopemanToDewPoint() {
        this.params = new double[3];
    }

    @Override
    public double calcValue(double[] dependentValues) {
        this.system.setPressure(dependentValues[0]);
        this.system.init(0);
        this.system.init(1);
        try {
            this.thermoOps.dewPointTemperatureFlash();
        }
        catch (Exception ex) {
            logger.error(ex.toString());
        }
        return this.system.getTemperature();
    }

    @Override
    public double calcTrueValue(double val) {
        return val;
    }

    @Override
    public void setFittingParams(int i, double value) {
        this.params[i] = value;
        if (this.system.getPhases()[0].getNumberOfComponents() == 1) {
            if (i >= 3) {
                if (i < 6) {
                    i -= 3;
                } else if (i < 9) {
                    i -= 6;
                } else if (i < 12) {
                    i -= 9;
                } else if (i < 15) {
                    i -= 12;
                } else if (i < 18) {
                    i -= 15;
                } else if (i < 21) {
                    i -= 18;
                } else if (i < 24) {
                    i -= 21;
                } else if (i < 27) {
                    i -= 24;
                } else if (i < 30) {
                    i -= 27;
                } else if (i < 33) {
                    i -= 30;
                }
            }
            this.system.getPhases()[1].getComponent(0).setMatiascopemanParams(i, value);
            this.system.getPhases()[0].getComponent(0).getAttractiveTerm().setParameters(i, value);
            this.system.getPhases()[1].getComponent(0).getAttractiveTerm().setParameters(i, value);
            return;
        }
        if (this.system.getPhase(0).hasComponent("methane") && i < 3) {
            this.system.getPhases()[0].getComponent("methane").setMatiascopemanParams(i, value);
            this.system.getPhases()[1].getComponent("methane").setMatiascopemanParams(i, value);
            this.system.getPhases()[0].getComponent("methane").getAttractiveTerm().setParameters(i, value);
            this.system.getPhases()[1].getComponent("methane").getAttractiveTerm().setParameters(i, value);
            return;
        }
        if (this.system.getPhase(0).hasComponent("ethane") && i < 6) {
            this.system.getPhases()[0].getComponent("ethane").setMatiascopemanParams(i - 3, value);
            this.system.getPhases()[1].getComponent("ethane").setMatiascopemanParams(i - 3, value);
            this.system.getPhases()[0].getComponent("ethane").getAttractiveTerm().setParameters(i - 3, value);
            this.system.getPhases()[1].getComponent("ethane").getAttractiveTerm().setParameters(i - 3, value);
            return;
        }
        if (this.system.getPhase(0).hasComponent("propane") && i < 9) {
            this.system.getPhases()[0].getComponent("propane").setMatiascopemanParams(i - 6, value);
            this.system.getPhases()[1].getComponent("propane").setMatiascopemanParams(i - 6, value);
            this.system.getPhases()[0].getComponent("propane").getAttractiveTerm().setParameters(i - 6, value);
            this.system.getPhases()[1].getComponent("propane").getAttractiveTerm().setParameters(i - 6, value);
            return;
        }
        if (this.system.getPhase(0).hasComponent("n-butane") && i < 12) {
            this.system.getPhases()[0].getComponent("n-butane").setMatiascopemanParams(i - 9, value);
            this.system.getPhases()[1].getComponent("n-butane").setMatiascopemanParams(i - 9, value);
            this.system.getPhases()[0].getComponent("n-butane").getAttractiveTerm().setParameters(i - 9, value);
            this.system.getPhases()[1].getComponent("n-butane").getAttractiveTerm().setParameters(i - 9, value);
            return;
        }
        if (this.system.getPhase(0).hasComponent("i-butane") && i < 15) {
            this.system.getPhases()[0].getComponent("i-butane").setMatiascopemanParams(i - 12, value);
            this.system.getPhases()[1].getComponent("i-butane").setMatiascopemanParams(i - 12, value);
            this.system.getPhases()[0].getComponent("i-butane").getAttractiveTerm().setParameters(i - 12, value);
            this.system.getPhases()[1].getComponent("i-butane").getAttractiveTerm().setParameters(i - 12, value);
            return;
        }
        if (this.system.getPhase(0).hasComponent("n-pentane") && i < 18) {
            this.system.getPhases()[0].getComponent("n-pentane").setMatiascopemanParams(i - 15, value);
            this.system.getPhases()[1].getComponent("n-pentane").setMatiascopemanParams(i - 15, value);
            this.system.getPhases()[0].getComponent("n-pentane").getAttractiveTerm().setParameters(i - 15, value);
            this.system.getPhases()[1].getComponent("n-pentane").getAttractiveTerm().setParameters(i - 15, value);
            return;
        }
        if (this.system.getPhase(0).hasComponent("c-hexane") && i < 21) {
            this.system.getPhases()[0].getComponent("c-hexane").setMatiascopemanParams(i - 18, value);
            this.system.getPhases()[1].getComponent("c-hexane").setMatiascopemanParams(i - 18, value);
            this.system.getPhases()[0].getComponent("c-hexane").getAttractiveTerm().setParameters(i - 18, value);
            this.system.getPhases()[1].getComponent("c-hexane").getAttractiveTerm().setParameters(i - 18, value);
            return;
        }
        if (this.system.getPhase(0).hasComponent("benzene") && i < 24) {
            this.system.getPhases()[0].getComponent("benzene").setMatiascopemanParams(i - 21, value);
            this.system.getPhases()[1].getComponent("benzene").setMatiascopemanParams(i - 21, value);
            this.system.getPhases()[0].getComponent("benzene").getAttractiveTerm().setParameters(i - 21, value);
            this.system.getPhases()[1].getComponent("benzene").getAttractiveTerm().setParameters(i - 21, value);
            return;
        }
        if (this.system.getPhase(0).hasComponent("n-heptane") && i < 27) {
            this.system.getPhases()[0].getComponent("n-heptane").setMatiascopemanParams(i - 24, value);
            this.system.getPhases()[1].getComponent("n-heptane").setMatiascopemanParams(i - 24, value);
            this.system.getPhases()[0].getComponent("n-heptane").getAttractiveTerm().setParameters(i - 24, value);
            this.system.getPhases()[1].getComponent("n-heptane").getAttractiveTerm().setParameters(i - 24, value);
        }
    }
}

