/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.HuronVidalParameterFitting;

import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.HuronVidalParameterFitting.BinaryHVparameterFitToActivityCoefficientFunction;

public class TestBinaryHVfitToActivity
implements Cloneable {
    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        int numb = 0;
        while (numb < 20) {
            BinaryHVparameterFitToActivityCoefficientFunction function = new BinaryHVparameterFitToActivityCoefficientFunction();
            SystemSrkEos testSystem = new SystemSrkEos(253.0 + (double)(++numb) * 50.0, 1.01);
            testSystem.addComponent("MDEA", 1.0);
            testSystem.addComponent("water", 10.0);
            testSystem.setMixingRule(4);
            testSystem.init(0);
            double[] parameterGuess = new double[]{320.0, -40.0, -5.89, 8.9, 0.3475};
            function.setInitialGuess(parameterGuess);
            double[] sample1 = new double[]{(double)numb / 1000.0, testSystem.getTemperature()};
            double[] standardDeviation1 = new double[]{1.0};
            SampleValue sample = new SampleValue(0.001, 0.001, sample1, standardDeviation1);
            sample.setFunction(function);
            sample.setThermodynamicSystem(testSystem);
            sampleList.add(sample);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.displayCurveFit();
        optim.writeToTextFile("c:/testFit.txt");
    }
}

