/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.HuronVidalParameterFitting;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkCPAstatoil;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.HuronVidalParameterFitting.BinaryHVParameterFittingToSolubilityData;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestBinaryHVParameterFittingToSolubilityData_Lucia {
    static Logger logger = LogManager.getLogger(TestBinaryHVParameterFittingToSolubilityData_Lucia.class);

    public static void main(String[] args) {
        double[] parameterGuess;
        SampleValue sample;
        double sdev;
        double val;
        double[] standardDeviation1;
        double[] sample1;
        SystemSrkCPAstatoil testSystem;
        BinaryHVParameterFittingToSolubilityData function;
        int p2;
        Throwable throwable;
        ResultSet dataSet;
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        try {
            dataSet = database.getResultSet("SELECT * FROM LuciaData8 WHERE Component='methane' AND Temperature<520 AND L2<>NULL AND L2>0.0000000001 ORDER BY Temperature,Pressure");
            throwable = null;
            try {
                logger.info("adding....");
                for (p2 = 0; dataSet.next() && p2 < 150; ++p2) {
                    function = new BinaryHVParameterFittingToSolubilityData(1, 1);
                    testSystem = new SystemSrkCPAstatoil(Double.parseDouble(dataSet.getString("Temperature")), Double.parseDouble(dataSet.getString("Pressure")) / 100000.0);
                    testSystem.addComponent("methane", 10.0);
                    testSystem.addComponent("water", 100.0);
                    testSystem.setMixingRule(4);
                    testSystem.init(0);
                    sample1 = new double[]{testSystem.getPressure(), testSystem.getTemperature()};
                    standardDeviation1 = new double[]{0.01};
                    val = Double.parseDouble(dataSet.getString("L2"));
                    sdev = val / 100.0;
                    sample = new SampleValue(val, sdev, sample1, standardDeviation1);
                    sample.setFunction(function);
                    sample.setThermodynamicSystem(testSystem);
                    sample.setReference(Double.toString(testSystem.getTemperature()));
                    parameterGuess = new double[]{6114.2013874102, -188.264597921, -10.7239107857559, 2.310651690177652};
                    function.setInitialGuess(parameterGuess);
                    sampleList.add(sample);
                    logger.info("liq points " + p2);
                }
            }
            catch (Throwable p2) {
                throwable = p2;
                throw p2;
            }
            finally {
                if (dataSet != null) {
                    if (throwable != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable p2) {
                            throwable.addSuppressed(p2);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        try {
            dataSet = database.getResultSet("SELECT * FROM LuciaData8 WHERE Component='methane' AND ID<3000 AND Temperature<520 AND Y<>NULL AND Y>0.0000000001 ORDER BY Temperature,Pressure");
            throwable = null;
            try {
                logger.info("adding....");
                for (p2 = 0; dataSet.next() && p2 < 150; ++p2) {
                    function = new BinaryHVParameterFittingToSolubilityData(0, 0);
                    testSystem = new SystemSrkCPAstatoil(Double.parseDouble(dataSet.getString("Temperature")), Double.parseDouble(dataSet.getString("Pressure")) / 100000.0);
                    testSystem.addComponent("methane", 10.0);
                    testSystem.addComponent("water", 10.0);
                    testSystem.setMixingRule(4);
                    testSystem.init(0);
                    sample1 = new double[]{testSystem.getPressure(), testSystem.getTemperature()};
                    standardDeviation1 = new double[]{0.01};
                    val = 1.0 - Double.parseDouble(dataSet.getString("Y"));
                    sdev = val / 100.0;
                    sample = new SampleValue(val, sdev, sample1, standardDeviation1);
                    sample.setFunction(function);
                    sample.setThermodynamicSystem(testSystem);
                    sample.setReference(Double.toString(testSystem.getTemperature()));
                    parameterGuess = new double[]{6114.2013874102, -188.264597921, -10.7239107857559, 2.310651690177652};
                    function.setInitialGuess(parameterGuess);
                    sample.setDescription(Double.toString(testSystem.getTemperature()));
                    sampleList.add(sample);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet != null) {
                    if (throwable != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayCurveFit();
        optim.displayResult();
    }
}

