/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.EosInteractionParameterFitting;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardtFunction;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.EosInteractionParameterFitting.CPAParameterFittingToSolubilityData;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.EosInteractionParameterFitting.CPAParameterFittingToSolubilityData_Vap;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestCPAParameterFittingToSolubilityGlycolHC {
    static Logger logger = LogManager.getLogger(TestCPAParameterFittingToSolubilityGlycolHC.class);

    public static void main(String[] args) {
        SampleValue sample;
        double sdev;
        double val;
        double[] standardDeviation1;
        double[] sample1;
        SystemSrkEos testSystem;
        LevenbergMarquardtFunction function;
        int p2;
        Throwable throwable;
        ResultSet dataSet;
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        double[] parameterGuess = new double[]{1924.0, 4938.0};
        try {
            dataSet = database.getResultSet("SELECT * FROM hcglycollldata WHERE comp1='n-heptane' AND comp2='MEG' AND reference='Lindboe2002' ORDER BY Temperature,Pressure");
            throwable = null;
            try {
                logger.info("adding....");
                for (p2 = 0; !dataSet.next() && p2 < 50; ++p2) {
                    function = new CPAParameterFittingToSolubilityData();
                    testSystem = new SystemSrkEos(Double.parseDouble(dataSet.getString("temperature")) + 273.15, Double.parseDouble(dataSet.getString("pressure")));
                    testSystem.addComponent("n-heptane", 1.0);
                    testSystem.addComponent("MEG", 10.0);
                    testSystem.setMixingRule(4);
                    testSystem.init(0);
                    sample1 = new double[]{testSystem.getTemperature()};
                    standardDeviation1 = new double[]{0.01};
                    val = Double.parseDouble(dataSet.getString("x-glyinhc"));
                    sdev = val / 100.0;
                    sample = new SampleValue(val, sdev, sample1, standardDeviation1);
                    sample.setFunction(function);
                    sample.setThermodynamicSystem(testSystem);
                    sample.setReference(Double.toString(testSystem.getTemperature()));
                    function.setInitialGuess(parameterGuess);
                    sampleList.add(sample);
                }
            }
            catch (Throwable p2) {
                throwable = p2;
                throw p2;
            }
            finally {
                if (dataSet != null) {
                    if (throwable != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable p2) {
                            throwable.addSuppressed(p2);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        try {
            dataSet = database.getResultSet("SELECT * FROM HCGlycolLLdata WHERE comp1='n-heptane' AND comp2='MEG' AND reference='Lindboe2002' ORDER BY Temperature,Pressure");
            throwable = null;
            try {
                logger.info("adding....");
                for (p2 = 0; !dataSet.next() && p2 < 50; ++p2) {
                    function = new CPAParameterFittingToSolubilityData_Vap();
                    testSystem = new SystemSrkEos(Double.parseDouble(dataSet.getString("temperature")) + 273.15, Double.parseDouble(dataSet.getString("pressure")));
                    testSystem.addComponent("n-heptane", 1.0);
                    testSystem.addComponent("MEG", 10.0);
                    testSystem.init(0);
                    testSystem.setMixingRule(4);
                    sample1 = new double[]{testSystem.getTemperature()};
                    standardDeviation1 = new double[]{0.01};
                    val = Double.parseDouble(dataSet.getString("x-hcinglyc"));
                    sdev = val / 100.0;
                    sample = new SampleValue(val, sdev, sample1, standardDeviation1);
                    sample.setFunction(function);
                    sample.setThermodynamicSystem(testSystem);
                    sample.setReference(Double.toString(testSystem.getTemperature()));
                    function.setInitialGuess(parameterGuess);
                    sampleList.add(sample);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet != null) {
                    if (throwable != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayCurveFit();
        optim.writeToTextFile("c:/testFit.txt");
    }
}

