/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.Procede.WaterMDEA;

import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardtFunction;
import neqsim.thermo.mixingRule.HVmixingRuleInterface;
import neqsim.thermo.phase.PhaseEosInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BinaryHVParameterFittingFunction_MDEA
extends LevenbergMarquardtFunction {
    int type = 0;
    int phase = 0;
    static Logger logger = LogManager.getLogger(BinaryHVParameterFittingFunction_MDEA.class);

    public BinaryHVParameterFittingFunction_MDEA() {
    }

    public BinaryHVParameterFittingFunction_MDEA(int phase, int type) {
        this.phase = phase;
        this.type = type;
    }

    @Override
    public double calcValue(double[] dependentValues) {
        if (this.type == 0) {
            try {
                this.thermoOps.bubblePointPressureFlash(false);
            }
            catch (Exception ex) {
                logger.error(ex.toString());
            }
            return this.system.getPressure();
        }
        if (this.type == 1) {
            this.system.init(0);
            this.system.init(1);
            return this.system.getPhases()[1].getActivityCoefficient(0);
        }
        if (this.type == 2) {
            this.system.init(0);
            this.system.init(1);
            double aMDEAold = this.system.getPhase(1).getActivityCoefficient(1);
            double aWaterold = this.system.getPhase(1).getActivityCoefficient(0);
            this.system.setTemperature(this.system.getTemperature() + 1.0E-5);
            this.system.init(0);
            this.system.init(1);
            double aMDEAnew = this.system.getPhase(1).getActivityCoefficient(1);
            double aWaternew = this.system.getPhase(1).getActivityCoefficient(0);
            double daMDEAdT = (Math.log(aMDEAnew) - Math.log(aMDEAold)) / 1.0E-5;
            double daWaterdT = (Math.log(aWaternew) - Math.log(aWaterold)) / 1.0E-5;
            this.system.setTemperature(this.system.getTemperature() - 1.0E-5);
            double H = -8.314 * this.system.getTemperature() * this.system.getTemperature() * (this.system.getPhase(1).getComponent(0).getx() * daWaterdT + this.system.getPhase(1).getComponent(1).getx() * daMDEAdT);
            return H;
        }
        if (this.type == 3) {
            this.system.init(0);
            this.system.init(1);
            return this.system.getPhase(1).getActivityCoefficient(0);
        }
        if (this.type == 4) {
            this.system.init(0);
            this.system.init(1);
            return this.system.getPhase(1).getActivityCoefficient(1);
        }
        return 0.0;
    }

    @Override
    public double calcTrueValue(double val) {
        return val;
    }

    @Override
    public void setFittingParams(int i, double value) {
        this.params[i] = value;
        if (i == 0) {
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[0]).getMixingRule()).setHVDijParameter(0, 1, value);
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[1]).getMixingRule()).setHVDijParameter(0, 1, value);
        }
        if (i == 1) {
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[0]).getMixingRule()).setHVDijParameter(1, 0, value);
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[1]).getMixingRule()).setHVDijParameter(1, 0, value);
        }
        if (i == 4) {
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[0]).getMixingRule()).setHValphaParameter(0, 1, value);
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[1]).getMixingRule()).setHValphaParameter(0, 1, value);
        }
        if (i == 2) {
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[0]).getMixingRule()).setHVDijTParameter(0, 1, value);
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[1]).getMixingRule()).setHVDijTParameter(0, 1, value);
        }
        if (i == 3) {
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[0]).getMixingRule()).setHVDijTParameter(1, 0, value);
            ((HVmixingRuleInterface)((PhaseEosInterface)this.system.getPhases()[1]).getMixingRule()).setHVDijTParameter(1, 0, value);
        }
    }
}

