/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.Procede.CH4MDEA;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkSchwartzentruberEos;
import neqsim.thermo.util.parameterFitting.Procede.CH4MDEA.BinaryHVParameterFittingFunction_CH4;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestBinaryHVParameterFittingToEquilibriumData_CH4 {
    static Logger logger = LogManager.getLogger(TestBinaryHVParameterFittingToEquilibriumData_CH4.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM CH4MDEA");
        double[] guess = new double[]{500.0, -500.0, 1.0E-10, 1.0E-10, 0.3};
        try {
            while (dataSet.next()) {
                BinaryHVParameterFittingFunction_CH4 function = new BinaryHVParameterFittingFunction_CH4();
                function.setInitialGuess(guess);
                int ID = dataSet.getInt("ID");
                double temperature = Double.parseDouble(dataSet.getString("Temperature"));
                double pressure = Double.parseDouble(dataSet.getString("Pressure"));
                double x1 = Double.parseDouble(dataSet.getString("x1"));
                double x2 = Double.parseDouble(dataSet.getString("x2"));
                double x3 = Double.parseDouble(dataSet.getString("x3"));
                SystemSrkSchwartzentruberEos testSystem = new SystemSrkSchwartzentruberEos(temperature, pressure);
                testSystem.addComponent("methane", x1);
                testSystem.addComponent("water", x2);
                testSystem.addComponent("MDEA", x3);
                testSystem.createDatabase(true);
                testSystem.setMixingRule(4);
                testSystem.init(0);
                double[] sample1 = new double[]{temperature};
                double[] standardDeviation1 = new double[]{temperature / 100.0};
                SampleValue sample = new SampleValue(pressure, pressure / 100.0, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sample.setReference(Double.toString(ID));
                sampleList.add(sample);
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.displayCurveFit();
    }
}

