/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.Procede.CH4CO2WaterMDEA;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemFurstElectrolyteEos;
import neqsim.thermo.util.parameterFitting.Procede.CH4CO2WaterMDEA.IonicInteractionParameterFittingFunctionCH4;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestIonicInteractionParameterFittingCH4 {
    static Logger logger = LogManager.getLogger(TestIonicInteractionParameterFittingCH4.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM CO2CH4MDEA");
        double[] guess = new double[]{4.929757E-4, 1.0E-10};
        try {
            int i = 0;
            logger.info("adding....");
            while (dataSet.next()) {
                ++i;
                IonicInteractionParameterFittingFunctionCH4 function = new IonicInteractionParameterFittingFunctionCH4();
                IonicInteractionParameterFittingFunctionCH4 function1 = new IonicInteractionParameterFittingFunctionCH4(1, 1);
                double ID = Integer.parseInt(dataSet.getString("ID"));
                double pressure = Double.parseDouble(dataSet.getString("Pressure"));
                double temperature = Double.parseDouble(dataSet.getString("Temperature"));
                double x1 = Double.parseDouble(dataSet.getString("x1"));
                double x2 = Double.parseDouble(dataSet.getString("x2"));
                double x3 = Double.parseDouble(dataSet.getString("x3"));
                double x4 = Double.parseDouble(dataSet.getString("x4"));
                double y1 = Double.parseDouble(dataSet.getString("y1"));
                double y2 = Double.parseDouble(dataSet.getString("y2"));
                double y3 = Double.parseDouble(dataSet.getString("y3"));
                double y4 = Double.parseDouble(dataSet.getString("y4"));
                double loading = x2 / x4;
                SystemFurstElectrolyteEos testSystem = new SystemFurstElectrolyteEos(temperature, pressure);
                testSystem.addComponent("methane", x1);
                testSystem.addComponent("CO2", x2);
                testSystem.addComponent("MDEA", x4);
                testSystem.addComponent("water", x3);
                testSystem.chemicalReactionInit();
                testSystem.createDatabase(true);
                testSystem.setMixingRule(4);
                testSystem.init(0);
                double[] sample1 = new double[]{loading};
                double[] standardDeviation1 = new double[]{0.01};
                SampleValue sample = new SampleValue(pressure, pressure / 100.0, sample1, standardDeviation1);
                function.setInitialGuess(guess);
                sample.setFunction(function);
                sample.setReference("addicks");
                sample.setDescription(Double.toString(ID));
                sample.setThermodynamicSystem(testSystem);
                sampleList.add(sample);
                double[] sample2 = new double[]{loading};
                double[] standardDeviation2 = new double[]{0.01};
                SampleValue sample3 = new SampleValue(pressure * y2, y2 * pressure / 100.0, sample2, standardDeviation2);
                function1.setInitialGuess(guess);
                sample3.setFunction(function1);
                sample3.setReference("addicks");
                sample3.setDescription(Double.toString(ID));
                sample3.setThermodynamicSystem(testSystem);
                sampleList.add(sample3);
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayCurveFit();
    }
}

