/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import neqsim.thermo.phase.PhaseHydrate;
import neqsim.thermo.phase.PhasePrEos;
import neqsim.thermo.phase.PhasePureComponentSolid;
import neqsim.thermo.system.SystemEos;

public class SystemPrEos1978
extends SystemEos {
    private static final long serialVersionUID = 1000L;

    public SystemPrEos1978() {
        this.modelName = "PR1978-EOS";
        this.getCharacterization().setTBPModel("PedersenPR");
        this.attractiveTermNumber = 13;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhasePrEos();
            this.phaseArray[i].setTemperature(298.15);
            this.phaseArray[i].setPressure(1.0);
        }
    }

    public SystemPrEos1978(double T, double P) {
        super(T, P);
        this.modelName = "PR1978-EOS";
        this.getCharacterization().setTBPModel("PedersenPR");
        this.attractiveTermNumber = 13;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhasePrEos();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
    }

    public SystemPrEos1978(double T, double P, boolean solidCheck) {
        this(T, P);
        this.attractiveTermNumber = 13;
        this.setNumberOfPhases(5);
        this.modelName = "PR1978-EOS";
        this.solidPhaseCheck = solidCheck;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhasePrEos();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
        if (this.solidPhaseCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhasePureComponentSolid();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
        if (this.hydrateCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhaseHydrate();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
    }

    @Override
    public SystemPrEos1978 clone() {
        SystemPrEos1978 clonedSystem = null;
        try {
            clonedSystem = (SystemPrEos1978)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedSystem;
    }
}

