/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import neqsim.thermo.phase.PhaseGENRTL;
import neqsim.thermo.phase.PhasePureComponentSolid;
import neqsim.thermo.phase.PhaseSrkEos;
import neqsim.thermo.system.SystemEos;

public class SystemNRTL
extends SystemEos {
    private static final long serialVersionUID = 1000L;

    public SystemNRTL() {
        this.modelName = "NRTL-GE-model";
        this.attractiveTermNumber = 0;
        this.phaseArray[0] = new PhaseSrkEos();
        for (int i = 1; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseGENRTL();
        }
    }

    public SystemNRTL(double T, double P) {
        super(T, P);
        this.attractiveTermNumber = 0;
        this.modelName = "NRTL-GE-model";
        this.phaseArray[0] = new PhaseSrkEos();
        this.phaseArray[0].setTemperature(T);
        this.phaseArray[0].setPressure(P);
        for (int i = 1; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseGENRTL();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
    }

    public SystemNRTL(double T, double P, boolean solidCheck) {
        this(T, P);
        this.attractiveTermNumber = 0;
        this.setNumberOfPhases(4);
        this.modelName = "NRTL-GE-model";
        this.solidPhaseCheck = solidCheck;
        this.phaseArray[0] = new PhaseSrkEos();
        this.phaseArray[0].setTemperature(T);
        this.phaseArray[0].setPressure(P);
        for (int i = 1; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseGENRTL();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
        if (this.solidPhaseCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhasePureComponentSolid();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
    }

    @Override
    public SystemNRTL clone() {
        SystemNRTL clonedSystem = null;
        try {
            clonedSystem = (SystemNRTL)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedSystem;
    }
}

