/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import neqsim.thermo.phase.PhaseElectrolyteCPAstatoil;
import neqsim.thermo.system.SystemFurstElectrolyteEos;
import neqsim.thermo.util.constants.FurstElectrolyteConstants;

public class SystemElectrolyteCPAstatoil
extends SystemFurstElectrolyteEos {
    private static final long serialVersionUID = 1000L;

    public SystemElectrolyteCPAstatoil() {
        this.modelName = "Electrolyte-CPA-EOS-statoil";
        this.attractiveTermNumber = 15;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseElectrolyteCPAstatoil();
        }
        FurstElectrolyteConstants.setFurstParams("electrolyteCPA");
        this.useVolumeCorrection(true);
    }

    public SystemElectrolyteCPAstatoil(double T, double P) {
        super(T, P);
        this.attractiveTermNumber = 15;
        this.modelName = "Electrolyte-CPA-EOS-statoil";
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseElectrolyteCPAstatoil();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
        FurstElectrolyteConstants.setFurstParams("electrolyteCPA");
        this.useVolumeCorrection(true);
    }

    @Override
    public SystemElectrolyteCPAstatoil clone() {
        SystemElectrolyteCPAstatoil clonedSystem = null;
        try {
            clonedSystem = (SystemElectrolyteCPAstatoil)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedSystem;
    }
}

