/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.component.ComponentPRvolcor;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.phase.PhasePrEos;

public class PhasePrEosvolcor
extends PhasePrEos {
    private static final long serialVersionUID = 1000L;
    double loc_C = 0.0;
    private double CT;
    public double C;
    public double Ctot = 0.0;

    public PhasePrEosvolcor() {
        this.thermoPropertyModelName = "PR-EoS-volcorr";
    }

    @Override
    public void init(double totalNumberOfMoles, int numberOfComponents, int type, int phase, double beta) {
        super.init(totalNumberOfMoles, numberOfComponents, type, phase, beta);
        this.loc_C = this.calcC(this, this.temperature, this.pressure, numberOfComponents);
        this.CT = this.calcCT(this, this.temperature, this.pressure, numberOfComponents);
    }

    public double getCT() {
        return this.CT;
    }

    public double getCTT() {
        return 0.0;
    }

    @Override
    public double calcg() {
        return Math.log(1.0 - (this.getb() - this.getc()) / this.molarVolume);
    }

    @Override
    public double calcf() {
        return 1.0 / (8.3144621 * this.getB() * (this.delta1 - this.delta2)) * Math.log((1.0 + (this.delta1 * this.getb() + this.getc()) / this.molarVolume) / (1.0 + (this.delta2 * this.getb() + this.getc()) / this.molarVolume));
    }

    @Override
    public double dFdV() {
        return -this.numberOfMolesInPhase * this.gV() - this.getA() / this.temperature * this.fv();
    }

    public double getcij(ComponentEosInterface compArray, ComponentEosInterface compArray2) {
        return (((ComponentPRvolcor)compArray).getc() + ((ComponentPRvolcor)compArray2).getc()) * 0.5;
    }

    public double getcijT(ComponentEosInterface compArray, ComponentEosInterface compArray2) {
        return (((ComponentPRvolcor)compArray).getcT() + ((ComponentPRvolcor)compArray2).getcT()) * 0.5;
    }

    public double getcijTT(ComponentPRvolcor compi, ComponentPRvolcor compj) {
        return 0.0;
    }

    public double calcCi(int compNumb, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        double Ci = 0.0;
        ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
        for (int j = 0; j < numbcomp; ++j) {
            Ci += compArray[j].getNumberOfMolesInPhase() * this.getcij(compArray[compNumb], compArray[j]);
        }
        Ci = (2.0 * Ci - this.getC()) / phase.getNumberOfMolesInPhase();
        return Ci;
    }

    public double calcCij(int compNumb, int compNumbj, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        double cij = 0.0;
        ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
        cij = this.getcij(compArray[compNumb], compArray[compNumbj]);
        return (2.0 * cij - ((ComponentPRvolcor)compArray[compNumb]).getCi() - ((ComponentPRvolcor)compArray[compNumbj]).getCi()) / phase.getNumberOfMolesInPhase();
    }

    public double calcCiT(int compNumb, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        double CiT = 0.0;
        ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
        for (int j = 0; j < numbcomp; ++j) {
            CiT += compArray[j].getNumberOfMolesInPhase() * this.getcijT(compArray[compNumb], compArray[j]);
        }
        CiT = (2.0 * CiT - this.getCT()) / phase.getNumberOfMolesInPhase();
        return CiT;
    }

    public double calcCT(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        return 0.0;
    }

    public double calcC(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        this.C = 0.0;
        ComponentEosInterface[] compArray = (ComponentEosInterface[])phase.getcomponentArray();
        for (int i = 0; i < numbcomp; ++i) {
            for (int j = 0; j < numbcomp; ++j) {
                this.C += compArray[i].getNumberOfMolesInPhase() * compArray[j].getNumberOfMolesInPhase() * this.getcij(compArray[i], compArray[j]);
            }
        }
        this.C /= phase.getNumberOfMolesInPhase();
        this.Ctot = this.C;
        return this.C;
    }

    private double loc_C() {
        return this.calcC(this, this.temperature, this.pressure, this.numberOfComponents);
    }

    public double getc() {
        return this.loc_C() / this.numberOfMolesInPhase;
    }

    public double getC() {
        return this.loc_C();
    }

    @Override
    public double gV() {
        return (this.getb() - this.getc()) / (this.molarVolume * (this.numberOfMolesInPhase * this.molarVolume + this.loc_C() - this.getB()));
    }

    @Override
    public double gVV() {
        double val1 = this.numberOfMolesInPhase * this.getMolarVolume();
        double val2 = val1 + this.getC() - this.getB();
        return -1.0 / (val2 * val2) + 1.0 / (val1 * val1);
    }

    @Override
    public double gVVV() {
        double val1 = this.numberOfMolesInPhase * this.getMolarVolume();
        double val2 = val1 + this.getC() - this.getB();
        return 2.0 / (val2 * val2 * val2) - 2.0 / (val1 * val1 * val1);
    }

    @Override
    public double fv() {
        return -1.0 / (8.3144621 * (this.numberOfMolesInPhase * this.molarVolume + this.delta1 * this.getB() + this.loc_C()) * (this.numberOfMolesInPhase * this.molarVolume + this.delta2 * this.getB() + this.loc_C()));
    }

    @Override
    public double fVV() {
        double val1 = this.numberOfMolesInPhase * this.molarVolume + this.delta1 * this.getB() + this.loc_C();
        double val2 = this.numberOfMolesInPhase * this.molarVolume + this.delta2 * this.getB() + this.loc_C();
        return 1.0 / (8.3144621 * this.getB() * (this.delta1 - this.delta2)) * (-1.0 / (val1 * val1) + 1.0 / (val2 * val2));
    }

    @Override
    public double fVVV() {
        double val1 = this.numberOfMolesInPhase * this.molarVolume + this.getB() * this.delta1 + this.getC();
        double val2 = this.numberOfMolesInPhase * this.molarVolume + this.getB() * this.delta2 + this.getC();
        return 1.0 / (8.3144621 * this.getB() * (this.delta1 - this.delta2)) * (2.0 / (val1 * val1 * val1) - 2.0 / (val2 * val2 * val2));
    }

    @Override
    public double gb() {
        return -1.0 / (this.numberOfMolesInPhase * this.molarVolume - this.getB() + this.getC());
    }

    public double gc() {
        return 1.0 / (this.numberOfMolesInPhase * this.molarVolume - this.getB() + this.getC());
    }

    public double fc() {
        return -1.0 / (8.3144621 * (this.numberOfMolesInPhase * this.molarVolume + this.delta1 * this.getB() + this.loc_C()) * (this.numberOfMolesInPhase * this.molarVolume + this.delta2 * this.getB() + this.loc_C()));
    }

    @Override
    public double fb() {
        return -(this.calcf() + (this.numberOfMolesInPhase * this.molarVolume + this.getC()) * this.fv()) / this.getB();
    }

    public double fcc() {
        return this.fVV();
    }

    public double fbc() {
        return this.fBV();
    }

    public double fcv() {
        return this.fVV();
    }

    @Override
    public double fBV() {
        return -(2.0 * this.fv() + (this.numberOfMolesInPhase * this.molarVolume + this.getC()) * this.fVV()) / this.getB();
    }

    @Override
    public double fBB() {
        return -(2.0 * this.fb() + (this.numberOfMolesInPhase * this.molarVolume + this.getC()) * this.fBV()) / this.getB();
    }

    @Override
    public double gBV() {
        double val = this.numberOfMolesInPhase * this.getMolarVolume() - this.getB() + this.getC();
        return 1.0 / (val * val);
    }

    @Override
    public double gBB() {
        double val = this.numberOfMolesInPhase * this.getMolarVolume() - this.getB() + this.getC();
        return -1.0 / (val * val);
    }

    public double gBC() {
        double val = this.numberOfMolesInPhase * this.getMolarVolume() - this.getB() + this.getC();
        return 1.0 / (val * val);
    }

    public double gCV() {
        double val = this.numberOfMolesInPhase * this.getMolarVolume() - this.getB() + this.getC();
        return -1.0 / (val * val);
    }

    public double gCC() {
        double val = this.numberOfMolesInPhase * this.getMolarVolume() - this.getB() + this.getC();
        return -1.0 / (val * val);
    }

    @Override
    public double F() {
        return super.F();
    }

    public double FC() {
        return -this.numberOfMolesInPhase * this.gc() - this.getA() / this.temperature * this.fc();
    }

    public double FnC() {
        return -this.gc();
    }

    public double FTC() {
        return this.getA() * this.fc() / this.temperature / this.temperature;
    }

    public double FBC() {
        return -this.numberOfMolesInPhase * this.gBC() - this.getA() * this.fbc() / this.temperature;
    }

    public double FCV() {
        return -this.numberOfMolesInPhase * this.gCV() - this.getA() * this.fcv() / this.temperature;
    }

    public double FCC() {
        return -this.numberOfMolesInPhase * this.gCC() - this.getA() * this.fcc() / this.temperature;
    }

    public double FCD() {
        return -this.fc() / this.temperature;
    }

    @Override
    public double dFdVdV() {
        return -this.numberOfMolesInPhase * this.gVV() - this.getA() * this.fVV() / this.temperature;
    }

    @Override
    public double dFdVdVdV() {
        return -this.numberOfMolesInPhase * this.gVVV() - this.getA() * this.fVVV() / this.temperature;
    }

    @Override
    public double dFdTdV() {
        return this.FTV() + this.FDV() * this.getAT() + this.FCV() * this.getCT();
    }

    @Override
    public double dFdT() {
        return this.FT() + this.FD() * this.getAT() + this.FC() * this.getCT();
    }

    @Override
    public double dFdTdT() {
        return this.FTT() + 2.0 * this.FDT() * this.getAT() + this.FD() * this.getATT() + 2.0 * this.FTC() * this.getCT() + this.FCC() * this.getCT() * this.getCT() + this.FC() * this.getCTT() + 2.0 * this.FCD() * this.getCT() * this.getAT();
    }

    @Override
    public PhasePrEosvolcor clone() {
        PhasePrEosvolcor clonedPhase = null;
        try {
            clonedPhase = (PhasePrEosvolcor)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedPhase;
    }

    @Override
    public void addcomponent(String componentName, double moles, double molesInPhase, int compNumber) {
        super.addcomponent(molesInPhase);
        this.componentArray[compNumber] = new ComponentPRvolcor(componentName, moles, molesInPhase, compNumber);
    }
}

