/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component.attractiveEosTerm;

import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermPr;

public class AttractiveTermGERG
extends AttractiveTermPr {
    private static final long serialVersionUID = 1000L;
    protected double[] parametersGERG = new double[]{0.905436, -0.213781, 0.26005};
    protected double[] parametersSolidGERG = new double[]{0.106025, 2.683845, -4.75638};

    public AttractiveTermGERG(ComponentEosInterface component) {
        super(component);
        if (component.getName().equals("water")) {
            System.arraycopy(component.getMatiascopemanParams(), 0, this.parameters, 0, component.getMatiascopemanParams().length);
            System.arraycopy(component.getMatiascopemanSolidParams(), 0, this.parametersSolid, 0, component.getMatiascopemanSolidParams().length);
        }
    }

    public Object AttractiveTermGERG() {
        AttractiveTermGERG attractiveTerm = null;
        try {
            attractiveTerm = (AttractiveTermGERG)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return attractiveTerm;
    }

    @Override
    public double alpha(double temperature) {
        if (this.getComponent().getName().equals("water")) {
            if (temperature < 273.15) {
                System.arraycopy(this.parametersSolidGERG, 0, this.parameters, 0, this.parametersSolidGERG.length);
            } else {
                System.arraycopy(this.parametersGERG, 0, this.parameters, 0, this.parametersGERG.length);
            }
            double Tr = temperature / this.getComponent().getTC();
            return Math.pow(1.0 + this.parameters[0] * (1.0 - Math.sqrt(Tr)) + this.parameters[1] * Math.pow(1.0 - Math.sqrt(Tr), 2.0) + this.parameters[2] * Math.pow(1.0 - Math.sqrt(Tr), 4.0), 2.0);
        }
        return super.alpha(temperature);
    }

    @Override
    public double aT(double temperature) {
        if (this.getComponent().getName().equals("water")) {
            return this.getComponent().geta() * this.alpha(temperature);
        }
        return super.aT(temperature);
    }

    public double diffalphaTGERG(double temperature) {
        if (temperature < 273.15) {
            System.arraycopy(this.parametersSolidGERG, 0, this.parameters, 0, this.parametersSolidGERG.length);
        } else {
            System.arraycopy(this.parametersGERG, 0, this.parameters, 0, this.parametersGERG.length);
        }
        double Tr = temperature / this.getComponent().getTC();
        double TC = this.getComponent().getTC();
        return 2.0 * (1.0 + this.parameters[0] * (1.0 - Math.sqrt(Tr)) + this.parameters[1] * Math.pow(1.0 - Math.sqrt(Tr), 2.0) + this.parameters[2] * Math.pow(1.0 - Math.sqrt(Tr), 3.0)) * (-this.parameters[0] / Math.sqrt(Tr) / TC / 2.0 - this.parameters[1] * (1.0 - Math.sqrt(Tr)) / Math.sqrt(Tr) / TC - 1.5 * this.parameters[2] * Math.pow(1.0 - Math.sqrt(Tr), 2.0) / Math.sqrt(Tr) / TC);
    }

    public double diffdiffalphaTGERG(double temperature) {
        if (temperature < 273.15) {
            System.arraycopy(this.parametersSolidGERG, 0, this.parameters, 0, this.parametersSolidGERG.length);
        } else {
            System.arraycopy(this.parametersGERG, 0, this.parameters, 0, this.parametersGERG.length);
        }
        double Tr = temperature / this.getComponent().getTC();
        double TC = this.getComponent().getTC();
        return 2.0 * Math.pow(-this.parameters[0] / Math.sqrt(Tr) / TC / 2.0 - this.parameters[1] * (1.0 - Math.sqrt(Tr)) / Math.sqrt(Tr) / TC - 1.5 * this.parameters[2] * Math.pow(1.0 - Math.sqrt(Tr), 2.0) / Math.sqrt(Tr) / TC, 2.0) + 2.0 * (1.0 + this.parameters[0] * (1.0 - Math.sqrt(Tr)) + this.parameters[1] * Math.pow(1.0 - Math.sqrt(Tr), 2.0) + this.parameters[2] * Math.pow(1.0 - Math.sqrt(Tr), 3.0)) * (this.parameters[0] / Math.sqrt(Tr * Tr * Tr) / (TC * TC) / 4.0 + this.parameters[1] / temperature / TC / 2.0 + this.parameters[1] * (1.0 - Math.sqrt(Tr)) / Math.sqrt(Tr * Tr * Tr) / (TC * TC) / 2.0 + 1.5 * this.parameters[2] * (1.0 - Math.sqrt(Tr)) / temperature / TC + 0.75 * this.parameters[2] * Math.pow(1.0 - Math.sqrt(Tr), 2.0) / Math.sqrt(Tr * Tr * Tr) / (TC * TC));
    }

    @Override
    public double diffaT(double temperature) {
        if (this.getComponent().getName().equals("water")) {
            return this.getComponent().geta() * this.diffalphaTGERG(temperature);
        }
        return super.diffaT(temperature);
    }

    @Override
    public double diffdiffaT(double temperature) {
        if (this.getComponent().getName().equals("water")) {
            return this.getComponent().geta() * this.diffdiffalphaTGERG(temperature);
        }
        return super.diffdiffaT(temperature);
    }
}

