/*
 * Decompiled with CFR 0.152.
 */
package neqsim.statistics.parameterFitting.nonLinearParameterFitting;

import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;

public class LevenbergMarquardtBiasDev
extends LevenbergMarquardt {
    @Override
    public LevenbergMarquardtBiasDev clone() {
        LevenbergMarquardtBiasDev clonedClass = null;
        try {
            clonedClass = (LevenbergMarquardtBiasDev)super.clone();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return clonedClass;
    }

    @Override
    public double calcChiSquare() {
        double chiSquare = 0.0;
        for (int i = 0; i < this.sampleSet.getLength(); ++i) {
            chiSquare += (this.sampleSet.getSample(i).getSampleValue() - this.calcValue(this.sampleSet.getSample(i))) / this.sampleSet.getSample(i).getStandardDeviation();
        }
        return chiSquare;
    }

    @Override
    public double[][] calcAlphaMatrix() {
        double[][] alpha = new double[this.sampleSet.getSample(0).getFunction().getFittingParams().length][this.sampleSet.getSample(0).getFunction().getFittingParams().length];
        for (int i = 0; i < alpha.length; ++i) {
            for (int j = 0; j < alpha[0].length; ++j) {
                alpha[i][j] = 0.0;
                for (int k = 0; k < this.sampleSet.getLength(); ++k) {
                    double[] dArray = alpha[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.dyda[k][i] * this.dyda[k][j] / this.sampleSet.getSample(k).getStandardDeviation();
                }
                if (i != j) continue;
                double[] dArray = alpha[i];
                int n = j;
                dArray[n] = dArray[n] * (1.0 + this.multiFactor);
            }
        }
        return alpha;
    }

    @Override
    public double[] calcBetaMatrix() {
        double[] beta = new double[this.sampleSet.getSample(0).getFunction().getFittingParams().length];
        for (int i = 0; i < beta.length; ++i) {
            beta[i] = 0.0;
            for (int j = 0; j < this.sampleSet.getLength(); ++j) {
                int n = i;
                beta[n] = beta[n] + (this.sampleSet.getSample(j).getSampleValue() - this.calcValue(this.sampleSet.getSample(j))) / this.sampleSet.getSample(j).getStandardDeviation() * this.dyda[j][i];
            }
        }
        return beta;
    }
}

