/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processSystem;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import neqsim.dataPresentation.fileHandeling.createTextFile.TextFile;
import neqsim.processSimulation.SimulationBaseClass;
import neqsim.processSimulation.conditionMonitor.ConditionMonitor;
import neqsim.processSimulation.costEstimation.CostEstimateBaseClass;
import neqsim.processSimulation.measurementDevice.MeasurementDeviceInterface;
import neqsim.processSimulation.mechanicalDesign.SystemMechanicalDesign;
import neqsim.processSimulation.processEquipment.ProcessEquipmentBaseClass;
import neqsim.processSimulation.processEquipment.ProcessEquipmentInterface;
import neqsim.processSimulation.processEquipment.compressor.Compressor;
import neqsim.processSimulation.processEquipment.heatExchanger.Cooler;
import neqsim.processSimulation.processEquipment.heatExchanger.Heater;
import neqsim.processSimulation.processEquipment.pump.Pump;
import neqsim.processSimulation.processEquipment.util.Adjuster;
import neqsim.processSimulation.processEquipment.util.Recycle;
import neqsim.processSimulation.processEquipment.util.RecycleController;
import neqsim.processSimulation.processSystem.ModuleInterface;
import neqsim.thermo.system.SystemInterface;
import org.apache.commons.lang.SerializationUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProcessSystem
extends SimulationBaseClass {
    private static final long serialVersionUID = 1000L;
    transient Thread thisThread;
    String[][] signalDB = new String[1000][100];
    private double surroundingTemperature = 288.15;
    private int timeStepNumber = 0;
    private ArrayList<ProcessEquipmentInterface> unitOperations = new ArrayList(0);
    ArrayList<MeasurementDeviceInterface> measurementDevices = new ArrayList(0);
    RecycleController recycleController = new RecycleController();
    private double timeStep = 1.0;
    static Logger logger = LogManager.getLogger(ProcessSystem.class);

    public ProcessSystem() {
        this("Process system");
    }

    public ProcessSystem(String name) {
        super(name);
    }

    public void add(ProcessEquipmentInterface operation) {
        ArrayList<ProcessEquipmentInterface> units = this.getUnitOperations();
        for (ProcessEquipmentInterface unit : units) {
            if (unit != operation) continue;
            return;
        }
        if (this.getAllUnitNames().contains(operation.getName())) {
            String currClass = operation.getClass().getSimpleName();
            int num = 1;
            for (ProcessEquipmentInterface unit : units) {
                if (!unit.getClass().getSimpleName().equals(currClass)) continue;
                ++num;
            }
            operation.setName(currClass + Integer.toString(num));
        }
        this.getUnitOperations().add(operation);
        if (operation instanceof ModuleInterface) {
            ((ModuleInterface)operation).initializeModule();
        }
    }

    public void add(MeasurementDeviceInterface measurementDevice) {
        this.measurementDevices.add(measurementDevice);
    }

    public void add(ProcessEquipmentInterface[] operations) {
        this.getUnitOperations().addAll(Arrays.asList(operations));
    }

    public Object getUnit(String name) {
        for (int i = 0; i < this.getUnitOperations().size(); ++i) {
            if (this.getUnitOperations().get(i) instanceof ModuleInterface) {
                for (int j = 0; j < ((ModuleInterface)this.getUnitOperations().get(i)).getOperations().getUnitOperations().size(); ++j) {
                    if (!((ModuleInterface)this.getUnitOperations().get(i)).getOperations().getUnitOperations().get(j).getName().equals(name)) continue;
                    return ((ModuleInterface)this.getUnitOperations().get(i)).getOperations().getUnitOperations().get(j);
                }
                continue;
            }
            if (!this.getUnitOperations().get(i).getName().equals(name)) continue;
            return this.getUnitOperations().get(i);
        }
        return null;
    }

    public boolean hasUnitName(String name) {
        return this.getUnit(name) != null;
    }

    public Object getMeasurementDevice(String name) {
        for (int i = 0; i < this.measurementDevices.size(); ++i) {
            if (!this.measurementDevices.get(i).getName().equals(name)) continue;
            return this.measurementDevices.get(i);
        }
        return null;
    }

    public int getUnitNumber(String name) {
        for (int i = 0; i < this.getUnitOperations().size(); ++i) {
            if (this.getUnitOperations().get(i) instanceof ModuleInterface) {
                for (int j = 0; j < ((ModuleInterface)this.getUnitOperations().get(i)).getOperations().getUnitOperations().size(); ++j) {
                    if (!((ModuleInterface)this.getUnitOperations().get(i)).getOperations().getUnitOperations().get(j).getName().equals(name)) continue;
                    return j;
                }
                continue;
            }
            if (!this.getUnitOperations().get(i).getName().equals(name)) continue;
            return i;
        }
        return 0;
    }

    public void replaceObject(String unitName, ProcessEquipmentBaseClass operation) {
        this.unitOperations.set(this.getUnitNumber(this.name), operation);
    }

    public ArrayList<String> getAllUnitNames() {
        ArrayList<String> unitNames = new ArrayList<String>();
        for (int i = 0; i < this.getUnitOperations().size(); ++i) {
            if (this.getUnitOperations().get(i) instanceof ModuleInterface) {
                for (int j = 0; j < ((ModuleInterface)this.getUnitOperations().get(i)).getOperations().getUnitOperations().size(); ++j) {
                    unitNames.add(((ModuleInterface)this.getUnitOperations().get(i)).getOperations().getUnitOperations().get(j).getName());
                }
            }
            unitNames.add(this.unitOperations.get(i).getName());
        }
        return unitNames;
    }

    public ArrayList<ProcessEquipmentInterface> getUnitOperations() {
        return this.unitOperations;
    }

    public void removeUnit(String name) {
        for (int i = 0; i < this.unitOperations.size(); ++i) {
            if (!this.unitOperations.get(i).getName().equals(name)) continue;
            this.unitOperations.remove(i);
        }
    }

    public void clearAll() {
        this.unitOperations = new ArrayList(0);
    }

    public void clear() {
        this.unitOperations = new ArrayList(0);
    }

    public void setFluid(SystemInterface fluid1, SystemInterface fluid2, boolean addNewComponents) {
        fluid1.setEmptyFluid();
        boolean addedComps = false;
        for (int i = 0; i < fluid2.getNumberOfComponents(); ++i) {
            if (fluid1.getPhase(0).hasComponent(fluid2.getComponent(i).getName())) {
                fluid1.addComponent(fluid2.getComponent(i).getName(), fluid2.getComponent(i).getNumberOfmoles());
                continue;
            }
            if (!addNewComponents) continue;
            addedComps = true;
            if (fluid2.getComponent(i).isIsTBPfraction() || fluid2.getComponent(i).isIsPlusFraction()) {
                fluid1.addTBPfraction(fluid2.getComponent(i).getName(), fluid2.getComponent(i).getNumberOfmoles(), fluid2.getComponent(i).getMolarMass(), fluid2.getComponent(i).getNormalLiquidDensity());
                continue;
            }
            fluid1.addComponent(fluid2.getComponent(i).getName(), fluid2.getComponent(i).getNumberOfmoles());
        }
        if (addedComps) {
            fluid1.createDatabase(true);
        }
        fluid1.init(0);
        fluid1.setTemperature(fluid2.getTemperature());
        fluid1.setPressure(fluid2.getPressure());
    }

    public void setFluid(SystemInterface fluid1, SystemInterface fluid2) {
        fluid1.setEmptyFluid();
        boolean addedComps = false;
        for (int i = 0; i < fluid2.getNumberOfComponents(); ++i) {
            if (fluid1.getPhase(0).hasComponent(fluid2.getComponent(i).getName())) {
                fluid1.addComponent(fluid2.getComponent(i).getName(), fluid2.getComponent(i).getNumberOfmoles());
                continue;
            }
            addedComps = true;
            if (fluid2.getComponent(i).isIsTBPfraction() || fluid2.getComponent(i).isIsPlusFraction()) {
                fluid1.addTBPfraction(fluid2.getComponent(i).getName(), fluid2.getComponent(i).getNumberOfmoles(), fluid2.getComponent(i).getMolarMass(), fluid2.getComponent(i).getNormalLiquidDensity());
                continue;
            }
            fluid1.addComponent(fluid2.getComponent(i).getName(), fluid2.getComponent(i).getNumberOfmoles());
        }
        if (addedComps) {
            fluid1.createDatabase(true);
        }
        fluid1.init(0);
        fluid1.setTemperature(fluid2.getTemperature());
        fluid1.setPressure(fluid2.getPressure());
    }

    public Thread runAsThread() {
        Thread processThread = new Thread(this);
        processThread.start();
        return processThread;
    }

    @Override
    public void run(UUID id) {
        int i;
        boolean hasResycle = false;
        this.recycleController.clear();
        for (int i2 = 0; i2 < this.unitOperations.size(); ++i2) {
            if (this.unitOperations.get(i2).getClass().getSimpleName().equals("Recycle")) {
                hasResycle = true;
                this.recycleController.addRecycle((Recycle)this.unitOperations.get(i2));
            }
            if (!this.unitOperations.get(i2).getClass().getSimpleName().equals("Adjuster")) continue;
        }
        this.recycleController.init();
        boolean isConverged = true;
        int iter = 0;
        block5: do {
            ++iter;
            isConverged = true;
            for (i = 0; i < this.unitOperations.size(); ++i) {
                if (!this.unitOperations.get(i).getClass().getSimpleName().equals("Recycle")) {
                    try {
                        this.unitOperations.get(i).run();
                    }
                    catch (Exception ex) {
                        logger.error(ex.getMessage());
                    }
                }
                if (!this.unitOperations.get(i).getClass().getSimpleName().equals("Recycle") || !this.recycleController.doSolveRecycle((Recycle)this.unitOperations.get(i))) continue;
                try {
                    this.unitOperations.get(i).run();
                    continue;
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage());
                }
            }
            if (!this.recycleController.solvedAll() || this.recycleController.hasHigherPriorityLevel()) {
                isConverged = false;
            }
            if (this.recycleController.solvedCurrentPriorityLevel()) {
                this.recycleController.nextPriorityLevel();
            } else if (this.recycleController.hasLoverPriorityLevel() && !this.recycleController.solvedAll()) {
                this.recycleController.resetPriorityLevel();
            }
            for (i = 0; i < this.unitOperations.size(); ++i) {
                if (!this.unitOperations.get(i).getClass().getSimpleName().equals("Adjuster") || ((Adjuster)this.unitOperations.get(i)).solved()) continue;
                isConverged = false;
                continue block5;
            }
        } while ((!isConverged || iter < 2 && hasResycle) && iter < 100);
        for (i = 0; i < this.unitOperations.size(); ++i) {
            this.unitOperations.get(i).setCalculationIdentifier(id);
        }
        this.setCalculationIdentifier(id);
    }

    public void runTransient() {
        this.runTransient(this.getTimeStep(), UUID.randomUUID());
    }

    @Override
    public void runTransient(double dt, UUID id) {
        int i;
        this.setTimeStep(dt);
        this.increaseTime(dt);
        for (i = 0; i < this.unitOperations.size(); ++i) {
            this.unitOperations.get(i).runTransient(dt, id);
        }
        ++this.timeStepNumber;
        this.signalDB[this.timeStepNumber] = new String[1 + 3 * this.measurementDevices.size()];
        for (i = 0; i < this.measurementDevices.size(); ++i) {
            this.signalDB[this.timeStepNumber][0] = Double.toString(this.time);
            this.signalDB[this.timeStepNumber][3 * i + 1] = this.measurementDevices.get(i).getName();
            this.signalDB[this.timeStepNumber][3 * i + 2] = Double.toString(this.measurementDevices.get(i).getMeasuredValue());
            this.signalDB[this.timeStepNumber][3 * i + 3] = this.measurementDevices.get(i).getUnit();
        }
        this.setCalculationIdentifier(id);
    }

    @Override
    public boolean solved() {
        return true;
    }

    @Override
    public double getTime() {
        return this.time;
    }

    public double getTime(String unit) {
        if (unit.equals("sec")) {
            return this.time;
        }
        if (unit.equals("hr")) {
            return this.time / 3600.0;
        }
        if (unit.equals("day")) {
            return this.time / 86400.0;
        }
        if (unit.equals("year")) {
            return this.time / 3.1536E7;
        }
        return this.time;
    }

    public int size() {
        return this.unitOperations.size();
    }

    public void view() {
        this.displayResult();
    }

    public void displayResult() {
        try {
            this.thisThread.join();
        }
        catch (Exception ex) {
            System.out.println("Thread did not finish");
        }
        for (int i = 0; i < this.unitOperations.size(); ++i) {
            this.unitOperations.get(i).displayResult();
        }
    }

    public void reportMeasuredValues() {
        try {
            this.thisThread.join();
        }
        catch (Exception ex) {
            System.out.println("Thread did not finish");
        }
        for (int i = 0; i < this.measurementDevices.size(); ++i) {
            System.out.println("Measurements Device Name: " + this.measurementDevices.get(i).getName());
            System.out.println("Value: " + this.measurementDevices.get(i).getMeasuredValue() + " " + this.measurementDevices.get(i).getUnit());
            if (!this.measurementDevices.get(i).isOnlineSignal()) continue;
            System.out.println("Online value: " + this.measurementDevices.get(i).getOnlineSignal().getValue() + " " + this.measurementDevices.get(i).getOnlineSignal().getUnit());
        }
    }

    public void save(String filePath) {
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(filePath, false));){
            out.writeObject(this);
            logger.info("process file saved to:  " + filePath);
        }
        catch (Exception ex) {
            logger.error(ex.toString());
            logger.error(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ProcessSystem open(String filePath) {
        try (ObjectInputStream objectinputstream = new ObjectInputStream(new FileInputStream(filePath));){
            ProcessSystem processSystem = (ProcessSystem)objectinputstream.readObject();
            return processSystem;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            return null;
        }
    }

    public String[][] reportResults() {
        String[][] text = new String[200][];
        int numb = 0;
        for (int i = 0; i < this.unitOperations.size(); ++i) {
            for (int k = 0; k < this.unitOperations.get(i).reportResults().length; ++k) {
                text[numb++] = this.unitOperations.get(i).reportResults()[k];
            }
        }
        return text;
    }

    public void printLogFile(String filename) {
        TextFile tempFile = new TextFile();
        tempFile.setOutputFileName(filename);
        tempFile.setValues(this.signalDB);
        tempFile.createFile();
    }

    public double getTimeStep() {
        return this.timeStep;
    }

    public void setTimeStep(double timeStep) {
        this.timeStep = timeStep;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public SystemMechanicalDesign getSystemMechanicalDesign() {
        return new SystemMechanicalDesign(this);
    }

    public CostEstimateBaseClass getCostEstimator() {
        return new CostEstimateBaseClass(this);
    }

    public double getEntropyProduction(String unit) {
        double entropyProduction = 0.0;
        for (int i = 0; i < this.unitOperations.size(); ++i) {
            entropyProduction += this.unitOperations.get(i).getEntropyProduction(unit);
            System.out.println("unit " + this.unitOperations.get(i).getName() + " entropy production " + this.unitOperations.get(i).getEntropyProduction(unit));
        }
        return entropyProduction;
    }

    public double getExergyChange(String unit) {
        double exergyChange = 0.0;
        for (int i = 0; i < this.unitOperations.size(); ++i) {
            exergyChange += this.unitOperations.get(i).getExergyChange("J", this.getSurroundingTemperature());
            System.out.println("unit " + this.unitOperations.get(i).getName() + " exergy change  " + this.unitOperations.get(i).getExergyChange("J", this.getSurroundingTemperature()));
        }
        return exergyChange;
    }

    public double getPower(String unit) {
        double power = 0.0;
        for (int i = 0; i < this.unitOperations.size(); ++i) {
            if (this.unitOperations.get(i).getClass().getSimpleName().equals("Compressor")) {
                power += ((Compressor)this.unitOperations.get(i)).getPower();
                continue;
            }
            if (!this.unitOperations.get(i).getClass().getSimpleName().equals("Pump")) continue;
            power += ((Pump)this.unitOperations.get(i)).getPower();
        }
        if (unit.equals("MW")) {
            return power / 1000000.0;
        }
        if (unit.equals("kW")) {
            return power / 1000.0;
        }
        return power;
    }

    public double getCoolerDuty(String unit) {
        double heat = 0.0;
        for (int i = 0; i < this.unitOperations.size(); ++i) {
            if (!this.unitOperations.get(i).getClass().getSimpleName().equals("Cooler")) continue;
            heat += ((Cooler)this.unitOperations.get(i)).getDuty();
        }
        return heat;
    }

    public double getHeaterDuty(String unit) {
        double heat = 0.0;
        for (int i = 0; i < this.unitOperations.size(); ++i) {
            if (!this.unitOperations.get(i).getClass().getSimpleName().equals("Heater")) continue;
            heat += ((Heater)this.unitOperations.get(i)).getDuty();
        }
        return heat;
    }

    public double getMechanicalWeight(String unit) {
        double weight = 0.0;
        for (int i = 0; i < this.unitOperations.size(); ++i) {
            this.unitOperations.get(i).getMechanicalDesign().calcDesign();
            System.out.println("Name " + this.unitOperations.get(i).getName() + "  weight " + this.unitOperations.get(i).getMechanicalDesign().getWeightTotal());
            weight += this.unitOperations.get(i).getMechanicalDesign().getWeightTotal();
        }
        return weight;
    }

    public double getSurroundingTemperature() {
        return this.surroundingTemperature;
    }

    public void setSurroundingTemperature(double surroundingTemperature) {
        this.surroundingTemperature = surroundingTemperature;
    }

    public ProcessSystem copy() {
        byte[] bytes = SerializationUtils.serialize(this);
        ProcessSystem copyOperation = (ProcessSystem)SerializationUtils.deserialize(bytes);
        return copyOperation;
    }

    public ConditionMonitor getConditionMonitor() {
        return new ConditionMonitor(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.deepHashCode((Object[])this.signalDB);
        result = 31 * result + Objects.hash(this.measurementDevices, this.name, this.recycleController, this.surroundingTemperature, this.time, this.timeStep, this.timeStepNumber, this.unitOperations);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessSystem other = (ProcessSystem)obj;
        return Objects.equals(this.measurementDevices, other.measurementDevices) && Objects.equals(this.name, other.name) && Objects.equals(this.recycleController, other.recycleController) && Arrays.deepEquals((Object[])this.signalDB, (Object[])other.signalDB) && Double.doubleToLongBits(this.surroundingTemperature) == Double.doubleToLongBits(other.surroundingTemperature) && Double.doubleToLongBits(this.time) == Double.doubleToLongBits(other.time) && Double.doubleToLongBits(this.timeStep) == Double.doubleToLongBits(other.timeStep) && this.timeStepNumber == other.timeStepNumber && Objects.equals(this.unitOperations, other.unitOperations);
    }
}

