/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.util;

import java.util.UUID;
import neqsim.processSimulation.processEquipment.TwoPortEquipment;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class StreamSaturatorUtil
extends TwoPortEquipment {
    private static final long serialVersionUID = 1000L;
    SystemInterface thermoSystem;
    private boolean multiPhase = true;
    private double approachToSaturation = 1.0;

    @Deprecated
    public StreamSaturatorUtil(StreamInterface inletStream) {
        this("StreamSaturatorUtil", inletStream);
    }

    public StreamSaturatorUtil(String name, StreamInterface inStream) {
        super(name);
        this.setInletStream(inStream);
    }

    @Override
    public void setInletStream(StreamInterface inletStream) {
        this.inStream = inletStream;
        this.thermoSystem = inletStream.getThermoSystem().clone();
        this.outStream = new Stream("outStream", this.thermoSystem);
    }

    @Override
    public void run(UUID id) {
        boolean changeBack = false;
        this.thermoSystem = this.inStream.getThermoSystem().clone();
        if (this.multiPhase && !this.thermoSystem.doMultiPhaseCheck()) {
            this.thermoSystem.setMultiPhaseCheck(true);
            changeBack = true;
        }
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.thermoSystem);
        thermoOps.saturateWithWater();
        if (this.thermoSystem.getPhase(0).hasComponent("water") && this.approachToSaturation < 1.0) {
            try {
                this.thermoSystem.addComponent("water", -this.thermoSystem.getComponent("water").getNumberOfmoles() * (1.0 - this.approachToSaturation));
                thermoOps.TPflash();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.thermoSystem.init(3);
        if (changeBack) {
            this.thermoSystem.setMultiPhaseCheck(false);
        }
        this.outStream.setThermoSystem(this.thermoSystem);
        this.setCalculationIdentifier(id);
    }

    public boolean isMultiPhase() {
        return this.multiPhase;
    }

    public void setMultiPhase(boolean multiPhase) {
        this.multiPhase = multiPhase;
    }

    public void setApprachToSaturation(double approachToSaturation) {
        this.approachToSaturation = approachToSaturation;
    }
}

